package com.ovopark.jobhub.sdk.client;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

import static com.ovopark.kernel.shared.Util.newThreadFactory;

public interface JobLog extends com.ovopark.kernel.shared.vclient.JobLog {

    ExecutorService jobLogExecutor = new ThreadPoolExecutor(
            Math.max(Math.min(Runtime.getRuntime().availableProcessors() * 2,16)
                    , Integer.parseInt(System.getProperty("JOBHUB_JOB_LOG_IO", "0")))
            , Math.max(Math.max(Runtime.getRuntime().availableProcessors() * 2,64)
            , Integer.parseInt(System.getProperty("JOBHUB_JOB_LOG_IO", "0")))
            , 600, TimeUnit.SECONDS
            //Integer.MAX_VALUE ???
            , new LinkedBlockingQueue(1)
            , newThreadFactory("jobhub-job-log-io")
            , new ThreadPoolExecutor.CallerRunsPolicy());



    static JobLog noopIfNull(JobLog jobLog){
        return jobLog==null?NoopJobLogImpl.NOOP:jobLog;
    }


    class NoopJobLogImpl implements JobLog{

        static NoopJobLogImpl NOOP=new NoopJobLogImpl();

        @Override
        public void log(String content) {

        }

        @Override
        public void log(Supplier<String> content) {

        }

        @Override
        public void flush() {

        }

        @Override
        public void flush(boolean sync) {

        }

        @Override
        public void close() {

        }
    }

}
