package com.ovopark.jobhub.sdk.client.kafka;

import com.ovopark.jobhub.sdk.client.JobClientActive;
import com.ovopark.jobhub.sdk.model.TaskCaptureRequest;
import com.ovopark.jobhub.sdk.model.TaskCaptureResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import static com.ovopark.kernel.shared.Util.dateTime;
import static com.ovopark.kernel.shared.Util.formatTime;

@JobClientActive
@Slf4j
@RestController("com.ovopark.jobhub.sdk.client.kafka.TaskEndpoint")
@RequestMapping("/feign/jobhub-job/processing")
public class TaskEndpoint {

    @Autowired
    TaskListenerRunnerViaKafkaProvider taskListenerRunnerViaKafkaProvider;

    @RequestMapping("/captureTask")
    @ResponseBody
    public TaskCaptureResponse captureTask(@RequestBody TaskCaptureRequest taskCaptureRequest){
        TaskCaptureResponse taskCaptureResponse =new TaskCaptureResponse();
        taskCaptureResponse.setSuccess(true);
        String containerId = taskCaptureRequest.getContainerId();
        int partition = taskCaptureRequest.getPartition();
        TaskListenerRunnerViaKafkaProvider.RecordInfo recordInfo = taskListenerRunnerViaKafkaProvider.get(containerId, String.valueOf(partition));
        if (recordInfo==null) {
            taskCaptureResponse.setFound(false);
            return taskCaptureResponse;
        }

        taskCaptureResponse.setFound(true);
        taskCaptureResponse.setCaptureTaskIdInES(taskCaptureRequest.getTaskIdInES());
        //---
        taskCaptureResponse.setTask(recordInfo.getTask());
        taskCaptureResponse.setHeartbeatData(recordInfo.getHeartbeatData());

        taskCaptureResponse.setStartTime(recordInfo.getStartTime());
        taskCaptureResponse.setStartTimeStr(formatTime(dateTime(recordInfo.getStartTime())));

        if (taskCaptureRequest.isCaptureStack()) {
            Thread ioThread = recordInfo.getIoThread();
            if (ioThread != null) {
                StackTraceElement[] stackTraceElements = ioThread.getStackTrace();
                List<String> stackList=new ArrayList<>(stackTraceElements.length);
                for (StackTraceElement stackTraceElement : stackTraceElements) {
                    stackList.add(stackTraceElement.toString());
                }

                taskCaptureResponse.setIoThread(ioThread.getName());
                taskCaptureResponse.setIoStackList(stackList);
            }

            Map<String, Object> subCapture = recordInfo.taskContext.capture();
            taskCaptureResponse.setSubCapture(subCapture);
        }

        return taskCaptureResponse;
    }

}

