package com.ovopark.jobhub.sdk.client.kafka;

import com.ovopark.jobhub.sdk.client.JobClientActive;
import com.ovopark.jobhub.sdk.model.TaskCaptureRequest;
import com.ovopark.jobhub.sdk.model.TaskCaptureResponse;
import com.ovopark.jobhub.sdk.model.TaskGetResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import static com.ovopark.kernel.shared.Util.dateTime;
import static com.ovopark.kernel.shared.Util.formatTime;

@JobClientActive
@Slf4j
@RestController("com.ovopark.jobhub.sdk.client.kafka.TaskEndpoint")
@RequestMapping("/feign/jobhub-job/processing")
public class TaskEndpoint {

    @Autowired
    TaskListenerRunnerViaKafkaProvider taskListenerRunnerViaKafkaProvider;

    @RequestMapping("/captureTask")
    @ResponseBody
    public TaskCaptureResponse captureTask(@RequestBody TaskCaptureRequest taskCaptureRequest){
        TaskCaptureResponse taskCaptureResponse =new TaskCaptureResponse();
        taskCaptureResponse.setSuccess(true);
        String containerId = taskCaptureRequest.getContainerId();
        int partition = taskCaptureRequest.getPartition();
        TaskListenerRunnerViaKafkaProvider.TopicPartitionContext topicPartitionContext = taskListenerRunnerViaKafkaProvider.get(containerId, String.valueOf(partition));
        if (topicPartitionContext ==null) {
            taskCaptureResponse.setFound(false);
            return taskCaptureResponse;
        }

        TaskListenerRunnerViaKafkaProvider.KafkaTaskContext kafkaTaskContext = topicPartitionContext.kafkaTaskContext;
        TaskGetResponse.Task task = kafkaTaskContext.task();
        taskCaptureResponse.setFound(true);
        taskCaptureResponse.setCaptureTaskIdInES(taskCaptureRequest.getTaskIdInES());
        //---
        taskCaptureResponse.setTask(task);
        taskCaptureResponse.setHeartbeatData(topicPartitionContext.getHeartbeatData());

        taskCaptureResponse.setStartTime(topicPartitionContext.getStartTime());
        taskCaptureResponse.setStartTimeStr(formatTime(dateTime(topicPartitionContext.getStartTime())));

        if (taskCaptureRequest.isCaptureStack()) {
            Thread ioThread = topicPartitionContext.getIoThread();
            if (ioThread != null) {
                StackTraceElement[] stackTraceElements = ioThread.getStackTrace();
                List<String> stackList=new ArrayList<>(stackTraceElements.length);
                for (StackTraceElement stackTraceElement : stackTraceElements) {
                    stackList.add(stackTraceElement.toString());
                }

                taskCaptureResponse.setIoThread(ioThread.getName()+"@"+ioThread.hashCode());
                taskCaptureResponse.setIoStackList(stackList);
            }

            Map<String, Object> subCapture = kafkaTaskContext.capture();
            taskCaptureResponse.setSubCapture(subCapture);
        }

        return taskCaptureResponse;
    }

}

