package com.ovopark.jobhub.sdk.client;


import com.ovopark.jobhub.sdk.model.*;
import com.ovopark.jobhub.sdk.model.internal.job.*;
import com.ovopark.kernel.shared.vclient.Client2ServerTransport;
import com.ovopark.module.shared.BaseResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;


@FeignClient(value = "jobhub-control"
        ,url = "127.0.0.1:13570"
)
public interface JobHubJobApi {

    @PostMapping("/jobhub-control/feign/delay/cronJob/jobClient/heartbeat")
    BaseResult<ClientNodeRegisterResponse> heartbeat(@RequestBody ClientNodeRegisterRequest clientNodeRegisterRequest);

    @PostMapping("/jobhub-control/feign/delay/cronJob/jobClient/lockClient")
    BaseResult<TaskLockResponse> lockClient(@RequestBody TaskLockRequest taskLockRequest);

    @PostMapping("/jobhub-control/feign/delay/cronJob/jobClient/log")
    BaseResult<Client2ServerTransport.TaskLogResponse> log(@RequestBody Client2ServerTransport.TaskLogRequest taskLogRequest);

    @PostMapping("/jobhub-control/feign/delay/cronJob/jobClient/saveCronTask")
    BaseResult<CronTaskSaveResponse> saveCronTask(@RequestBody CronTaskSaveRequest cronTaskSaveRequest);

    @PostMapping("/jobhub-control/feign/delay/delayJob/jobClient/saveDelayTask")
    BaseResult<DelayTaskSaveResponse> saveDelayTask(@RequestBody DelayTaskSaveRequest delayTaskSaveRequest);

    @PostMapping("/jobhub-control/feign/job/jobCreate")
    BaseResult<JobCreateResponse> jobCreate(@RequestBody JobCreateRequest jobCreateRequest);

    @PostMapping("/jobhub-control/feign/job/taskCreate")
    BaseResult<TaskCreateResponse> taskCreate(@RequestBody TaskCreateRequest taskCreateRequest);

    @PostMapping("/jobhub-control/feign/job/taskUpdate")
    BaseResult<TaskUpdateResponse> taskUpdate(@RequestBody TaskUpdateRequest taskUpdateRequest);

    @PostMapping("/jobhub-control/feign/job/taskLog")
    BaseResult<TaskLogResponse> taskLog(@RequestBody TaskLogRequest taskLogRequest);

    @PostMapping("/jobhub-control/feign/job/taskGet")
    BaseResult<TaskGetResponse> taskGet(@RequestBody TaskGetRequest taskGetRequest);

    @PostMapping("/jobhub-control/feign/job/taskMetaGet")
    BaseResult<TaskMetaGetResponse> taskMetaGet(@RequestBody TaskMetaGetRequest taskMetaGetRequest);

}
