/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.jobhub.sdk.client;

import com.ovopark.jobhub.sdk.client.JobService;
import com.ovopark.jobhub.sdk.client.JobServiceImpl;
import com.ovopark.jobhub.sdk.model.JobStatus;
import com.ovopark.jobhub.sdk.model.TaskGetRequest;
import com.ovopark.jobhub.sdk.model.TaskGetResponse;
import com.ovopark.jobhub.sdk.model.TaskLogRequest;
import com.ovopark.jobhub.sdk.model.TaskLogResponse;
import com.ovopark.jobhub.sdk.model.TaskUpdateRequest;
import com.ovopark.jobhub.sdk.model.TaskUpdateResponse;
import com.ovopark.kernel.shared.Config;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TaskListenerRunnerViaHttpProvider
implements JobService.TaskListenerRunnerProvider {
    private static final Logger log = LoggerFactory.getLogger(TaskListenerRunnerViaHttpProvider.class);
    Map<String, FetchThenExecTaskViaHttp> fetchThenExecTaskMap = new ConcurrentHashMap<String, FetchThenExecTaskViaHttp>();
    private static final ScheduledExecutorService fetchThenExecExecutor = new ScheduledThreadPoolExecutor(Config.ConfigPriority.option().getInt("JOBHUB_FETCH_IO", Integer.valueOf(200)), Util.newThreadFactory((String)"jobhub-fetch-io"), new ThreadPoolExecutor.AbortPolicy());

    public String name() {
        return "http";
    }

    public boolean start(final String jobType, final String beanUrl, final String group, final Long minVer, final JobService.TaskListener taskListener, final JobService jobService, JobService.TaskListenerRunnerProviderConfig taskListenerRunnerProviderConfig) {
        final String key = beanUrl + ":" + jobType + ":" + group;
        FetchThenExecTaskViaHttp fetchThenExecTask = (FetchThenExecTaskViaHttp)Util.lock((Comparable)((Object)key), (Callable)new Callable<FetchThenExecTaskViaHttp>(){

            @Override
            public FetchThenExecTaskViaHttp call() throws Exception {
                if (TaskListenerRunnerViaHttpProvider.this.fetchThenExecTaskMap.containsKey(key)) {
                    log.info(key + " already registered");
                    return null;
                }
                FetchThenExecTaskViaHttp fetchThenExecTask = new FetchThenExecTaskViaHttp(jobType, beanUrl, group, minVer, taskListener, jobService);
                return fetchThenExecTask;
            }
        });
        if (fetchThenExecTask != null) {
            try {
                fetchThenExecExecutor.scheduleWithFixedDelay(Util.catchRunnable((Util.CatchRunnable)fetchThenExecTask), 0L, 5L, TimeUnit.SECONDS);
            }
            catch (RejectedExecutionException e) {
                return false;
            }
            return true;
        }
        return false;
    }

    public void close() {
    }

    public class FetchThenExecTaskViaHttp
    implements Util.CatchRunnable {
        final String jobType;
        final String beanUrl;
        final String group;
        final Long minVer;
        final JobService.TaskListener jobTaskListener;
        final String id = Util.uniqueFirstPart();
        final JobService jobService;

        public FetchThenExecTaskViaHttp(String jobType, String beanUrl, String group, Long minVer, JobService.TaskListener jobTaskListener, JobService jobService) {
            this.jobType = jobType;
            this.beanUrl = beanUrl;
            this.group = group;
            this.minVer = minVer;
            this.jobTaskListener = jobTaskListener;
            this.jobService = jobService;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() throws Exception {
            TaskGetRequest taskGetRequest = new TaskGetRequest();
            taskGetRequest.setType(this.jobType);
            taskGetRequest.setStatus(JobStatus.INIT.name());
            taskGetRequest.setGroup(this.group);
            taskGetRequest.setMinVer(this.minVer);
            TaskGetResponse taskGetResponse = this.jobService.taskGet(taskGetRequest);
            if (taskGetResponse == null) {
                log.info("ignore");
                return;
            }
            if (!taskGetResponse.isSuccess()) {
                log.info("get error");
                return;
            }
            List taskList = taskGetResponse.getTaskList();
            if (Util.isEmpty((Collection)taskList)) {
                return;
            }
            for (TaskGetResponse.Task task : taskList) {
                TaskUpdateRequest taskUpdateRequest = new TaskUpdateRequest();
                taskUpdateRequest.setId(task.getId());
                JobServiceImpl.TaskContextImpl taskContext = new JobServiceImpl.TaskContextImpl();
                taskContext.setTask(task);
                JobStatus jobStatus = JobStatus.COMPLETED;
                try {
                    this.jobTaskListener.on((JobService.TaskContext)taskContext);
                    jobStatus = (JobStatus)Util.convert2Self((Object)taskContext.getJobStatus(), (Object)JobStatus.COMPLETED);
                }
                catch (Exception e) {
                    jobStatus = JobStatus.FAIL;
                }
                finally {
                    taskUpdateRequest.setId(task.getId());
                    taskUpdateRequest.setDocIndexName(task.getDocIndexName());
                    taskUpdateRequest.setStatus(jobStatus.name());
                    taskUpdateRequest.setCompletedDesc(taskContext.getCompletedDesc());
                    taskUpdateRequest.setRequestDeviceUrl(taskContext.getRequestDeviceUrl());
                    taskUpdateRequest.setRequestDeviceArgs(taskContext.getRequestDeviceArgs());
                    taskUpdateRequest.setResponseFromDevice(taskContext.getResponseFromDevice());
                    TaskUpdateResponse taskUpdateResponse = this.jobService.taskUpdate(taskUpdateRequest);
                    log.info("taskUpdate: " + JSONAccessor.impl().format((Object)taskUpdateResponse));
                    List<String> contentList = taskContext.getContentList();
                    TaskLogRequest taskLogRequest = new TaskLogRequest();
                    taskLogRequest.setJobId(null);
                    taskLogRequest.setTaskId(task.getId());
                    taskLogRequest.setType(this.jobType);
                    taskLogRequest.setContentList(contentList);
                    TaskLogResponse taskLogResponse = this.jobService.taskLog(taskLogRequest);
                    log.info("taskLog: " + JSONAccessor.impl().format((Object)taskLogResponse));
                }
            }
        }
    }
}

