package com.ovopark.jobhub.sdk.client;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@JobClientActive
@Component
public class SimpleDelayTaskExecutor implements DelayTaskExecutor {

    @Autowired
    ApplicationContext applicationContext;

    final Map<String, JobTaskListener> C=new ConcurrentHashMap<>();

    /*
    bean://spring/CRON_JOB_ClearDelayMsgListener
     */
    @Override
    public void execute(JobContext jobContext, JobLog jobLog) {
        String uri=jobContext.uri();
        URI u = URI.create(uri);
        if ("bean".equals(u.getScheme()) && "spring".equals(u.getHost())) {
            String beanName = u.getPath().substring(1);
            JobTaskListener bean=C.computeIfAbsent(beanName, s -> {
                JobTaskListener b = (JobTaskListener) applicationContext.getBean(s);
                return b;
            });
            bean.on(jobContext,jobLog);
        }

    }

}
