package com.ovopark.jobhub.sdk.client;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Configuration;


@JobClientActive
@RefreshScope
@Data
@Configuration
@ConfigurationProperties("jobhub.client.control")
public class ControlNodeImpl implements ControlNode{

    private String ip="127.0.0.1";

    private int port=13580;

    private int uiPort=13570;

    @Override
    public String ip() {
        return ip;
    }

    @Override
    public int port() {
        return port;
    }

    @Override
    public int uiPort() {
        return uiPort;
    }
}
