/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.jobhub.sdk.client;

import com.ovopark.jobhub.sdk.client.ClientNodeProvider;
import com.ovopark.jobhub.sdk.client.ControlTransport;
import com.ovopark.jobhub.sdk.client.JobClientActive;
import com.ovopark.jobhub.sdk.model.internal.ClientNodeRegisterRequest;
import com.ovopark.jobhub.sdk.model.internal.ClientNodeRegisterResponse;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.vclient.ClientNode;
import com.ovopark.kernel.shared.vclient.ClientNodeRegister;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

@JobClientActive
@Component(value="com.ovopark.jobhub.sdk.client.ClientNodeRegisterImpl")
public class ClientNodeRegisterImpl
implements ClientNodeRegister,
CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(ClientNodeRegisterImpl.class);
    @Autowired
    private ClientNodeProvider clientNodeProvider;
    static final ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
    @Autowired
    ControlTransport controlTransport;

    public void register() {
        Util.schedule((ScheduledExecutorService)scheduledExecutorService, () -> {
            ClientNode clientNode = this.clientNodeProvider.clientNode();
            ClientNodeRegisterRequest clientNodeRegisterRequest = new ClientNodeRegisterRequest();
            clientNodeRegisterRequest.setApp(clientNode.app());
            clientNodeRegisterRequest.setNode(clientNode.node());
            clientNodeRegisterRequest.setIp(clientNode.ip());
            clientNodeRegisterRequest.setPort(clientNode.port());
            clientNodeRegisterRequest.setServletPath(clientNode.servletPath());
            ClientNodeRegisterResponse clientNodeRegisterResponse = this.controlTransport.heartbeat(clientNodeRegisterRequest);
            log.info(JSONAccessor.impl().format((Object)clientNodeRegisterResponse));
        }, (long)5L, (TimeUnit)TimeUnit.SECONDS, e -> {
            log.error(e.getMessage());
            return true;
        }, () -> true);
    }

    public void run(String ... args) throws Exception {
        this.register();
    }
}

