package com.ovopark.jobhub.sdk.client;


import com.ovopark.module.shared.BaseResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;


@FeignClient(value = "jobhub-control"
        ,url = "${LOCAL_CONTROL_URL:}" //http://127.0.0.1:13570
)
public interface JobHubMgrApi {

    @GetMapping("/jobhub-control/feign/job/mgr/jobTypeList")
    BaseResult<Object> jobTypeList();

    @PostMapping("/jobhub-control/feign/job/mgr/jobSearch")
    BaseResult<Object> jobSearch(@RequestBody Object jobSearchVo);

    @PostMapping("/jobhub-control/feign/job/mgr/taskSearch")
    BaseResult<Object> taskSearch(@RequestBody Object taskSearchVo);


    @PostMapping("/jobhub-control/feign/job/taskRetry")
    BaseResult<Object> taskRetry(@RequestBody Object taskRetryVo);

}
