/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.jobhub.sdk.client;

import com.ovopark.jobhub.sdk.client.Client2ControlTransport;
import com.ovopark.jobhub.sdk.client.DelayTaskExecutor;
import com.ovopark.jobhub.sdk.client.JobClientActive;
import com.ovopark.jobhub.sdk.client.JobContext;
import com.ovopark.jobhub.sdk.client.JobLog;
import com.ovopark.jobhub.sdk.client.JobLogImpl;
import com.ovopark.jobhub.sdk.client.JobService;
import com.ovopark.jobhub.sdk.model.internal.TaskLockRequest;
import com.ovopark.jobhub.sdk.model.internal.TaskLockResponse;
import com.ovopark.jobhub.sdk.model.internal.TaskSubmitRequest;
import com.ovopark.jobhub.sdk.model.internal.TaskSubmitResponse;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.vclient.ClientNode;
import com.ovopark.module.shared.BaseResult;
import java.time.LocalDateTime;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@JobClientActive
@RestController(value="com.ovopark.jobhub.sdk.client.JobEndpoint")
@RequestMapping(value={"/feign/jobhub-job/processing"})
public class JobEndpoint {
    private static final Logger log = LoggerFactory.getLogger(JobEndpoint.class);
    @Autowired
    private DelayTaskExecutor delayTaskExecutor;
    @Autowired
    private Client2ControlTransport client2ControlTransport;
    @Autowired
    private JobService jobService;
    private static final ExecutorService jobExecutor = new ThreadPoolExecutor(Math.max(Math.min(Runtime.getRuntime().availableProcessors() * 2, 64), Integer.parseInt(System.getProperty("JOBHUB_JOB_IO", "0"))), Math.max(Math.max(Runtime.getRuntime().availableProcessors() * 2, 1024), Integer.parseInt(System.getProperty("JOBHUB_JOB_IO", "0"))), 600L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1), Util.newThreadFactory((String)"jobhub-job-io"), new ThreadPoolExecutor.AbortPolicy());
    private final Set<Long> executingCronTaskIdSet = ConcurrentHashMap.newKeySet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(value={"/submit"})
    @ResponseBody
    public BaseResult<TaskSubmitResponse> submit(final @RequestBody TaskSubmitRequest taskSubmitRequest) {
        final String taskKey = "task_" + taskSubmitRequest.getCronTaskId() + "_" + taskSubmitRequest.getCronTaskHistoryId();
        MDC.put((String)"traceId", (String)taskKey);
        MDC.put((String)"requestId", (String)taskKey);
        log.info("receive a new task, we can do it???: " + JSONAccessor.impl().format((Object)taskSubmitRequest));
        final TaskSubmitResponse taskSubmitResponse = new TaskSubmitResponse();
        taskSubmitResponse.setSubmitted(false);
        final JobLogImpl logBeforeSubmitted = new JobLogImpl(this.client2ControlTransport, taskKey, taskSubmitRequest.getCronTaskHistoryId());
        Util.logLink((String)("receive a new task, we can do it???: " + JSONAccessor.impl().format((Object)taskSubmitRequest))).log(arg_0 -> ((JobLog)logBeforeSubmitted).log(arg_0));
        try {
            Util.lock((Comparable)((Object)("task:" + taskSubmitRequest.getCronTaskId())), (Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    if (JobEndpoint.this.executingCronTaskIdSet.contains(taskSubmitRequest.getCronTaskId())) {
                        taskSubmitResponse.setSubmitted(false);
                        taskSubmitResponse.setDesc("Rejected,the previous task is executing");
                        Util.logLink((String)"Rejected,the previous task is executing").log(arg_0 -> ((Logger)log).info(arg_0)).log(arg_0 -> ((JobLog)logBeforeSubmitted).log(arg_0));
                        throw new IllegalStateException("the previous task is executing, reject the task: " + JSONAccessor.impl().format((Object)taskSubmitRequest));
                    }
                    TaskLockRequest taskLockRequest = new TaskLockRequest();
                    taskLockRequest.setCronTaskId(taskSubmitRequest.getCronTaskId());
                    taskLockRequest.setCronTaskHistoryId(taskSubmitRequest.getCronTaskHistoryId());
                    taskLockRequest.setNode(ClientNode.UUID_STR);
                    TaskLockResponse taskLockResponse = JobEndpoint.this.client2ControlTransport.lockClient(taskLockRequest);
                    if (taskLockResponse == null || !taskLockResponse.isSuccess()) {
                        Util.logLink((String)("cannot get lock: " + JSONAccessor.impl().format((Object)taskLockRequest))).log(arg_0 -> ((Logger)log).info(arg_0)).log(arg_0 -> ((JobLog)logBeforeSubmitted).log(arg_0));
                        throw new IllegalStateException("cannot get lock: " + JSONAccessor.impl().format((Object)taskLockRequest));
                    }
                    JobEndpoint.this.executingCronTaskIdSet.add(taskSubmitRequest.getCronTaskId());
                    try {
                        jobExecutor.execute(Util.catchRunnable(() -> {
                            JobLogImpl jobLog = new JobLogImpl(JobEndpoint.this.client2ControlTransport, taskKey, taskSubmitRequest.getCronTaskHistoryId());
                            try {
                                JobEndpoint.this.delayTaskExecutor.execute(new JobContextImpl(taskSubmitRequest, JobEndpoint.this.jobService), jobLog);
                            }
                            catch (Exception e) {
                                log.error(e.getMessage(), (Throwable)e);
                                jobLog.flush();
                                Util.errorStackList((Throwable)e).forEach(arg_0 -> ((JobLog)jobLog).log(arg_0));
                                jobLog.flush();
                            }
                            finally {
                                JobEndpoint.this.executingCronTaskIdSet.remove(taskLockRequest.getCronTaskId());
                                try {
                                    Util.logLink((String)(taskKey + " > completed: " + Util.formatTime((LocalDateTime)LocalDateTime.now(), (String[])new String[0]))).log(arg_0 -> ((Logger)log).info(arg_0)).log(arg_0 -> ((JobLog)jobLog).log(arg_0));
                                    jobLog.flush();
                                    jobLog.close();
                                }
                                catch (Exception e) {
                                    log.error(e.getMessage(), (Throwable)e);
                                }
                            }
                        }));
                        Util.logLink((String)("OK, the task is scheduled: " + taskKey)).log(arg_0 -> ((Logger)log).info(arg_0)).log(arg_0 -> ((JobLog)logBeforeSubmitted).log(arg_0));
                        taskSubmitResponse.setSubmitted(true);
                    }
                    catch (RejectedExecutionException e) {
                        JobEndpoint.this.executingCronTaskIdSet.remove(taskLockRequest.getCronTaskId());
                        taskSubmitResponse.setSubmitted(false);
                        taskSubmitResponse.setDesc("Rejected, resource is unavailable ");
                        Util.logLink((String)"Rejected, resource is unavailable ").log(arg_0 -> ((Logger)log).info(arg_0)).log(arg_0 -> ((JobLog)logBeforeSubmitted).log(arg_0));
                        throw Util.convert2RuntimeException((Throwable)e);
                    }
                    return null;
                }
            }, (long)15L, (TimeUnit)TimeUnit.SECONDS);
            return BaseResult.success((Object)taskSubmitResponse);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            logBeforeSubmitted.flush();
            Util.errorStackList((Throwable)e).forEach(arg_0 -> ((JobLog)logBeforeSubmitted).log(arg_0));
            logBeforeSubmitted.flush();
            return BaseResult.success((Object)taskSubmitResponse);
        }
        finally {
            try {
                logBeforeSubmitted.close();
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            finally {
                MDC.remove((String)"traceId");
                MDC.remove((String)"requestId");
            }
        }
    }

    public static class JobContextImpl
    implements JobContext {
        final TaskSubmitRequest taskSubmitRequest;
        final JobService jobService;

        public JobContextImpl(TaskSubmitRequest taskSubmitRequest, JobService jobService) {
            this.taskSubmitRequest = taskSubmitRequest;
            this.jobService = jobService;
        }

        public Long jobId() {
            return this.taskSubmitRequest.getCronTaskId();
        }

        public String name() {
            return this.taskSubmitRequest.getName();
        }

        public String uri() {
            return this.taskSubmitRequest.getUri();
        }

        public String args() {
            return this.taskSubmitRequest.getArgs();
        }

        public String jobIdInES() {
            return this.taskSubmitRequest.getJobIdInES();
        }

        public JobService jobService() {
            return this.jobService;
        }

        public boolean isCancelled() {
            return false;
        }

        public void heartbeatData(Object data) {
        }

        public TaskSubmitRequest getTaskSubmitRequest() {
            return this.taskSubmitRequest;
        }

        public JobService getJobService() {
            return this.jobService;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JobContextImpl)) {
                return false;
            }
            JobContextImpl other = (JobContextImpl)o;
            if (!other.canEqual(this)) {
                return false;
            }
            TaskSubmitRequest this$taskSubmitRequest = this.getTaskSubmitRequest();
            TaskSubmitRequest other$taskSubmitRequest = other.getTaskSubmitRequest();
            if (this$taskSubmitRequest == null ? other$taskSubmitRequest != null : !this$taskSubmitRequest.equals(other$taskSubmitRequest)) {
                return false;
            }
            JobService this$jobService = this.getJobService();
            JobService other$jobService = other.getJobService();
            return !(this$jobService == null ? other$jobService != null : !this$jobService.equals(other$jobService));
        }

        protected boolean canEqual(Object other) {
            return other instanceof JobContextImpl;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TaskSubmitRequest $taskSubmitRequest = this.getTaskSubmitRequest();
            result = result * 59 + ($taskSubmitRequest == null ? 43 : $taskSubmitRequest.hashCode());
            JobService $jobService = this.getJobService();
            result = result * 59 + ($jobService == null ? 43 : $jobService.hashCode());
            return result;
        }

        public String toString() {
            return "JobEndpoint.JobContextImpl(taskSubmitRequest=" + this.getTaskSubmitRequest() + ", jobService=" + this.getJobService() + ")";
        }
    }
}

