package com.ovopark.jobhub.sdk.client;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@JobClientActive
@Component("com.ovopark.jobhub.sdk.client.SimpleDelayTaskExecutor")
@Slf4j
public class SimpleDelayTaskExecutor implements DelayTaskExecutor {

    @Autowired
    ApplicationContext applicationContext;

    final Map<String, JobTaskListener> C=new ConcurrentHashMap<>();

    /*
    bean://spring/CRON_JOB_ClearDelayMsgListener
    ,kafka://jobhub-test-via-kafka/null/CRON_JOB_TestCronTaskViaKafkaListener
     */
    @Override
    public void execute(JobContext jobContext, JobLog jobLog) {
        String uri=jobContext.uri();
        URI u = URI.create(uri);
        String beanName=null;
        if ("bean".equals(u.getScheme()) && "spring".equals(u.getHost())) {
            beanName = u.getPath().substring(1);
        }

        else if ("kafka".equals(u.getScheme())) {
            String path = u.getPath();
            beanName = path.substring(path.lastIndexOf("/")+1);
        }

        String finalBeanName = beanName;
        JobTaskListener bean=C.computeIfAbsent(beanName, s -> {
            JobTaskListener b = null;
            try {
                b = (JobTaskListener) applicationContext.getBean(s);
            } catch (BeansException e) {
                log.debug(e.getMessage());
                log.debug("confirm your business, do we ignore the job ???: "+ finalBeanName);
                return null;
            }
            return b;
        });
        if (bean==null) {
            return;
        }
        bean.on(jobContext,jobLog);

    }

}
