package com.ovopark.jobhub.sdk.client;

import com.ovopark.jobhub.sdk.model.*;
import com.ovopark.kernel.shared.Config;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;
import java.util.concurrent.*;

import static com.ovopark.kernel.shared.Util.*;

@Deprecated
@Component
@Slf4j
public class TaskListenerRunnerViaHttpProvider implements JobService.TaskListenerRunnerProvider {


    Map<String, FetchThenExecTaskViaHttp> fetchThenExecTaskMap=new ConcurrentHashMap<>();

    private static final ScheduledExecutorService fetchThenExecExecutor=new ScheduledThreadPoolExecutor(
            Config.ConfigPriority.option().getInt("JOBHUB_FETCH_IO",200)
            ,newThreadFactory("jobhub-fetch-io")
            ,new ThreadPoolExecutor.AbortPolicy()
    );

    @Autowired
    private JobService jobService;

    @Override
    public String name() {
        return "http";
    }

    @Override
    public boolean start(String jobType, String beanUrl, String group, Long minVer
            , JobService.TaskListener taskListener, JobService.TaskListenerRunnerProviderConfig taskListenerRunnerProviderConfig) {
        String key=beanUrl+":"+jobType+":"+group;
        FetchThenExecTaskViaHttp fetchThenExecTask = lock(key, new Callable<FetchThenExecTaskViaHttp>() {
            @Override
            public FetchThenExecTaskViaHttp call() throws Exception {
                if (fetchThenExecTaskMap.containsKey(key)) {
                    log.info(key+" already registered");
                    return null;
                }

                FetchThenExecTaskViaHttp fetchThenExecTask =
                        new FetchThenExecTaskViaHttp(jobType,beanUrl,group,minVer,taskListener,jobService);
                return fetchThenExecTask;
            }
        });
        if (fetchThenExecTask != null) {
            try {
                fetchThenExecExecutor.scheduleWithFixedDelay(catchRunnable(fetchThenExecTask)
                        ,0,5, TimeUnit.SECONDS);
            } catch (RejectedExecutionException  e) {
                return false;
            }

            return true;
        }
        return false;
    }

    @Override
    public void close() {

    }

    public class FetchThenExecTaskViaHttp implements Util.CatchRunnable {

        final String jobType;

        final String beanUrl;

        final String group;

        final Long minVer;

        final JobService.TaskListener jobTaskListener;

        final String id=uniqueFirstPart();

        final JobService jobService;

        public FetchThenExecTaskViaHttp(String jobType, String beanUrl, String group, Long minVer
                , JobService.TaskListener jobTaskListener, JobService jobService) {
            this.jobType = jobType;
            this.beanUrl = beanUrl;
            this.group = group;
            this.minVer = minVer;
            this.jobTaskListener = jobTaskListener;
            this.jobService = jobService;
        }

        @Override
        public void run() throws Exception {
            TaskGetRequest taskGetRequest=new TaskGetRequest();
            taskGetRequest.setType(jobType);
            taskGetRequest.setStatus(JobStatus.INIT.name());
            taskGetRequest.setGroup(group);
            taskGetRequest.setMinVer(minVer);

            TaskGetResponse taskGetResponse = jobService.taskGet(taskGetRequest);
            if (taskGetResponse==null) {
                log.info("ignore");
                return;
            }

            if (!taskGetResponse.isSuccess()) {
                log.info("get error");
                return;
            }

            List<TaskGetResponse.Task> taskList = taskGetResponse.getTaskList();
            if (Util.isEmpty(taskList)) {
                return;
            }

            for (TaskGetResponse.Task task : taskList) {
                final String taskKey = "_job_" + task.getJobId()+"_task_"+task.getId();
                MDC.put("traceId", taskKey);
                MDC.put("requestId", taskKey);
                try {
                    TaskUpdateRequest taskUpdateRequest=new TaskUpdateRequest();
                    taskUpdateRequest.setId(task.getId());
                    JobServiceImpl.TaskContextImpl taskContext= new JobServiceImpl.TaskContextImpl();
                    taskContext.setTask(task);
                    JobStatus jobStatus=JobStatus.COMPLETED;
                    try {
                        jobTaskListener.on(taskContext);
                        jobStatus=convert2Self(taskContext.getJobStatus(),JobStatus.COMPLETED);
                    }
                    catch (Exception e){
                        jobStatus=JobStatus.FAIL;
                    }
                    finally {
                        taskUpdateRequest.setId(task.getId());
                        taskUpdateRequest.setDocIndexName(task.getDocIndexName());

                        taskUpdateRequest.setStatus(jobStatus.name());
                        taskUpdateRequest.setCompletedDesc(taskContext.getCompletedDesc());

                        taskUpdateRequest.setRequestDeviceUrl(taskContext.getRequestDeviceUrl());
                        taskUpdateRequest.setRequestDeviceArgs(taskContext.getRequestDeviceArgs());
                        taskUpdateRequest.setResponseFromDevice(taskContext.getResponseFromDevice());

                        TaskUpdateResponse taskUpdateResponse = jobService.taskUpdate(taskUpdateRequest);
                        log.info("taskUpdate: "+ JSONAccessor.impl().format(taskUpdateResponse));

                        List<String> contentList = taskContext.getContentList();
                        TaskLogPutRequest taskLogPutRequest =new TaskLogPutRequest();
                        taskLogPutRequest.setJobId(task.getJobId());
                        taskLogPutRequest.setTaskId(task.getId());
                        taskLogPutRequest.setType(jobType);
                        taskLogPutRequest.setContentList(contentList);

                        TaskLogPutResponse taskLogPutResponse = jobService.taskLog(taskLogPutRequest);
                        log.info("taskLog: "+ JSONAccessor.impl().format(taskLogPutResponse));
                    }
                }
                catch (Exception e){
                    log.error(e.getMessage(),e);
                }
                finally {
                    MDC.remove("traceId");
                    MDC.remove("requestId");
                }

            }

        }


    }



}
