/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.jobhub.sdk.client;

import com.ovopark.jobhub.sdk.client.JobClientActive;
import com.ovopark.jobhub.sdk.client.JobInnerContext;
import com.ovopark.jobhub.sdk.client.JobInnerContextMgr;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.stereotype.Component;

@JobClientActive
@Component
public class SimpleJobInnerContextMgr
implements JobInnerContextMgr {
    final Map<String, JobInnerContext> submitJobMap = new ConcurrentHashMap<String, JobInnerContext>();

    @Override
    public boolean add(long cronTaskId, long cronTaskHistoryId, JobInnerContext jobInnerContext) {
        this.submitJobMap.put(this.key(cronTaskId, cronTaskHistoryId), jobInnerContext);
        return true;
    }

    @Override
    public boolean exists(long cronTaskId, long cronTaskHistoryId) {
        return this.submitJobMap.containsKey(this.key(cronTaskId, cronTaskHistoryId));
    }

    @Override
    public boolean remove(long cronTaskId, long cronTaskHistoryId) {
        this.submitJobMap.remove(this.key(cronTaskId, cronTaskHistoryId));
        return true;
    }

    @Override
    public String key(long cronTaskId, long cronTaskHistoryId) {
        return cronTaskId + "_" + cronTaskHistoryId;
    }

    @Override
    public JobInnerContext jobInnerContext(long cronTaskId, long cronTaskHistoryId) {
        return this.submitJobMap.get(this.key(cronTaskId, cronTaskHistoryId));
    }

    @Override
    public int count() {
        return this.submitJobMap.size();
    }
}

