package com.ovopark.jobhub.sdk.client;

import com.ovopark.jobhub.sdk.model.TaskHeartbeatRequest;
import com.ovopark.jobhub.sdk.model.TaskHeartbeatResponse;
import com.ovopark.jobhub.sdk.model.TaskIfDoneRequest;
import com.ovopark.jobhub.sdk.model.TaskIfDoneResponse;
import com.ovopark.jobhub.sdk.model.internal.ClientNodeRegisterRequest;
import com.ovopark.jobhub.sdk.model.internal.ClientNodeRegisterResponse;
import com.ovopark.jobhub.sdk.model.internal.TaskLockRequest;
import com.ovopark.jobhub.sdk.model.internal.TaskLockResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Slf4j
@Component("com.ovopark.jobhub.sdk.client.Client2ControlViaFeignClient")
public class Client2ControlViaFeignClient implements Client2ControlTransport {


    @Autowired
    JobHubJobApi jobHubJobApi;


    @Override
    public ClientNodeRegisterResponse heartbeat(ClientNodeRegisterRequest clientNodeRegisterRequest) {
        return jobHubJobApi.heartbeat(clientNodeRegisterRequest);
    }

    @Override
    public TaskLockResponse lockClient(TaskLockRequest taskLockRequest) {
        return jobHubJobApi.lockClient(taskLockRequest);
    }

    @Override
    public TaskHeartbeatResponse heartbeatStat(TaskHeartbeatRequest taskHeartbeatRequest) {
        return jobHubJobApi.heartbeatStat(taskHeartbeatRequest);
    }

    @Override
    public TaskLogResponse log(TaskLogRequest taskLogRequest) {
        return jobHubJobApi.log(taskLogRequest);
    }

//    @Override
//    public TaskHeartbeatCancelResponse heartbeatStatCancel(TaskHeartbeatCancelRequest taskHeartbeatCancelRequest) {
//        return jobHubJobApi.heartbeatStatCancel(taskHeartbeatCancelRequest);
//    }

    @Override
    public TaskIfDoneResponse taskIfDone(TaskIfDoneRequest taskIfDoneRequest) {
        return jobHubJobApi.taskIfDone(taskIfDoneRequest);
    }

}
