/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.jobhub.sdk.model.internal;

import com.ovopark.kernel.shared.Model;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ShardNodeView
implements Model {
    private String master;
    private String group;
    private long vcc;
    private int shardCount;
    private List<Shard> rest = new ArrayList<Shard>();
    private Map<String, List<Shard>> shardMap = new HashMap<String, List<Shard>>();
    private Move move;

    public List<Shard> assignedShard(String nodeName) {
        return this.shardMap.get(nodeName);
    }

    public void assignNode(String nodeName) {
        this.shardMap.put(nodeName, new ArrayList());
    }

    public void assignNode(String nodeName, Shard shard) {
        if (this.shardMap.get(nodeName) == null) {
            this.assignNode(nodeName);
        }
        this.shardMap.get(nodeName).add(shard);
    }

    public void clearAssignedShard(String nodeName) {
        this.shardMap.remove(nodeName);
    }

    public void clearAssignedShard(String nodeName, int shardIndex) {
        this.shardMap.get(nodeName).removeIf(shard -> shard.shard == shardIndex);
    }

    public String getMaster() {
        return this.master;
    }

    public String getGroup() {
        return this.group;
    }

    public long getVcc() {
        return this.vcc;
    }

    public int getShardCount() {
        return this.shardCount;
    }

    public List<Shard> getRest() {
        return this.rest;
    }

    public Map<String, List<Shard>> getShardMap() {
        return this.shardMap;
    }

    public Move getMove() {
        return this.move;
    }

    public void setMaster(String master) {
        this.master = master;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setVcc(long vcc) {
        this.vcc = vcc;
    }

    public void setShardCount(int shardCount) {
        this.shardCount = shardCount;
    }

    public void setRest(List<Shard> rest) {
        this.rest = rest;
    }

    public void setShardMap(Map<String, List<Shard>> shardMap) {
        this.shardMap = shardMap;
    }

    public void setMove(Move move) {
        this.move = move;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShardNodeView)) {
            return false;
        }
        ShardNodeView other = (ShardNodeView)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getVcc() != other.getVcc()) {
            return false;
        }
        if (this.getShardCount() != other.getShardCount()) {
            return false;
        }
        String this$master = this.getMaster();
        String other$master = other.getMaster();
        if (this$master == null ? other$master != null : !this$master.equals(other$master)) {
            return false;
        }
        String this$group = this.getGroup();
        String other$group = other.getGroup();
        if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
            return false;
        }
        List<Shard> this$rest = this.getRest();
        List<Shard> other$rest = other.getRest();
        if (this$rest == null ? other$rest != null : !((Object)this$rest).equals(other$rest)) {
            return false;
        }
        Map<String, List<Shard>> this$shardMap = this.getShardMap();
        Map<String, List<Shard>> other$shardMap = other.getShardMap();
        if (this$shardMap == null ? other$shardMap != null : !((Object)this$shardMap).equals(other$shardMap)) {
            return false;
        }
        Move this$move = this.getMove();
        Move other$move = other.getMove();
        return !(this$move == null ? other$move != null : !((Object)this$move).equals(other$move));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ShardNodeView;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $vcc = this.getVcc();
        result = result * 59 + (int)($vcc >>> 32 ^ $vcc);
        result = result * 59 + this.getShardCount();
        String $master = this.getMaster();
        result = result * 59 + ($master == null ? 43 : $master.hashCode());
        String $group = this.getGroup();
        result = result * 59 + ($group == null ? 43 : $group.hashCode());
        List<Shard> $rest = this.getRest();
        result = result * 59 + ($rest == null ? 43 : ((Object)$rest).hashCode());
        Map<String, List<Shard>> $shardMap = this.getShardMap();
        result = result * 59 + ($shardMap == null ? 43 : ((Object)$shardMap).hashCode());
        Move $move = this.getMove();
        result = result * 59 + ($move == null ? 43 : ((Object)$move).hashCode());
        return result;
    }

    public String toString() {
        return "ShardNodeView(master=" + this.getMaster() + ", group=" + this.getGroup() + ", vcc=" + this.getVcc() + ", shardCount=" + this.getShardCount() + ", rest=" + this.getRest() + ", shardMap=" + this.getShardMap() + ", move=" + this.getMove() + ")";
    }

    public static class Move {
        private long taskStartTimeMs;
        private long vcc;
        int shard;
        private MoveShard from;
        private MoveShard to;

        public long getTaskStartTimeMs() {
            return this.taskStartTimeMs;
        }

        public long getVcc() {
            return this.vcc;
        }

        public int getShard() {
            return this.shard;
        }

        public MoveShard getFrom() {
            return this.from;
        }

        public MoveShard getTo() {
            return this.to;
        }

        public void setTaskStartTimeMs(long taskStartTimeMs) {
            this.taskStartTimeMs = taskStartTimeMs;
        }

        public void setVcc(long vcc) {
            this.vcc = vcc;
        }

        public void setShard(int shard) {
            this.shard = shard;
        }

        public void setFrom(MoveShard from) {
            this.from = from;
        }

        public void setTo(MoveShard to) {
            this.to = to;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Move)) {
                return false;
            }
            Move other = (Move)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getTaskStartTimeMs() != other.getTaskStartTimeMs()) {
                return false;
            }
            if (this.getVcc() != other.getVcc()) {
                return false;
            }
            if (this.getShard() != other.getShard()) {
                return false;
            }
            MoveShard this$from = this.getFrom();
            MoveShard other$from = other.getFrom();
            if (this$from == null ? other$from != null : !((Object)this$from).equals(other$from)) {
                return false;
            }
            MoveShard this$to = this.getTo();
            MoveShard other$to = other.getTo();
            return !(this$to == null ? other$to != null : !((Object)this$to).equals(other$to));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Move;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $taskStartTimeMs = this.getTaskStartTimeMs();
            result = result * 59 + (int)($taskStartTimeMs >>> 32 ^ $taskStartTimeMs);
            long $vcc = this.getVcc();
            result = result * 59 + (int)($vcc >>> 32 ^ $vcc);
            result = result * 59 + this.getShard();
            MoveShard $from = this.getFrom();
            result = result * 59 + ($from == null ? 43 : ((Object)$from).hashCode());
            MoveShard $to = this.getTo();
            result = result * 59 + ($to == null ? 43 : ((Object)$to).hashCode());
            return result;
        }

        public String toString() {
            return "ShardNodeView.Move(taskStartTimeMs=" + this.getTaskStartTimeMs() + ", vcc=" + this.getVcc() + ", shard=" + this.getShard() + ", from=" + this.getFrom() + ", to=" + this.getTo() + ")";
        }
    }

    public static class Shard {
        int shard;
        private boolean assigned;
        private long waitAssignStartTime;
        private Action action;

        public void reset() {
            this.waitAssignStartTime = System.currentTimeMillis();
            this.assigned = false;
            this.action = null;
        }

        public int getShard() {
            return this.shard;
        }

        public boolean isAssigned() {
            return this.assigned;
        }

        public long getWaitAssignStartTime() {
            return this.waitAssignStartTime;
        }

        public Action getAction() {
            return this.action;
        }

        public void setShard(int shard) {
            this.shard = shard;
        }

        public void setAssigned(boolean assigned) {
            this.assigned = assigned;
        }

        public void setWaitAssignStartTime(long waitAssignStartTime) {
            this.waitAssignStartTime = waitAssignStartTime;
        }

        public void setAction(Action action) {
            this.action = action;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Shard)) {
                return false;
            }
            Shard other = (Shard)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getShard() != other.getShard()) {
                return false;
            }
            if (this.isAssigned() != other.isAssigned()) {
                return false;
            }
            if (this.getWaitAssignStartTime() != other.getWaitAssignStartTime()) {
                return false;
            }
            Action this$action = this.getAction();
            Action other$action = other.getAction();
            return !(this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Shard;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getShard();
            result = result * 59 + (this.isAssigned() ? 79 : 97);
            long $waitAssignStartTime = this.getWaitAssignStartTime();
            result = result * 59 + (int)($waitAssignStartTime >>> 32 ^ $waitAssignStartTime);
            Action $action = this.getAction();
            result = result * 59 + ($action == null ? 43 : ((Object)((Object)$action)).hashCode());
            return result;
        }

        public String toString() {
            return "ShardNodeView.Shard(shard=" + this.getShard() + ", assigned=" + this.isAssigned() + ", waitAssignStartTime=" + this.getWaitAssignStartTime() + ", action=" + (Object)((Object)this.getAction()) + ")";
        }
    }

    public static enum Action {
        UNINSTALL,
        INTEND,
        INSTALL;

    }

    public static enum Status {
        READY,
        COMPLETE,
        TIMEOUT;

    }

    public static class MoveShard {
        Status status;
        String nodeName;

        public Status getStatus() {
            return this.status;
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public void setStatus(Status status) {
            this.status = status;
        }

        public void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MoveShard)) {
                return false;
            }
            MoveShard other = (MoveShard)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Status this$status = this.getStatus();
            Status other$status = other.getStatus();
            if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
                return false;
            }
            String this$nodeName = this.getNodeName();
            String other$nodeName = other.getNodeName();
            return !(this$nodeName == null ? other$nodeName != null : !this$nodeName.equals(other$nodeName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MoveShard;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Status $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
            String $nodeName = this.getNodeName();
            result = result * 59 + ($nodeName == null ? 43 : $nodeName.hashCode());
            return result;
        }

        public String toString() {
            return "ShardNodeView.MoveShard(status=" + (Object)((Object)this.getStatus()) + ", nodeName=" + this.getNodeName() + ")";
        }
    }
}

