/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.jobhub.sdk.model;

import com.ovopark.jobhub.sdk.model.JobType;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public interface KafkaTopics {
    public static final String TEST_TOPIC = "jobhub-task-test";
    public static final String ON_OFF_CHECK_TASK_TOPIC = "jobhub-task-onOffCheckTask";
    public static final String OFFLINE_CONFIGURE_TASK_TOPIC = "jobhub-task-offlineConfigureTask";
    public static final String TEST_SUB_KAFKA_TASK_TOPIC = "jobhub-task-testSubKafkaTask";
    public static final String ON_OFF_DATA_FLOW_KAFKA_TASK_TOPIC = "jobhub-task-onOffDataFlowTask";
    public static final String DATA_FLOW_SNAPSHOT_KAFKA_TASK_TOPIC = "jobhub-task-dataFlowSnapshotTask";
    public static final Set<String> activeTopicList = new HashSet<String>(Arrays.asList("jobhub-task-test", "jobhub-task-onOffCheckTask", "jobhub-task-offlineConfigureTask"));

    public static String activeTopic(String jobType) {
        JobType jt = JobType.valueOf(jobType);
        return KafkaTopics.activeTopic(jt);
    }

    public static String activeTopic(JobType jobType) {
        if (jobType == JobType.test) {
            return TEST_TOPIC;
        }
        if (jobType == JobType.onOffCheckTask) {
            return ON_OFF_CHECK_TASK_TOPIC;
        }
        if (jobType == JobType.offlineConfigure || jobType == JobType.sdConfigure) {
            return OFFLINE_CONFIGURE_TASK_TOPIC;
        }
        if (jobType == JobType.testSubKafka) {
            return TEST_SUB_KAFKA_TASK_TOPIC;
        }
        if (jobType == JobType.onOffDataFlowTask) {
            return ON_OFF_DATA_FLOW_KAFKA_TASK_TOPIC;
        }
        if (jobType == JobType.dataFlowSnapshotTask) {
            return DATA_FLOW_SNAPSHOT_KAFKA_TASK_TOPIC;
        }
        return null;
    }
}

