/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.kernel.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ovopark.api.ReportMessageApi;
import com.ovopark.dingding.sdk.api.DingdingMessageApi;
import com.ovopark.feishu.sdk.api.FeishuMessageApi;
import com.ovopark.feishu.web.BaseResult;
import com.ovopark.feishu.web.MessageMo;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import com.ovopark.messagehub.kernel.common.utils.DateUtils;
import com.ovopark.messagehub.kernel.common.utils.HttpUtils;
import com.ovopark.messagehub.kernel.common.utils.MessageUtil;
import com.ovopark.messagehub.kernel.common.utils.RedisUtil;
import com.ovopark.messagehub.kernel.common.utils.ThreadPoolTaskUtils;
import com.ovopark.messagehub.kernel.common.utils.UserUtils;
import com.ovopark.messagehub.kernel.config.MessageHubMigrateConfig;
import com.ovopark.messagehub.kernel.mapper.MessageMapper;
import com.ovopark.messagehub.kernel.mapper.TodoMessageMapper;
import com.ovopark.messagehub.kernel.model.entity.Message;
import com.ovopark.messagehub.kernel.model.entity.TodoMessage;
import com.ovopark.messagehub.kernel.model.mo.MeaasgeAndWeixinMo;
import com.ovopark.messagehub.kernel.model.mo.MessageBatchMo;
import com.ovopark.messagehub.kernel.model.pojo.MessagePojo;
import com.ovopark.messagehub.kernel.model.pojo.StorePlanMessageBo;
import com.ovopark.messagehub.kernel.model.vo.MessageVo;
import com.ovopark.messagehub.kernel.model.vo.RedisVo;
import com.ovopark.messagehub.kernel.model.vo.SimpleCountVo;
import com.ovopark.messagehub.kernel.model.vo.SimpleNumberVo;
import com.ovopark.messagehub.kernel.service.SystemConfigureService;
import com.ovopark.messagehub.kernel.service.TodoMessageService;
import com.ovopark.messagehub.kernel.service.UsersService;
import com.ovopark.messagehub.sdk.MessageHubV2Api;
import com.ovopark.messagehub.sdk.MessageMigrateApi;
import com.ovopark.messagehub.sdk.model.MCRequest;
import com.ovopark.messagehub.sdk.model.MCRequestBuilders;
import com.ovopark.messagehub.sdk.model.MCRequestResponse;
import com.ovopark.messagehub.sdk.model.MessageModel;
import com.ovopark.messagehub.sdk.model.MessageRequest;
import com.ovopark.messagehub.sdk.model.ParamContext;
import com.ovopark.messagehub.sdk.model.SubsBuilders;
import com.ovopark.messagehub.sdk.model.migrate.MessageClassifyPo;
import com.ovopark.messagehub.sdk.model.migrate.SDKMessageQuery;
import com.ovopark.organize.common.model.mo.SystemConfigureMo;
import com.ovopark.privilege.pojo.UsersPojo;
import com.ovopark.shopweb.enums.MessageObjectTypeEnum;
import com.ovopark.shopweb.enums.MessageObjectTypeNewEnum;
import com.ovopark.shopweb.po.UserBo;
import com.ovopark.shopweb.req.store.MessageObjectReq;
import com.ovopark.shopweb.resp.store.MessageObjectTypeGroupResp;
import com.ovopark.shopweb.resp.store.MessageObjectTypeResp;
import com.ovopark.weixin.api.WeiXinMessageApi;
import com.ovopark.weixin.mo.MessageUserMo;
import com.ovopark.weixin.mo.WeixinMessageMo;
import jakarta.annotation.Resource;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;

@Service
public class TodoMessageServiceImpl
implements TodoMessageService {
    private static final Logger log = LoggerFactory.getLogger(TodoMessageServiceImpl.class);
    @Resource
    private MessageMapper messageMapper;
    @Resource
    private TodoMessageMapper todoMessageMapper;
    @Resource
    private MessageSource messageSource;
    @Resource
    private ReportMessageApi reportMessageApi;
    @Resource
    private SystemConfigureService systemConfigureService;
    @Resource
    private UsersService usersService;
    @Resource
    private WeiXinMessageApi weiXinMessageApi;
    @Resource
    private DingdingMessageApi dingdingMessageApi;
    @Resource
    private FeishuMessageApi feishuMessageApi;
    @Resource
    private RedisUtil redisUtil;
    @Resource
    MessageHubMigrateConfig messageHubMigrateConfig;
    @Resource
    private MessageHubV2Api messageHubV2Api;
    @Resource
    private MessageMigrateApi messageMigrateApi;
    @Value(value="${myConfig.weChatUrl}")
    private String weChatUrl;

    @Override
    public IPage<TodoMessage> getTodoMessages(Integer userId, Integer enterpriseId, Integer pageNumber, Integer pageSize, List<String> categoryList, List<String> filterTypes, Integer isExecutor, String sort, String endTimeStart, String endTimeEnd, Integer status) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"target_user_id", (Object)userId);
        if (enterpriseId != null) {
            queryWrapper.eq((Object)"enterprise_id", (Object)enterpriseId);
        } else {
            queryWrapper.isNull((Object)"enterprise_id");
        }
        if (CollectionUtils.isNotEmpty(categoryList)) {
            queryWrapper.in((Object)"category", categoryList);
        }
        if (CollectionUtils.isNotEmpty(filterTypes)) {
            queryWrapper.in((Object)"object_type", filterTypes);
        }
        if (isExecutor != null) {
            queryWrapper.eq((Object)"is_executor", (Object)isExecutor);
        }
        if (StringUtils.isNotEmpty((String)endTimeStart)) {
            queryWrapper.and(wrapper -> ((QueryWrapper)((QueryWrapper)wrapper.ge((Object)"end_time", (Object)endTimeStart)).or()).isNull((Object)"end_time"));
        }
        if (StringUtils.isNotEmpty((String)endTimeEnd)) {
            queryWrapper.le((Object)"end_time", (Object)endTimeEnd);
        }
        if (status != null) {
            queryWrapper.eq((Object)"status", (Object)status);
        }
        if ("asc".equals(sort)) {
            queryWrapper.orderByAsc((Object)"IF(isnull(end_time),1,0)");
            queryWrapper.orderByAsc((Object)"end_time");
            queryWrapper.orderByAsc((Object)"create_time");
        } else {
            queryWrapper.orderByAsc((Object)"IF(isnull(end_time),0,1)");
            queryWrapper.orderByDesc((Object)"end_time");
            queryWrapper.orderByDesc((Object)"create_time");
        }
        Page page = new Page((long)pageNumber.intValue(), (long)pageSize.intValue());
        IPage messages = this.todoMessageMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
        return messages;
    }

    @Override
    public TodoMessage getTodoMessage(Long messageId) {
        return (TodoMessage)this.todoMessageMapper.selectById(messageId);
    }

    @Override
    public List<TodoMessage> getBatchTodoMessages(List<Long> messageIds) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(TodoMessage::getId, messageIds);
        return this.todoMessageMapper.selectList((Wrapper)queryWrapper);
    }

    @Override
    public boolean deleteTodoMessage(TodoMessage message) {
        this.todoMessageMapper.deleteById(message.getId());
        return true;
    }

    @Override
    public List<SimpleCountVo> getTodoModulesMessageCount(Integer userId, Integer enterpriseId, List<String> categoryList) {
        List<SimpleCountVo> messageCount = this.todoMessageMapper.getTodoModulesMessageCount(userId, enterpriseId);
        ArrayList<SimpleCountVo> resultList = new ArrayList<SimpleCountVo>();
        for (String category : categoryList) {
            boolean exists = false;
            for (SimpleCountVo vo : messageCount) {
                if (!category.equals(vo.getName())) continue;
                resultList.add(vo);
                exists = true;
                break;
            }
            if (exists) continue;
            SimpleCountVo vo = new SimpleCountVo();
            vo.setCount(0);
            vo.setName(category);
            resultList.add(vo);
        }
        return resultList;
    }

    @Override
    public List<SimpleCountVo> getTodoMessageStatusCount(Integer userId, Integer enterpriseId, String category) {
        SimpleCountVo vo;
        List<SimpleCountVo> messageCount = this.todoMessageMapper.getTodoMessageStatusCount(userId, enterpriseId, category);
        List<Object> statusTypes = new ArrayList();
        if (CollectionUtils.isNotEmpty(messageCount)) {
            statusTypes = messageCount.stream().map(SimpleCountVo::getName).distinct().collect(Collectors.toList());
        }
        if (!statusTypes.contains("1")) {
            vo = new SimpleCountVo();
            vo.setCount(0);
            vo.setName("executeCount");
            messageCount.add(vo);
        }
        if (!statusTypes.contains("0")) {
            vo = new SimpleCountVo();
            vo.setCount(0);
            vo.setName("collaborateCount");
            messageCount.add(vo);
        }
        for (SimpleCountVo message : messageCount) {
            if (message.getName().equals("1")) {
                message.setName("executeCount");
                continue;
            }
            message.setName("collaborateCount");
        }
        return messageCount;
    }

    @Override
    @Deprecated
    public List<SimpleCountVo> getMessageCount(Integer userId, Integer enterpriseId, List<String> filterTypes) {
        LambdaQueryWrapper todoMessageWrapper = new LambdaQueryWrapper();
        todoMessageWrapper.eq(TodoMessage::getTargetUserId, (Object)userId);
        if (enterpriseId != null) {
            todoMessageWrapper.eq(TodoMessage::getEnterpriseId, (Object)enterpriseId);
        } else {
            todoMessageWrapper.isNull(TodoMessage::getEnterpriseId);
        }
        if (CollectionUtils.isNotEmpty(filterTypes)) {
            todoMessageWrapper.in(TodoMessage::getObjectType, filterTypes);
        }
        Integer todoMessageCount = this.todoMessageMapper.selectCount((Wrapper)todoMessageWrapper).intValue();
        Integer messageCount = 0;
        log.info(this.messageHubMigrateConfig.isUseMessageHubApi() + " , getMessageCount forward to messagehub-control???: " + userId + " , " + enterpriseId);
        if (this.messageHubMigrateConfig.isUseMessageHubApi()) {
            log.info("getMessageCount forward to messagehub-control(countMsg): " + userId + " , " + enterpriseId);
            com.ovopark.module.shared.BaseResult baseResult = this.messageHubV2Api.countMsg(userId, enterpriseId, null, Integer.valueOf(0));
            if (baseResult != null && !baseResult.getIsError().booleanValue()) {
                messageCount = Util.comparable2Int((Comparable)((Comparable)baseResult.getData()));
            }
        } else {
            LambdaQueryWrapper messageWrapper = new LambdaQueryWrapper();
            messageWrapper.eq(Message::getTargetUserId, (Object)userId);
            if (enterpriseId != null) {
                messageWrapper.eq(Message::getEnterpriseId, (Object)enterpriseId);
            } else {
                messageWrapper.isNull(Message::getEnterpriseId);
            }
            messageWrapper.eq(Message::getStatus, (Object)0);
            messageCount = this.messageMapper.selectCount((Wrapper)messageWrapper).intValue();
        }
        ArrayList<SimpleCountVo> list = new ArrayList<SimpleCountVo>(2);
        SimpleCountVo todoMessageVo = new SimpleCountVo();
        todoMessageVo.setName("todoMessageCount");
        todoMessageVo.setCount(todoMessageCount);
        list.add(todoMessageVo);
        SimpleCountVo messageVo = new SimpleCountVo();
        messageVo.setName("messageCount");
        messageVo.setCount(messageCount);
        list.add(messageVo);
        return list;
    }

    @Override
    public List<Message> findMessages(Integer userId, Integer status, String objectType, Integer groupId, String noNeedType, Integer pageNumber, Integer pageSize) {
        int index = (pageNumber - 1) * pageSize;
        return this.messageMapper.findMessages(userId, status, objectType, groupId, noNeedType, index, pageSize);
    }

    @Override
    public Map<Integer, Integer> countEnterpriseMessageCount(Integer userId, List<Integer> enterpriseIds) {
        Map<Integer, Integer> map = new HashMap<Integer, Integer>();
        List<SimpleNumberVo> list = this.messageMapper.countEnterpriseMessageCount(userId, enterpriseIds);
        if (CollectionUtils.isNotEmpty(list)) {
            map = list.stream().collect(Collectors.toMap(SimpleNumberVo::getId, SimpleNumberVo::getNumber));
        }
        return map;
    }

    @Override
    public Message createMessage(Message message) {
        this.messageMapper.insert(message);
        return message;
    }

    @Override
    public TodoMessage saveTodoMessage(TodoMessage message) {
        this.todoMessageMapper.insert(message);
        return message;
    }

    @Override
    public IPage<MessageVo> findMessagesByType(Page<MessageVo> page, Integer userId, String objectType, String category, Integer groupId) {
        return this.messageMapper.findMessagesByType(page, userId, objectType, category, groupId);
    }

    @Override
    public MessageVo findOneByUserIdAndStatus(Integer userId, Integer groupId, Integer status, String objectType, String category) {
        return this.messageMapper.findOneByUserIdAndStatus(userId, groupId, status, objectType, category);
    }

    @Override
    public Integer findTotalByStatus(Integer userId, Integer groupId, Integer status, String objectType, String category) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(Message::getTargetUserId, (Object)userId);
        if (groupId != null) {
            queryWrapper.eq(Message::getEnterpriseId, (Object)groupId);
        }
        if (status != null) {
            queryWrapper.eq(Message::getStatus, (Object)status);
        }
        if (StringUtils.isNotEmpty((String)objectType)) {
            queryWrapper.eq(Message::getObjectType, (Object)objectType);
        }
        if (StringUtils.isNotEmpty((String)category)) {
            queryWrapper.eq(Message::getCategory, (Object)category);
        }
        return this.messageMapper.selectCount((Wrapper)queryWrapper).intValue();
    }

    @Override
    public Message findById(Integer id) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(Message::getId, (Object)id);
        return (Message)this.messageMapper.selectOne((Wrapper)queryWrapper);
    }

    @Override
    public Message updateBean(Message messageNew) {
        this.messageMapper.updateById(messageNew);
        return messageNew;
    }

    @Override
    public List<com.ovopark.messagehub.kernel.model.mo.MessageMo> findUnreadMessageByObj(String objectType, Integer targetUserId, Integer index, Integer num) {
        return this.messageMapper.findUnreadMessageByObj(objectType, targetUserId, index, num);
    }

    @Override
    public Integer findUnreadMessageByObjTotalCount(String objectType, Integer targetUserId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(Message::getStatus, (Object)0);
        queryWrapper.eq(Message::getTargetUserId, (Object)targetUserId);
        queryWrapper.eq(Message::getObjectType, (Object)objectType);
        return this.messageMapper.selectCount((Wrapper)queryWrapper).intValue();
    }

    @Override
    @Deprecated
    public List<MessageClassifyPo> getUndoneMessage(Integer userId, Integer groupId, Integer index, Integer num, Locale locale, Integer flag) {
        List<MessageClassifyPo> undoneMessages = null;
        ArrayList<String> categoryList = new ArrayList();
        if (this.messageHubMigrateConfig.isUseMessageHubApi()) {
            log.info("getUndoneMessage forward to messagehub-control(getUndoneMessage): " + userId + ", " + groupId);
            com.ovopark.module.shared.BaseResult baseResult = this.messageMigrateApi.getUndoneMessage(userId, groupId);
            if (baseResult != null && !baseResult.getIsError().booleanValue()) {
                undoneMessages = new ArrayList<MessageClassifyPo>();
                for (MessageClassifyPo po : (List)baseResult.getData()) {
                    MessageClassifyPo m = new MessageClassifyPo();
                    BeanUtils.copyProperties((Object)po, (Object)m);
                    if (!StringUtils.isEmpty((String)m.getI18nKey())) {
                        try {
                            if (StringUtils.isEmpty((String)m.getI18nParam())) {
                                m.setContent(this.messageSource.getMessage(m.getI18nKey(), null, locale));
                            } else {
                                m.setContent(this.messageSource.getMessage(m.getI18nKey(), (Object[])m.getI18nParam().split(","), locale));
                            }
                        }
                        catch (Exception e) {
                            log.info("message internationalize failed, key:" + m.getI18nKey());
                            log.error("getUndoneMessage", (Throwable)e);
                        }
                    }
                    if (m.getCreateTime() != null) {
                        m.setCreateTimeStr(DateUtils.getDateStr(m.getCreateTime(), "yyyy-MM-dd HH:mm:ss"));
                    }
                    undoneMessages.add(m);
                    categoryList.add(m.getCategory());
                }
            }
        } else {
            undoneMessages = this.messageMapper.getUndoneMessage(userId, groupId);
            if (!CollectionUtils.isEmpty(undoneMessages)) {
                categoryList = undoneMessages.stream().map(o -> o.getCategory()).collect(Collectors.toList());
                List ids = undoneMessages.stream().map(o -> (int)o.getId()).collect(Collectors.toList());
                List detailMessages = new ArrayList();
                if (CollectionUtils.isNotEmpty(ids)) {
                    detailMessages = this.messageMapper.selectBatchIds(ids);
                }
                for (MessageClassifyPo message : undoneMessages) {
                    for (Message detail : detailMessages) {
                        if (message.getCategory() == null || !message.getCategory().equals(detail.getCategory())) continue;
                        message.setCategory(detail.getCategory());
                        message.setObjectType(detail.getObjectType());
                        message.setCreateTime(detail.getCreateTime());
                        if (detail.getCreateTime() != null) {
                            message.setCreateTimeStr(DateUtils.getDateStr(detail.getCreateTime(), "yyyy-MM-dd HH:mm:ss"));
                        }
                        message.setContent(detail.getContent());
                        message.setDescription(detail.getDescription());
                        message.setTargetUserId(detail.getTargetUserId());
                        message.setI18nKey(detail.getI18nKey());
                        message.setI18nParam(detail.getI18nParam());
                        if (StringUtils.isEmpty((String)detail.getI18nKey())) continue;
                        try {
                            if (StringUtils.isEmpty((String)detail.getI18nParam())) {
                                message.setContent(this.messageSource.getMessage(detail.getI18nKey(), null, locale));
                                continue;
                            }
                            message.setContent(this.messageSource.getMessage(detail.getI18nKey(), (Object[])detail.getI18nParam().split(","), locale));
                        }
                        catch (Exception e) {
                            log.info("message internationalize failed, key:" + detail.getI18nKey());
                            log.error("getUndoneMessage", (Throwable)e);
                        }
                    }
                }
            }
        }
        Collections.sort(undoneMessages, new Comparator<MessageClassifyPo>(this){

            @Override
            public int compare(MessageClassifyPo o1, MessageClassifyPo o2) {
                Date dt1 = o1.getCreateTime();
                Date dt2 = o2.getCreateTime();
                if (dt1 != null && dt2 != null && dt1.getTime() >= dt2.getTime()) {
                    return -1;
                }
                return 1;
            }
        });
        this.specialCategroy(categoryList, userId, groupId, undoneMessages, "TYPE_STORE_PLAN_SYSTEM");
        this.specialCategroy(categoryList, userId, groupId, undoneMessages, "INSPECTION_PLAN_CATEGORY");
        this.specialCategroy(categoryList, userId, groupId, undoneMessages, "DISPLAY_CENTER_CATEGORY");
        return undoneMessages;
    }

    @Override
    @Deprecated
    public Map<String, Object> getUndoneMessageByClassify(Integer index, Integer num, Integer userId, Integer groupId, String objectType, String category, String exceptObjectTypes, Integer status, Integer isDeal, Locale locale) {
        List<Message> data;
        if (this.messageHubMigrateConfig.isUseMessageHubApi()) {
            log.info("getUndoneMessageByClassify forward to messagehub-control");
            ArrayList<MessagePojo> list = new ArrayList<MessagePojo>();
            SDKMessageQuery sdkMessageQuery = new SDKMessageQuery();
            Objects.requireNonNull(userId);
            Objects.requireNonNull(groupId);
            sdkMessageQuery.setUserId(userId);
            sdkMessageQuery.setGroupId(groupId);
            sdkMessageQuery.setCategory(category);
            sdkMessageQuery.setObjectType(objectType);
            if (Util.isNotEmpty((CharSequence)exceptObjectTypes)) {
                sdkMessageQuery.setExcludeObjectTypeList(Arrays.stream(exceptObjectTypes.split(",")).collect(Collectors.toList()));
            }
            if (status != null) {
                sdkMessageQuery.setReadFlag(status);
            }
            sdkMessageQuery.setFrom(index);
            sdkMessageQuery.setSize(num);
            log.info("getUndoneMessageByClassify forward to messagehub-control(getUndoneMessageByClassify): " + JSONAccessor.impl().format((Object)sdkMessageQuery));
            com.ovopark.module.shared.BaseResult baseResult = this.messageMigrateApi.getUndoneMessageByClassify(sdkMessageQuery);
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (baseResult != null && !baseResult.getIsError().booleanValue()) {
                for (MessageModel userMessage : (List)baseResult.getData()) {
                    MessagePojo oldMessage = new MessagePojo();
                    oldMessage.setId(userMessage.getNumId());
                    oldMessage.setTargetUserId(userMessage.getUserId());
                    oldMessage.setCategory(userMessage.getCategory());
                    oldMessage.setObjectType(userMessage.getObjectType());
                    oldMessage.setObjectId(Util.comparable2Int((Comparable)userMessage.getObjectId()));
                    oldMessage.setObjectIds(userMessage.getObjectIds());
                    oldMessage.setSubId(Util.comparable2Int((Comparable)userMessage.getSubId()));
                    oldMessage.setDescription(userMessage.getDescription());
                    oldMessage.setTitle(userMessage.getTitle());
                    oldMessage.setContent(userMessage.getContent());
                    oldMessage.setI18nKey(userMessage.getI18nKey());
                    oldMessage.setI18nParam(userMessage.getI18nParam());
                    oldMessage.setStatus(Integer.valueOf(userMessage.getReadFlag()).byteValue());
                    oldMessage.setCreatetime(Util.date((LocalDateTime)userMessage.getCreateAt()));
                    list.add(oldMessage);
                }
            }
            map.put("data", list);
            return map;
        }
        log.info("not forward getUndoneMessageByClassify");
        ArrayList<MessagePojo> list = new ArrayList<MessagePojo>();
        if (StringUtils.isBlank((String)objectType)) {
            objectType = null;
        }
        if (StringUtils.isBlank((String)category)) {
            category = null;
        }
        ArrayList<String> exceptObjectTypeList = new ArrayList();
        if (StringUtils.isNotEmpty((String)exceptObjectTypes)) {
            exceptObjectTypeList = Arrays.asList(exceptObjectTypes.split(","));
        }
        if (!CollectionUtils.isEmpty(data = this.messageMapper.getUndoneMessageByClassify(userId, groupId, objectType, category, exceptObjectTypeList, status, isDeal, index, num))) {
            for (Message messages : data) {
                MessagePojo messagePojo = new MessagePojo();
                BeanUtils.copyProperties((Object)messages, (Object)messagePojo);
                messagePojo.setCreatetime(messages.getCreateTime());
                try {
                    if (StringUtils.isNotEmpty((String)messagePojo.getI18nKey())) {
                        if (StringUtils.isEmpty((String)messagePojo.getI18nParam())) {
                            messagePojo.setContent(this.messageSource.getMessage(messagePojo.getI18nKey(), null, locale));
                        } else {
                            messagePojo.setContent(this.messageSource.getMessage(messagePojo.getI18nKey(), (Object[])messagePojo.getI18nParam().split(","), locale));
                        }
                    }
                }
                catch (Exception e) {
                    log.info("message internationalize failed, key:" + messagePojo.getI18nKey());
                    log.error("getUndoneMessageByClassify", (Throwable)e);
                }
                list.add(messagePojo);
            }
        }
        HashMap map = new HashMap();
        map.put("data", list);
        return map;
    }

    private void specialCategroy(List<String> categoryList, Integer userId, Integer groupId, List<MessageClassifyPo> list, String specialCategory) {
        if (CollectionUtils.isEmpty(categoryList) || !categoryList.contains(specialCategory)) {
            MessageClassifyPo messageClassifyPo = new MessageClassifyPo();
            messageClassifyPo.setCategory(specialCategory);
            messageClassifyPo.setCount(Integer.valueOf(0));
            messageClassifyPo.setTargetUserId(userId);
            list.add(messageClassifyPo);
        }
    }

    @Override
    public void updateAllMessage(Integer userId, Integer enterpriseId, String category, String objectType) {
        this.reportMessageApi.readAll(userId, enterpriseId);
        if (this.messageHubMigrateConfig.isUseMessageHubApi()) {
            log.info("updateAllMessage forward to messagehub-control(updateReadFlag): " + userId + ", " + enterpriseId + "," + category + "," + objectType);
            com.ovopark.module.shared.BaseResult baseResult = this.messageMigrateApi.updateReadFlag(userId, enterpriseId, category, objectType);
            if (baseResult == null || baseResult.getIsError().booleanValue()) {
                log.info("updateAllMessage error");
            }
            return;
        }
        this.messageMapper.updateAllMessage(userId, enterpriseId, category, objectType);
    }

    @Override
    public void updateMessageByPrimaryId(Message message, Integer userId) {
        message.setStatus(1);
        if (userId != 1) {
            message.setIsDeal(1);
        }
        this.messageMapper.updateById(message);
    }

    @Override
    public List<Message> findByIdsAndStatus(List<Integer> ids, Integer status) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (status != null) {
            queryWrapper.eq(Message::getStatus, (Object)status);
        }
        queryWrapper.in(Message::getId, ids);
        return this.messageMapper.selectList((Wrapper)queryWrapper);
    }

    @Override
    public void deleteMessageByIds(List<Integer> ids) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(Message::getId, ids);
        this.messageMapper.delete((Wrapper)queryWrapper);
    }

    @Override
    public Message getLastMessage(Integer userId, String objectType, Integer groupId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(Message::getOptionState, (Object)0);
        if (StringUtils.isNotBlank((String)objectType)) {
            queryWrapper.eq(Message::getObjectType, (Object)objectType);
        }
        queryWrapper.eq(Message::getEnterpriseId, (Object)groupId);
        queryWrapper.eq(Message::getTargetUserId, (Object)userId);
        queryWrapper.orderByDesc(Message::getCreateTime);
        queryWrapper.last(" LIMIT 1");
        Message message = (Message)this.messageMapper.selectOne((Wrapper)queryWrapper);
        return message;
    }

    @Override
    public IPage<Message> findUndoneMessages(Page<Message> page, Integer userId, String objectType, Integer groupId, String sortName) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(Message::getOptionState, (Object)0);
        queryWrapper.eq(Message::getStatus, (Object)0);
        if (StringUtils.isNotBlank((String)objectType)) {
            queryWrapper.eq(Message::getObjectType, (Object)objectType);
        }
        queryWrapper.eq(Message::getEnterpriseId, (Object)groupId);
        queryWrapper.eq(Message::getTargetUserId, (Object)userId);
        if (StringUtils.isBlank((String)sortName)) {
            queryWrapper.orderByDesc(Message::getCreateTime);
            queryWrapper.orderByDesc(Message::getId);
        } else {
            queryWrapper.orderByDesc(Message::getCreateTime);
        }
        IPage result = this.messageMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
        return result;
    }

    @Override
    public void deleteMessage(Message message) {
        this.messageMapper.deleteById(message.getId());
    }

    @Override
    @Deprecated
    public boolean deleteMessagesByObject(String objectType, Integer objectId, String objectIds, Integer subId, Integer targetUserId, Integer srcUserId, Integer enterpriseId) {
        List list;
        if (this.messageHubMigrateConfig.isUseMessageHubApi()) {
            return true;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(Message::getObjectType, (Object)objectType);
        if (enterpriseId != null) {
            queryWrapper.eq(Message::getEnterpriseId, (Object)enterpriseId);
        }
        if (objectId != null) {
            queryWrapper.eq(Message::getObjectId, (Object)objectId);
        }
        if (StringUtils.isNotBlank((String)objectIds)) {
            queryWrapper.eq(Message::getObjectIds, (Object)objectIds);
        }
        if (subId != null) {
            queryWrapper.eq(Message::getSubId, (Object)subId);
        }
        if (targetUserId != null) {
            queryWrapper.eq(Message::getTargetUserId, (Object)targetUserId);
        }
        if (srcUserId != null) {
            queryWrapper.eq(Message::getSrcUserId, (Object)srcUserId);
        }
        if (CollectionUtils.isNotEmpty((Collection)(list = this.messageMapper.selectList((Wrapper)queryWrapper)))) {
            this.sendRemoveMessageByWebsocket(list);
            List ids = list.stream().map(Message::getId).collect(Collectors.toList());
            log.info("deleteMessagesByObject ids:{}", ids);
            this.messageMapper.deleteBatchIds(ids);
            if (objectType.equals("FINAL_CHECK_REPORT_NOTIFY")) {
                Integer groupId = ((Message)list.get(0)).getEnterpriseId();
                this.sendRemoveTodoMessageByWeixin(new ArrayList<Long>(), 1, objectType, groupId, objectId, objectIds, 0);
            }
        }
        return true;
    }

    @Override
    @Deprecated
    public boolean updateMessagesByObject(String objectType, Integer objectId, String objectIds, Integer subId, Integer targetUserId, Integer srcUserId, String content) {
        List list;
        if (this.messageHubMigrateConfig.isUseMessageHubApi()) {
            return true;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(Message::getObjectType, (Object)objectType);
        if (objectId != null) {
            queryWrapper.eq(Message::getObjectId, (Object)objectId);
        }
        if (StringUtils.isNotBlank((String)objectIds)) {
            queryWrapper.eq(Message::getObjectIds, (Object)objectIds);
        }
        if (subId != null) {
            queryWrapper.eq(Message::getSubId, (Object)subId);
        }
        if (targetUserId != null) {
            queryWrapper.eq(Message::getTargetUserId, (Object)targetUserId);
        }
        if (srcUserId != null) {
            queryWrapper.eq(Message::getSrcUserId, (Object)srcUserId);
        }
        if (CollectionUtils.isNotEmpty((Collection)(list = this.messageMapper.selectList((Wrapper)queryWrapper)))) {
            for (Message message : list) {
                if (StringUtils.isNotBlank((String)content)) {
                    message.setContent(content);
                }
                this.messageMapper.updateById(message);
            }
        }
        return true;
    }

    @Override
    @Deprecated
    public boolean batchDeleteMessagesByObject(String objectType, List<Integer> objectIds, Integer targetUserId) {
        List list;
        if (this.messageHubMigrateConfig.isUseMessageHubApi()) {
            return true;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(Message::getObjectType, (Object)objectType);
        if (CollectionUtils.isNotEmpty(objectIds)) {
            queryWrapper.in(Message::getObjectId, objectIds);
        }
        if (targetUserId != null) {
            queryWrapper.eq(Message::getTargetUserId, (Object)targetUserId);
        }
        if (CollectionUtils.isNotEmpty((Collection)(list = this.messageMapper.selectList((Wrapper)queryWrapper)))) {
            this.sendRemoveMessageByWebsocket(list);
            List ids = list.stream().map(Message::getId).collect(Collectors.toList());
            this.messageMapper.deleteBatchIds(ids);
        }
        return true;
    }

    @Override
    public boolean deleteMessagesByCategoryAndObjectIds(String category, List<Integer> objectIds, Integer targetUserId) {
        List list;
        if (this.messageHubMigrateConfig.isUseMessageHubApi()) {
            return true;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(Message::getCategory, (Object)category);
        queryWrapper.in(Message::getObjectId, objectIds);
        if (targetUserId != null) {
            queryWrapper.eq(Message::getTargetUserId, (Object)targetUserId);
        }
        if (CollectionUtils.isNotEmpty((Collection)(list = this.messageMapper.selectList((Wrapper)queryWrapper)))) {
            this.sendRemoveMessageByWebsocket(list);
            List ids = list.stream().map(Message::getId).collect(Collectors.toList());
            this.messageMapper.deleteBatchIds(ids);
        }
        return true;
    }

    @Override
    public boolean deleteTodoMessagesByObject(String objectType, Integer objectId, String objectIds, Integer subId, Integer targetUserId, Integer srcUserId, Integer wStatus, Integer isExecutor, Integer enterpriseId) {
        List list;
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(TodoMessage::getObjectType, (Object)objectType);
        if (enterpriseId != null) {
            queryWrapper.eq(TodoMessage::getEnterpriseId, (Object)enterpriseId);
        }
        if (objectId != null) {
            queryWrapper.eq(TodoMessage::getObjectId, (Object)objectId);
        }
        if (StringUtils.isNotBlank((String)objectIds)) {
            queryWrapper.eq(TodoMessage::getObjectIds, (Object)objectIds);
        }
        if (subId != null) {
            queryWrapper.eq(TodoMessage::getSubId, (Object)subId);
        }
        if (targetUserId != null) {
            queryWrapper.eq(TodoMessage::getTargetUserId, (Object)targetUserId);
        }
        if (srcUserId != null) {
            queryWrapper.eq(TodoMessage::getSrcUserId, (Object)srcUserId);
        }
        if (isExecutor != null) {
            queryWrapper.eq(TodoMessage::getIsExecutor, (Object)isExecutor);
        }
        if (CollectionUtils.isNotEmpty((Collection)(list = this.todoMessageMapper.selectList((Wrapper)queryWrapper)))) {
            List<Long> ids = list.stream().map(TodoMessage::getId).collect(Collectors.toList());
            Integer groupId = ((TodoMessage)list.get(0)).getEnterpriseId();
            log.info("deleteTodoMessageByObject ids:{}", ids);
            this.todoMessageMapper.deleteBatchIds(ids);
            this.sendRemoveTodoMessageByWebsocket(list);
            this.sendRemoveTodoMessageByWeixin(ids, wStatus, objectType, groupId, objectId, objectIds, 1);
        }
        return true;
    }

    @Override
    public boolean updateTodoMessagesByObject(String objectType, Integer objectId, String objectIds, Integer subId, Integer targetUserId, Integer srcUserId, String content, String endTime) {
        List list;
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(TodoMessage::getObjectType, (Object)objectType);
        if (objectId != null) {
            queryWrapper.eq(TodoMessage::getObjectId, (Object)objectId);
        }
        if (StringUtils.isNotBlank((String)objectIds)) {
            queryWrapper.eq(TodoMessage::getObjectIds, (Object)objectIds);
        }
        if (subId != null) {
            queryWrapper.eq(TodoMessage::getSubId, (Object)subId);
        }
        if (targetUserId != null) {
            queryWrapper.eq(TodoMessage::getTargetUserId, (Object)targetUserId);
        }
        if (srcUserId != null) {
            queryWrapper.eq(TodoMessage::getSrcUserId, (Object)srcUserId);
        }
        if (CollectionUtils.isNotEmpty((Collection)(list = this.todoMessageMapper.selectList((Wrapper)queryWrapper)))) {
            for (TodoMessage message : list) {
                if (StringUtils.isNotBlank((String)content)) {
                    message.setContent(content);
                }
                if (StringUtils.isNotBlank((String)endTime)) {
                    message.setEndTime(Util.dateTime((String)endTime, (String[])new String[0]));
                }
                this.todoMessageMapper.updateById(message);
            }
        }
        return true;
    }

    @Override
    public boolean batchDeleteTodoMessagesByObject(String objectType, List<Integer> objectIds, Integer targetUserId, Integer wStatus) {
        List list;
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(TodoMessage::getObjectType, (Object)objectType);
        if (CollectionUtils.isNotEmpty(objectIds)) {
            queryWrapper.in(TodoMessage::getObjectId, objectIds);
        }
        if (targetUserId != null) {
            queryWrapper.eq(TodoMessage::getTargetUserId, (Object)targetUserId);
        }
        if (CollectionUtils.isNotEmpty((Collection)(list = this.todoMessageMapper.selectList((Wrapper)queryWrapper)))) {
            List<Long> ids = list.stream().map(TodoMessage::getId).collect(Collectors.toList());
            Integer groupId = ((TodoMessage)list.get(0)).getEnterpriseId();
            this.todoMessageMapper.deleteBatchIds(ids);
            this.sendRemoveTodoMessageByWebsocket(list);
            this.sendRemoveTodoMessageByWeixin(ids, wStatus, objectType, groupId, null, "", 1);
        }
        return true;
    }

    @Override
    @Deprecated
    public void saveBatch(List<com.ovopark.messagehub.kernel.model.mo.MessageMo> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            Integer isTodoMessage = list.get(0).getIsTodoMessage();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            if (isTodoMessage == 1) {
                ArrayList<TodoMessage> messages = new ArrayList<TodoMessage>();
                for (com.ovopark.messagehub.kernel.model.mo.MessageMo mo : list) {
                    TodoMessage message = new TodoMessage();
                    BeanUtils.copyProperties((Object)mo, (Object)message);
                    message.setEndTime(Util.dateTime((Date)mo.getEndTime()));
                    if (StringUtils.isNotEmpty((String)mo.getCreateTime())) {
                        try {
                            message.setCreateTime(Util.dateTime((String)mo.getCreateTime(), (String[])new String[0]));
                        }
                        catch (Exception e) {
                            log.error(e.getMessage(), (Throwable)e);
                        }
                    }
                    if (message.getCreateTime() == null) {
                        message.setCreateTime(LocalDateTime.now());
                    }
                    messages.add(message);
                }
                this.todoMessageMapper.saveBatch(messages);
            } else if (this.messageHubMigrateConfig.isUseMessageHubApi()) {
                MCRequest mcRequest = new MCRequest();
                for (com.ovopark.messagehub.kernel.model.mo.MessageMo mo : list) {
                    Locale locale = "cn".equals(this.messageHubMigrateConfig.getEnv()) ? Locale.SIMPLIFIED_CHINESE : Locale.ENGLISH;
                    String content = mo.getContent();
                    try {
                        if (StringUtils.isNotEmpty((String)mo.getI18nKey())) {
                            content = StringUtils.isEmpty((String)mo.getI18nParam()) ? this.messageSource.getMessage(mo.getI18nKey(), null, locale) : this.messageSource.getMessage(mo.getI18nKey(), (Object[])mo.getI18nParam().split(","), locale);
                        }
                    }
                    catch (Exception e) {
                        log.info("mo internationalize failed, key:" + mo.getI18nKey());
                        log.error("getUndoneMessageByClassify", (Throwable)e);
                    }
                    MessageRequest messageRequest = ((MCRequestBuilders)((MCRequestBuilders)((MCRequestBuilders)((MCRequestBuilders)((MCRequestBuilders)((MCRequestBuilders)((MCRequestBuilders)((MCRequestBuilders)((MCRequestBuilders)((MCRequestBuilders)((MCRequestBuilders)((MCRequestBuilders)MCRequestBuilders.mcRequest((String)MessageMigrateApi.ruleId((String)mo.getCategory(), (String)mo.getObjectType())).toUserIdList(Arrays.asList(mo.getTargetUserId())).sendUserId(Util.comparable2Long((Comparable)mo.getSrcUserId()))).mcCategory(mo.getCategory())).mcObjectType(mo.getObjectType())).mcObjectId(Util.comparable2Long((Comparable)mo.getObjectId()))).mcObjectIds(mo.getObjectIds())).mcSubId(Util.comparable2Long((Comparable)mo.getSubId()))).mcTitle(new ParamContext().plainText(mo.getTitle()))).mcContent(new ParamContext().plainText(content))).mcI18nKey(mo.getI18nKey())).mcI18nParam(mo.getI18nParam())).mcDescription(mo.getDescription())).locale(locale)).build();
                    mcRequest.add(messageRequest);
                }
                log.info("saveBatch forward to messagehub-control(saveMCSync): " + JSONAccessor.impl().format((Object)mcRequest));
                com.ovopark.module.shared.BaseResult baseResult = this.messageHubV2Api.saveMCSync(mcRequest);
                if (baseResult != null && !baseResult.getIsError().booleanValue()) {
                    MCRequestResponse mcRequestResponse = (MCRequestResponse)baseResult.getData();
                    Map success = mcRequestResponse.getSuccess();
                    Map fail = mcRequestResponse.getFail();
                    if (CollectionUtil.isNotEmpty((Map)fail)) {
                        throw new RuntimeException("cannot save message");
                    }
                }
            } else {
                ArrayList<Message> messages = new ArrayList<Message>();
                for (com.ovopark.messagehub.kernel.model.mo.MessageMo mo : list) {
                    Message message = new Message();
                    BeanUtils.copyProperties((Object)mo, (Object)message);
                    if (StringUtils.isNotEmpty((String)mo.getCreateTime())) {
                        try {
                            message.setCreateTime(sdf.parse(mo.getCreateTime()));
                        }
                        catch (ParseException e) {
                            e.printStackTrace();
                        }
                    }
                    if (message.getCreateTime() == null) {
                        message.setCreateTime(new Date());
                    }
                    messages.add(message);
                }
                this.messageMapper.saveBatch(messages);
            }
        }
    }

    @Override
    public void batchEnterpriseWeChat(MessageBatchMo mo) {
        com.ovopark.messagehub.kernel.model.mo.MessageMo messageMo = mo.getMessageMo();
        com.ovopark.messagehub.kernel.model.mo.MessageMo saveMo = mo.getSaveMo();
        if (messageMo != null && messageMo.getIsTodoMessage() != null && messageMo.getIsTodoMessage() == 1 || saveMo != null && saveMo.getIsTodoMessage() != null && saveMo.getIsTodoMessage() == 1) {
            List list;
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(TodoMessage::getObjectType, (Object)messageMo.getObjectType());
            if (StringUtils.isNotEmpty((String)messageMo.getCategory())) {
                queryWrapper.eq(TodoMessage::getCategory, (Object)messageMo.getCategory());
            }
            if (messageMo.getObjectId() != null) {
                queryWrapper.eq(TodoMessage::getObjectId, (Object)messageMo.getObjectId());
            }
            if (StringUtils.isNotBlank((String)messageMo.getObjectIds())) {
                queryWrapper.eq(TodoMessage::getObjectIds, (Object)messageMo.getObjectIds());
            }
            if (messageMo.getSubId() != null) {
                queryWrapper.eq(TodoMessage::getSubId, (Object)messageMo.getSubId());
            }
            if (messageMo.getCreateTime() != null) {
                queryWrapper.eq(TodoMessage::getCreateTime, (Object)messageMo.getCreateTime());
            }
            if (messageMo.getIsExecutor() != null) {
                queryWrapper.eq(TodoMessage::getIsExecutor, (Object)messageMo.getIsExecutor());
            }
            if (messageMo.getEnterpriseId() != null) {
                queryWrapper.eq(TodoMessage::getEnterpriseId, (Object)messageMo.getEnterpriseId());
            }
            if (CollectionUtil.isNotEmpty(mo.getUserIds())) {
                queryWrapper.in(TodoMessage::getTargetUserId, mo.getUserIds());
            }
            if (CollectionUtils.isNotEmpty((Collection)(list = this.todoMessageMapper.selectList((Wrapper)queryWrapper)))) {
                ArrayList<MessageUserMo> batchUser = new ArrayList<MessageUserMo>();
                for (TodoMessage message : list) {
                    long id = message.getId();
                    Integer userId = message.getTargetUserId();
                    MessageUserMo userMo = new MessageUserMo();
                    userMo.setTodoMessageId(Long.valueOf(id));
                    userMo.setUserId(userId);
                    batchUser.add(userMo);
                }
                com.ovopark.messagehub.kernel.model.mo.MessageMo messageMoData = mo.getMo().get(0);
                TodoMessage todoMessage = new TodoMessage();
                BeanUtils.copyProperties((Object)messageMoData, (Object)todoMessage);
                if (mo.getGroupId() != null && todoMessage.getEnterpriseId() == null) {
                    todoMessage.setEnterpriseId(mo.getGroupId());
                }
                this.sendMessageToWeixin(todoMessage, messageMoData, batchUser, mo.getSingleAdd());
            }
        } else {
            List list = null;
            if (!this.messageHubMigrateConfig.isUseMessageHubApi()) {
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(Message::getObjectType, (Object)messageMo.getObjectType());
                if (StringUtils.isNotEmpty((String)messageMo.getCategory())) {
                    queryWrapper.eq(Message::getCategory, (Object)messageMo.getCategory());
                }
                if (messageMo.getObjectId() != null) {
                    queryWrapper.eq(Message::getObjectId, (Object)messageMo.getObjectId());
                }
                if (StringUtils.isNotBlank((String)messageMo.getObjectIds())) {
                    queryWrapper.eq(Message::getObjectIds, (Object)messageMo.getObjectIds());
                }
                if (messageMo.getSubId() != null) {
                    queryWrapper.eq(Message::getSubId, (Object)messageMo.getSubId());
                }
                if (messageMo.getCreateTime() != null) {
                    queryWrapper.eq(Message::getCreateTime, (Object)messageMo.getCreateTime());
                }
                if (messageMo.getEnterpriseId() != null) {
                    queryWrapper.eq(Message::getEnterpriseId, (Object)messageMo.getEnterpriseId());
                }
                if (CollectionUtil.isNotEmpty(mo.getUserIds())) {
                    queryWrapper.in(Message::getTargetUserId, mo.getUserIds());
                }
                list = this.messageMapper.selectList((Wrapper)queryWrapper);
            }
            if (CollectionUtils.isNotEmpty(list) && (messageMo.getCategory().equals("TYPE_TRAINING") && (messageMo.getObjectType().equals("TYPE_MATERIAL_SYSTEM") || messageMo.getObjectType().equals("TYPE_PAPER_SYSTEM") || messageMo.getObjectType().equals("TYPE_OPEADD_EXAMINER_TYPE") || messageMo.getObjectType().equals("TYPE_OPEADD_USER_TYPE") || messageMo.getObjectType().equals("TYPE_OPEUP_EXAMINER_TYPE") || messageMo.getObjectType().equals("TYPE_OPEDEL_TYPE") || messageMo.getObjectType().equals("TYPE_OPEUP_USER_TYPE")) || messageMo.getCategory().equals("TYPE_OA_APPROVAL") && messageMo.getObjectType().equals("OA_Approval_Notify"))) {
                ArrayList<MessageUserMo> batchUser = new ArrayList<MessageUserMo>();
                for (Message message : list) {
                    long id = message.getId();
                    Integer userId = message.getTargetUserId();
                    MessageUserMo userMo = new MessageUserMo();
                    userMo.setTodoMessageId(null);
                    userMo.setUserId(userId);
                    batchUser.add(userMo);
                }
                com.ovopark.messagehub.kernel.model.mo.MessageMo messageMoData = mo.getMo().get(0);
                TodoMessage todoMessage = new TodoMessage();
                BeanUtils.copyProperties((Object)messageMoData, (Object)todoMessage);
                if (mo.getGroupId() != null && todoMessage.getEnterpriseId() == null) {
                    todoMessage.setEnterpriseId(mo.getGroupId());
                }
                this.sendMessageToWeixin(todoMessage, messageMoData, batchUser, mo.getSingleAdd());
            }
        }
    }

    @Override
    public List<MessageObjectTypeResp> getUndoneMessageObjectType(Integer userId, Integer groupId, Locale locale, MessageObjectReq req) {
        String category = req.getCategory();
        List<String> objectTypeList = req.getObjectType().stream().map(e -> MessageObjectTypeEnum.format((String)e).getDesc()).collect(Collectors.toList());
        objectTypeList.addAll(req.getObjectType().stream().map(e -> MessageObjectTypeNewEnum.format((String)e).getDesc()).collect(Collectors.toList()));
        LinkedList<MessageObjectTypeResp> resqs = new LinkedList<MessageObjectTypeResp>();
        List<MessageObjectTypeResp> unReadList = this.messageMapper.queryUndoContentInfoByCategoryAndObjectType(userId, category, objectTypeList, 0);
        unReadList.stream().forEach(messageObjectTypeResp -> messageObjectTypeResp.setNewObjectType(MessageObjectTypeNewEnum.format((String)messageObjectTypeResp.getObjectType()).getDesc()));
        List<MessageObjectTypeResp> doReadList = this.messageMapper.queryUndoContentInfoByCategoryAndObjectType(userId, category, objectTypeList, 1);
        doReadList.stream().forEach(messageObjectTypeResp -> messageObjectTypeResp.setNewObjectType(MessageObjectTypeNewEnum.format((String)messageObjectTypeResp.getObjectType()).getDesc()));
        Map objectTypeMap = unReadList.stream().collect(Collectors.toMap(e -> MessageObjectTypeNewEnum.format((String)e.getNewObjectType()).getDesc(), Function.identity(), (oldWorking, newWorking) -> newWorking.getId() > oldWorking.getId() ? newWorking : oldWorking));
        Map newObjectTypeMap = doReadList.stream().collect(Collectors.toMap(e -> MessageObjectTypeNewEnum.format((String)e.getNewObjectType()).getDesc(), Function.identity(), (oldWorking, newWorking) -> newWorking.getId() > oldWorking.getId() ? newWorking : oldWorking));
        for (String string : req.getObjectType()) {
            MessageObjectTypeResp resp = new MessageObjectTypeResp();
            if (objectTypeMap.containsKey(MessageObjectTypeNewEnum.format((String)string).getDesc())) {
                BeanUtils.copyProperties(objectTypeMap.get(MessageObjectTypeNewEnum.format((String)string).getDesc()), (Object)resp);
            } else {
                resp.setObjectType(string);
            }
            if (StringUtils.isBlank((String)resp.getContent()) && newObjectTypeMap.containsKey(MessageObjectTypeNewEnum.format((String)string).getDesc())) {
                BeanUtils.copyProperties(newObjectTypeMap.get(MessageObjectTypeNewEnum.format((String)string).getDesc()), (Object)resp);
            }
            if (!StringUtils.isNotBlank((String)resp.getContent())) continue;
            resqs.add(resp);
        }
        List<MessageObjectTypeGroupResp> countList = this.messageMapper.queryUndoCountByCategoryAndObjectType(userId, category, objectTypeList);
        countList.stream().forEach(messageObjectTypeGroupResp -> messageObjectTypeGroupResp.setNewObjectType(MessageObjectTypeNewEnum.format((String)messageObjectTypeGroupResp.getObjectType()).getDesc()));
        Map<Object, Object> objectTypeCountMap = new HashMap();
        if (!CollectionUtils.isEmpty(countList)) {
            objectTypeCountMap = countList.stream().collect(Collectors.toMap(e -> MessageObjectTypeNewEnum.format((String)e.getNewObjectType()).getDesc(), MessageObjectTypeGroupResp::getCount, (o1, o2) -> o2 + o1));
        }
        for (MessageObjectTypeResp messageObjectTypeResp2 : resqs) {
            messageObjectTypeResp2.setObjectType(MessageObjectTypeEnum.formatOrNull((String)messageObjectTypeResp2.getNewObjectType()).getDesc());
            messageObjectTypeResp2.setNewObjectType(MessageObjectTypeNewEnum.formatOrNull((String)messageObjectTypeResp2.getNewObjectType()).getDesc());
            Integer objectTypeUndoCount = (Integer)objectTypeCountMap.get(MessageObjectTypeNewEnum.formatOrNull((String)messageObjectTypeResp2.getNewObjectType()).getDesc());
            if (objectTypeUndoCount != null) {
                messageObjectTypeResp2.setCount(objectTypeUndoCount);
            }
            if (messageObjectTypeResp2.getCreateTime() == null) continue;
            messageObjectTypeResp2.setCreateTimeStr(DateUtils.getDateStr(messageObjectTypeResp2.getCreateTime()));
        }
        return resqs;
    }

    @Override
    public Page<StorePlanMessageBo> getUnDoStorePlanMsg(Integer userId, Integer groupId, Integer page, Integer pageSize, String objectType) {
        Page boPage = new Page();
        Page result = new Page();
        result.setCurrent((long)page.intValue());
        result.setSize((long)pageSize.intValue());
        List<String> objectTypes = Arrays.asList(MessageObjectTypeNewEnum.format((String)objectType).getDesc(), MessageObjectTypeEnum.format((String)objectType).getDesc());
        ArrayList<Integer> userIds = new ArrayList<Integer>();
        IPage messageIPage = this.messageMapper.selectPage((IPage)result, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Message::getTargetUserId, (Object)userId)).eq(Message::getEnterpriseId, (Object)groupId)).in(Message::getObjectType, objectTypes)).last(" order by  status , createtime desc"));
        List<Object> storePlanMessageBos = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)messageIPage.getRecords())) {
            storePlanMessageBos = messageIPage.getRecords().stream().map(e -> {
                StorePlanMessageBo bo = new StorePlanMessageBo();
                BeanUtils.copyProperties((Object)e, (Object)bo);
                bo.setNewObjectType(MessageObjectTypeNewEnum.formatOrNull((String)bo.getObjectType()).getDesc());
                return bo;
            }).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty(storePlanMessageBos)) {
            for (StorePlanMessageBo storePlanMessageBo : storePlanMessageBos) {
                if (storePlanMessageBo.getSrcUserId() == null) continue;
                userIds.add(storePlanMessageBo.getSrcUserId());
            }
        }
        if (!CollectionUtils.isEmpty(userIds)) {
            List<UsersPojo> users = this.usersService.getUserByIdList(userIds);
            HashMap<Integer, UserBo> hashMap = new HashMap<Integer, UserBo>();
            if (!CollectionUtils.isEmpty(users)) {
                for (UsersPojo usersPojo : users) {
                    UserBo userBo = new UserBo();
                    userBo.setUserName(usersPojo.getUserName());
                    userBo.setUserId(usersPojo.getId());
                    userBo.setShowName(usersPojo.getShowName());
                    userBo.setShortName(UserUtils.getShortName(usersPojo.getShowName()));
                    userBo.setPicture(usersPojo.getThumbUrl());
                    hashMap.put(usersPojo.getId(), userBo);
                }
            }
            if (!CollectionUtils.isEmpty(storePlanMessageBos)) {
                for (StorePlanMessageBo storePlanMessageBo : storePlanMessageBos) {
                    if (storePlanMessageBo.getSrcUserId() == null || hashMap.get(storePlanMessageBo.getSrcUserId()) == null) continue;
                    storePlanMessageBo.setObjectType(MessageObjectTypeEnum.formatOrNull((String)storePlanMessageBo.getNewObjectType()).getDesc());
                    storePlanMessageBo.setUserBo((UserBo)hashMap.get(storePlanMessageBo.getSrcUserId()));
                    storePlanMessageBo.setNewObjectType(MessageObjectTypeNewEnum.formatOrNull((String)storePlanMessageBo.getObjectType()).getDesc());
                }
            }
        }
        BeanUtils.copyProperties((Object)result, (Object)boPage);
        if (!CollectionUtils.isEmpty(storePlanMessageBos)) {
            boPage.setRecords(storePlanMessageBos);
        } else {
            result.setRecords(new ArrayList());
        }
        return boPage;
    }

    @Override
    public void sendMessageToWeixin(final TodoMessage todoMessage, final com.ovopark.messagehub.kernel.model.mo.MessageMo messageMo, List<MessageUserMo> batchUser, final Boolean isSingleAdd) {
        log.info("sendMessageToWeixin==" + String.valueOf(JSONObject.toJSON((Object)messageMo)) + "batchUser:" + JSONObject.toJSONString(batchUser) + "todoMessage:" + JSONObject.toJSONString((Object)todoMessage));
        try {
            if (todoMessage.getEnterpriseId() != null) {
                SystemConfigureMo configure = this.systemConfigureService.getSystemConfigureByGroupId(todoMessage.getEnterpriseId(), null, 0);
                SystemConfigureMo dingdingConfigure = this.systemConfigureService.getSystemConfigureByGroupId(todoMessage.getEnterpriseId(), null, 1);
                SystemConfigureMo feishuConfigure = this.systemConfigureService.getSystemConfigureByGroupId(todoMessage.getEnterpriseId(), null, 2);
                if (configure != null && configure.getIsSendMessage() == 0 || dingdingConfigure != null && dingdingConfigure.getIsSendMessage() == 0 || feishuConfigure != null && feishuConfigure.getIsSendMessage() == 0) {
                    return;
                }
                Boolean sendWechat = false;
                Boolean sendDingding = false;
                Boolean sendFeishu = false;
                UsersPojo users = new UsersPojo();
                final ArrayList<String> dingdingUsers = new ArrayList<String>();
                final ArrayList<String> feishuUsers = new ArrayList<String>();
                if (CollectionUtils.isNotEmpty(batchUser)) {
                    List<Integer> userIds = batchUser.stream().map(MessageUserMo::getUserId).distinct().collect(Collectors.toList());
                    List<UsersPojo> usersList = this.usersService.getUserByIdList(userIds);
                    ArrayList<Integer> weChatUsers = new ArrayList<Integer>();
                    HashMap<Integer, UsersPojo> usersMap = new HashMap<Integer, UsersPojo>();
                    if (CollectionUtils.isNotEmpty(usersList)) {
                        for (UsersPojo user : usersList) {
                            Integer userOneId = user.getId();
                            usersMap.put(userOneId, user);
                            String trilateralId = user.getTrilateralId();
                            String encryptionUserid = user.getEncryptionUserid();
                            String dingding = user.getDingdingUserId();
                            String feishuUser = user.getFeishuOpenId();
                            if (StringUtils.isNotEmpty((String)trilateralId) && !weChatUsers.contains(userOneId)) {
                                weChatUsers.add(userOneId);
                            }
                            if (StringUtils.isNotEmpty((String)encryptionUserid) && !weChatUsers.contains(userOneId)) {
                                weChatUsers.add(userOneId);
                            }
                            if (StringUtils.isNotEmpty((String)dingding) && !dingdingUsers.contains(dingding)) {
                                dingdingUsers.add(dingding);
                                sendDingding = true;
                            }
                            if (!StringUtils.isNotEmpty((String)feishuUser) || feishuUsers.contains(feishuUser)) continue;
                            feishuUsers.add(feishuUser);
                            sendFeishu = true;
                        }
                    }
                    if (configure != null && CollectionUtils.isNotEmpty(weChatUsers)) {
                        ArrayList<MessageUserMo> userMos = new ArrayList<MessageUserMo>();
                        for (MessageUserMo userMo : batchUser) {
                            UsersPojo usersOne;
                            if (!weChatUsers.contains(userMo.getUserId()) || (usersOne = (UsersPojo)usersMap.get(userMo.getUserId())) == null) continue;
                            userMo.setEncryptionUserid(usersOne.getEncryptionUserid());
                            userMo.setTrilateralId(usersOne.getTrilateralId());
                            userMos.add(userMo);
                        }
                        if (CollectionUtils.isNotEmpty(userMos)) {
                            sendWechat = true;
                            batchUser = new ArrayList<MessageUserMo>(userMos);
                        }
                    }
                } else if (todoMessage.getTargetUserId() != null && (users = this.usersService.getUserById(todoMessage.getTargetUserId())) != null) {
                    if (StringUtils.isNotEmpty((String)users.getTrilateralId()) || StringUtils.isNotEmpty((String)users.getEncryptionUserid())) {
                        sendWechat = true;
                    }
                    if (StringUtils.isNotEmpty((String)users.getDingdingUserId())) {
                        sendDingding = true;
                    }
                    if (StringUtils.isNotEmpty((String)users.getFeishuOpenId())) {
                        sendFeishu = true;
                    }
                }
                if (configure != null && sendWechat.booleanValue()) {
                    final List<MessageUserMo> finalBatchUser = batchUser;
                    ThreadPoolTaskUtils.getThreadPool().execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                WeixinMessageMo mo = MessageUtil.getWechatMo(messageMo, todoMessage, finalBatchUser);
                                mo.setSingleAdd(isSingleAdd);
                                log.info("saveWeiXinMessages:" + JSONObject.toJSONString((Object)mo));
                                com.ovopark.weixin.response.BaseResult baseResult = TodoMessageServiceImpl.this.weiXinMessageApi.saveWeiXinMessages(mo);
                            }
                            catch (Exception e) {
                                log.info("weiXinMessageApi.saveWeiXinMessages" + JSONObject.toJSONString((Object)e));
                            }
                        }
                    });
                } else if (dingdingConfigure != null && sendDingding.booleanValue()) {
                    final UsersPojo finalUsers = users;
                    ThreadPoolTaskUtils.getThreadPool().execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                com.ovopark.dingding.web.MessageMo mo = MessageUtil.getDingdingMo(messageMo, todoMessage, dingdingUsers, finalUsers);
                                mo.setSingleAdd(isSingleAdd);
                                log.info("dingdingMessageApi:" + JSONObject.toJSONString((Object)mo));
                                com.ovopark.dingding.web.BaseResult result = TodoMessageServiceImpl.this.dingdingMessageApi.sendCardTextMessage(mo);
                                log.info("savedingdingMessageApi:" + JSONObject.toJSONString((Object)todoMessage) + "result" + JSONObject.toJSONString((Object)result));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                } else if (feishuConfigure != null && sendFeishu.booleanValue()) {
                    final UsersPojo finalUsers1 = users;
                    ThreadPoolTaskUtils.getThreadPool().execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                MessageMo mo = MessageUtil.getFeishuMo(messageMo, todoMessage, finalUsers1, feishuUsers);
                                mo.setSingleAdd(isSingleAdd);
                                log.info("feishuMessageApi:" + JSONObject.toJSONString((Object)mo));
                                BaseResult baseResult = TodoMessageServiceImpl.this.feishuMessageApi.sendCardTextMessage(mo);
                            }
                            catch (Exception e) {
                                log.info("weiXinMessageApi.feishuMessageApi" + JSONObject.toJSONString((Object)e));
                            }
                        }
                    });
                }
            }
        }
        catch (Exception e) {
            log.error("sendMessageToWeixin" + JSONObject.toJSONString((Object)e));
        }
    }

    @Override
    public void sendRemoveTodoMessageByWeixin(final List<Long> ids, final Integer wStatus, final String objectType, final Integer groupId, final Integer objectId, final String objectIds, final Integer isTodoMessage) {
        log.info("sendRemoveTodoMessageByWeixin" + JSONObject.toJSONString(ids) + "objectId==" + objectId + "objectType==" + objectType);
        List<Object> notNeedDeletObjectType = new ArrayList();
        String redisKey = RedisVo.getUnDeleteWechatObjectType;
        String object = (String)this.redisUtil.get(redisKey);
        if (StringUtils.isEmpty((String)object)) {
            notNeedDeletObjectType = this.messageMapper.getUnDeleteWechatObjectType();
            this.redisUtil.set(redisKey, JSONObject.toJSONString(notNeedDeletObjectType), 5L, TimeUnit.HOURS);
        } else {
            notNeedDeletObjectType = JSONObject.parseArray((String)object, String.class);
        }
        if (groupId == null || CollectionUtils.isEmpty(ids) && objectId == null && StringUtils.isEmpty((String)objectIds) || notNeedDeletObjectType.contains(objectType)) {
            log.info("deleteWeixinMessagesByIdsNull" + JSONObject.toJSONString((Object)objectType));
            return;
        }
        log.info("sendRemoveTodoMessageByWeixin====" + objectType);
        try {
            SystemConfigureMo systemConfigure = this.systemConfigureService.getSystemConfigureByGroupId(groupId, "", 0);
            if (systemConfigure != null && systemConfigure.getIsSendMessage() == 1) {
                ThreadPoolTaskUtils.getThreadPool().execute(new Runnable(){

                    @Override
                    public void run() {
                        log.info("deleteWeixinMessagesByIds" + JSONObject.toJSONString((Object)ids) + "wStatus" + wStatus);
                        WeixinMessageMo mo = new WeixinMessageMo();
                        if (CollectionUtils.isNotEmpty((Collection)ids)) {
                            if (isTodoMessage == 0) {
                                mo.setMessageIdIds(ids);
                            } else {
                                mo.setTodoMessageIds(ids);
                            }
                        }
                        if (wStatus != null) {
                            mo.setwStatus(wStatus);
                        }
                        if (groupId != null) {
                            mo.setGroupId(groupId);
                        }
                        if (objectId != null) {
                            mo.setObjectId(objectId);
                        }
                        if (StringUtils.isNotEmpty((String)objectIds)) {
                            mo.setObjectIds(objectIds);
                        }
                        mo.setObjectType(objectType);
                        try {
                            com.ovopark.weixin.response.BaseResult result = TodoMessageServiceImpl.this.weiXinMessageApi.deleteWeixinMessagesByIds(mo);
                            log.info("deleteWeixinMessagesByIds" + JSONObject.toJSONString((Object)result));
                        }
                        catch (Exception e) {
                            log.info("sendRemoveTodoMessageByWeixin" + JSONObject.toJSONString((Object)e));
                            log.info("sendRemoveTodoMessageByWeixin" + JSONObject.toJSONString((Object)mo));
                        }
                    }
                });
            } else {
                SystemConfigureMo dingdingConfigure = this.systemConfigureService.getSystemConfigureByGroupId(groupId, "", 1);
                if (dingdingConfigure != null && dingdingConfigure.getIsSendMessage() == 1) {
                    ThreadPoolTaskUtils.getThreadPool().execute(new Runnable(){

                        @Override
                        public void run() {
                            com.ovopark.dingding.web.MessageMo mo = new com.ovopark.dingding.web.MessageMo();
                            if (CollectionUtils.isNotEmpty((Collection)ids)) {
                                mo.setTodoMessageIds(ids);
                            }
                            if (wStatus != null) {
                                mo.setwStatus(wStatus);
                            }
                            if (groupId != null) {
                                mo.setGroupId(groupId);
                            }
                            if (objectId != null) {
                                mo.setObjectId(objectId);
                            }
                            if (StringUtils.isNotEmpty((String)objectIds)) {
                                mo.setObjectIds(objectIds);
                            }
                            mo.setObjectType(objectType);
                            try {
                                com.ovopark.dingding.web.BaseResult result = TodoMessageServiceImpl.this.dingdingMessageApi.deleteWeixinMessagesByIds(mo);
                                log.info("deletedingdingMessageApis" + JSONObject.toJSONString((Object)result));
                            }
                            catch (Exception e) {
                                log.info("senddingdingMessageApin" + JSONObject.toJSONString((Object)mo) + String.valueOf(e));
                            }
                        }
                    });
                } else {
                    SystemConfigureMo feishuConfigure = this.systemConfigureService.getSystemConfigureByGroupId(groupId, "", 2);
                    if (feishuConfigure != null && feishuConfigure.getIsSendMessage() == 1) {
                        ThreadPoolTaskUtils.getThreadPool().execute(new Runnable(){

                            @Override
                            public void run() {
                                MessageMo mo = new MessageMo();
                                if (CollectionUtils.isNotEmpty((Collection)ids)) {
                                    mo.setTodoMessageIds(ids);
                                }
                                if (wStatus != null) {
                                    mo.setwStatus(wStatus);
                                }
                                if (groupId != null) {
                                    mo.setGroupId(groupId);
                                }
                                if (objectId != null) {
                                    mo.setObjectId(objectId);
                                }
                                if (StringUtils.isNotEmpty((String)objectIds)) {
                                    mo.setObjectIds(objectIds);
                                }
                                mo.setObjectType(objectType);
                                try {
                                    BaseResult result = TodoMessageServiceImpl.this.feishuMessageApi.deleteWeixinMessagesByIds(mo);
                                    log.info("feishuMessageApi" + JSONObject.toJSONString((Object)result));
                                }
                                catch (Exception e) {
                                    log.info("feishuMessageApi" + JSONObject.toJSONString((Object)mo) + String.valueOf(e));
                                }
                            }
                        });
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("sendRemoveTodoMessageByWeixin" + JSONObject.toJSONString((Object)e));
        }
    }

    @Override
    public List<Integer> getUserByTypeAndObject(Integer groupId, String objectType, Integer fieldId) {
        List<Integer> userIds = new ArrayList<Integer>();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(Message::getEnterpriseId, (Object)groupId);
        queryWrapper.eq(Message::getObjectType, (Object)objectType);
        queryWrapper.eq(Message::getObjectId, (Object)fieldId);
        List messages = this.messageMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtil.isNotEmpty((Collection)messages)) {
            userIds = messages.stream().distinct().map(Message::getTargetUserId).collect(Collectors.toList());
        }
        return userIds;
    }

    @Override
    public List<Long> getMessageByObjectIds(Integer groupId, String objectType, String category, List<Integer> commonIds) {
        List<Long> messageIds = new ArrayList<Long>();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(Message::getEnterpriseId, (Object)groupId);
        queryWrapper.eq(Message::getObjectType, (Object)objectType);
        queryWrapper.eq(Message::getCategory, (Object)category);
        queryWrapper.in(Message::getObjectIds, commonIds);
        List messages = this.messageMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtil.isNotEmpty((Collection)messages)) {
            messageIds = messages.stream().distinct().map(Message::getId).collect(Collectors.toList());
        }
        return messageIds;
    }

    @Override
    public void deleteMessageByLongIds(List<Long> ids) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(Message::getId, ids);
        this.messageMapper.delete((Wrapper)queryWrapper);
    }

    @Override
    public List<Integer> getHasTodoMessageUserIds(List<Integer> userIds, Integer groupId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(TodoMessage::getTargetUserId, userIds);
        queryWrapper.in(TodoMessage::getEnterpriseId, new Object[]{groupId});
        queryWrapper.select(new SFunction[]{TodoMessage::getTargetUserId});
        List todoMessages = this.todoMessageMapper.selectList((Wrapper)queryWrapper);
        return todoMessages.stream().map(TodoMessage::getTargetUserId).distinct().collect(Collectors.toList());
    }

    @Override
    public Boolean setMessagesStatusByObject(MeaasgeAndWeixinMo mo) {
        List list;
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(Message::getObjectType, (Object)mo.getObjectType());
        if (mo.getObjectId() != null) {
            queryWrapper.eq(Message::getObjectId, (Object)mo.getObjectId());
        }
        if (CollectionUtils.isNotEmpty(mo.getObjectIdList())) {
            queryWrapper.in(Message::getObjectId, mo.getObjectIdList());
        }
        if (StringUtils.isNotBlank((String)mo.getObjectIds())) {
            queryWrapper.eq(Message::getObjectIds, (Object)mo.getObjectIds());
        }
        if (mo.getSubId() != null) {
            queryWrapper.eq(Message::getSubId, (Object)mo.getSubId());
        }
        if (mo.getTargetUserId() != null) {
            queryWrapper.eq(Message::getTargetUserId, (Object)mo.getTargetUserId());
        }
        if (mo.getSrcUserId() != null) {
            queryWrapper.eq(Message::getSrcUserId, (Object)mo.getSrcUserId());
        }
        if (CollectionUtil.isNotEmpty(mo.getIds())) {
            queryWrapper.in(Message::getId, mo.getIds());
        }
        if (CollectionUtils.isNotEmpty((Collection)(list = this.messageMapper.selectList((Wrapper)queryWrapper)))) {
            this.sendRemoveMessageByWebsocket(list);
            List ids = list.stream().map(Message::getId).collect(Collectors.toList());
            this.messageMapper.deleteBatchIds(ids);
            ThreadPoolTaskUtils.getThreadPool().execute(() -> this.messageMapper.batchSaveMessagesHistoryByObject(list));
        }
        return true;
    }

    @Override
    public Boolean setTodoMessagesStatusByObject(MeaasgeAndWeixinMo mo) {
        List list;
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(TodoMessage::getObjectType, (Object)mo.getObjectType());
        if (mo.getObjectId() != null) {
            queryWrapper.eq(TodoMessage::getObjectId, (Object)mo.getObjectId());
        }
        if (CollectionUtils.isNotEmpty(mo.getObjectIdList())) {
            queryWrapper.in(TodoMessage::getObjectId, mo.getObjectIdList());
        }
        if (StringUtils.isNotBlank((String)mo.getObjectIds())) {
            queryWrapper.eq(TodoMessage::getObjectIds, (Object)mo.getObjectIds());
        }
        if (mo.getSubId() != null) {
            queryWrapper.eq(TodoMessage::getSubId, (Object)mo.getSubId());
        }
        if (mo.getTargetUserId() != null) {
            queryWrapper.eq(TodoMessage::getTargetUserId, (Object)mo.getTargetUserId());
        }
        if (mo.getSrcUserId() != null) {
            queryWrapper.eq(TodoMessage::getSrcUserId, (Object)mo.getSrcUserId());
        }
        if (mo.getIsExecutor() != null) {
            queryWrapper.eq(TodoMessage::getIsExecutor, (Object)mo.getIsExecutor());
        }
        if (CollectionUtil.isNotEmpty(mo.getIds())) {
            queryWrapper.in(TodoMessage::getId, mo.getIds());
        }
        if (CollectionUtils.isNotEmpty((Collection)(list = this.todoMessageMapper.selectList((Wrapper)queryWrapper)))) {
            List ids = list.stream().map(TodoMessage::getId).collect(Collectors.toList());
            this.todoMessageMapper.deleteBatchIds(ids);
            this.sendRemoveTodoMessageByWebsocket(list);
            ThreadPoolTaskUtils.getThreadPool().execute(() -> this.todoMessageMapper.batchSaveTodoMessagesHistoryByObject(list));
        }
        return true;
    }

    @Override
    public void updateTodoMessageStatusByIds(List<Long> ids) {
        if (CollectionUtils.isNotEmpty(ids)) {
            Object oneValue = "(";
            Integer number = 0;
            Integer totalNumber = ids.size();
            for (Long depId : ids) {
                Integer n = number;
                number = number + 1;
                oneValue = number == 1 ? (String)oneValue + depId : (String)oneValue + "," + depId;
                if (number <= 1000 && number.intValue() != totalNumber.intValue()) continue;
                oneValue = (String)oneValue + ")";
                this.todoMessageMapper.setStatusByIds((String)oneValue);
                oneValue = "(";
                totalNumber = totalNumber - number;
                number = 0;
            }
        }
    }

    @Override
    public void updateStatusByIds(List<Long> ids) {
        if (CollectionUtils.isNotEmpty(ids)) {
            Object oneValue = "(";
            Integer number = 0;
            Integer totalNumber = ids.size();
            for (Long depId : ids) {
                Integer n = number;
                number = number + 1;
                oneValue = number == 1 ? (String)oneValue + depId : (String)oneValue + "," + depId;
                if (number <= 1000 && number.intValue() != totalNumber.intValue()) continue;
                oneValue = (String)oneValue + ")";
                this.messageMapper.setStatusByIds((String)oneValue);
                oneValue = "(";
                totalNumber = totalNumber - number;
                number = 0;
            }
        }
    }

    @Override
    public void sendMessageToWeChat(com.ovopark.messagehub.kernel.model.mo.MessageMo messageMo) {
        String url = this.weChatUrl + "ovopark-wechat-message/inner/message/templateWithUserIds";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("userIds", messageMo.getTargetUserId());
        param.put("message", messageMo.getJsonText());
        String result = HttpUtils.sendPostToOtherServer(url, param);
        if (StringUtils.isEmpty((String)result)) {
            log.info("sendMessageToWeChat==" + JSONObject.toJSONString((Object)messageMo));
        } else {
            JSONObject object = JSONObject.parseObject((String)result);
            if (object == null || object.get((Object)"isError").toString().equals("true")) {
                log.info("sendMessageToWeChat==" + JSONObject.toJSONString((Object)messageMo) + "result:" + result);
            }
        }
    }

    @Override
    public List<com.ovopark.messagehub.kernel.model.mo.MessageMo> getMessageByObjectTypeAndObjectId(String objectType, Integer objectId, Integer targetUserId) {
        return this.messageMapper.getMessageByObjectTypeAndObjectId(objectType, objectId, targetUserId);
    }

    @Override
    public void updateTargetUserIds(List<Integer> sourceUserIds, Integer targetUserId, Integer enterpriseId, List<String> categories) {
        this.messageMapper.updateTargetUserIds(sourceUserIds, targetUserId, enterpriseId, categories);
        this.todoMessageMapper.updateTargetUserIds(sourceUserIds, targetUserId, enterpriseId, categories);
    }

    @Override
    public Integer getTodoMessageCount(Integer userId, Integer enterpriseId, String category, List<String> objectTypes) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(TodoMessage::getTargetUserId, (Object)userId);
        if (enterpriseId != null) {
            queryWrapper.eq(TodoMessage::getEnterpriseId, (Object)enterpriseId);
        } else {
            queryWrapper.isNull(TodoMessage::getEnterpriseId);
        }
        queryWrapper.eq(TodoMessage::getCategory, (Object)category);
        queryWrapper.in(TodoMessage::getObjectType, objectTypes);
        return this.todoMessageMapper.selectCount((Wrapper)queryWrapper).intValue();
    }

    private void sendRemoveTodoMessageByWebsocket(List<TodoMessage> messages) {
        ThreadPoolTaskUtils.getThreadPool().execute(() -> {
            for (TodoMessage message : messages) {
                MessageRequest messageRequest = ((SubsBuilders.WBSBuilder)((SubsBuilders.WBSBuilder)((SubsBuilders.WBSBuilder)((SubsBuilders.WBSBuilder)SubsBuilders.flightWBS().from("todo")).toUserIdList(Collections.singletonList(message.getTargetUserId()))).content(new ParamContext().plainText(JSON.toJSONString((Object)message))).locale(Locale.CHINA)).tagList(Arrays.asList("todo", "delete"))).client(new String[]{"iOS", "Android"}).messageType("1006").build();
                com.ovopark.module.shared.BaseResult baseResult = this.messageHubV2Api.send(messageRequest);
                String msgId = null;
                if (baseResult.getIsError().booleanValue()) continue;
                msgId = (String)baseResult.getData();
                log.info("message trace id: " + msgId);
            }
        });
    }

    private void sendRemoveMessageByWebsocket(List<Message> messages) {
        ThreadPoolTaskUtils.getThreadPool().execute(() -> {
            for (Message message : messages) {
                MessageRequest messageRequest = ((SubsBuilders.WBSBuilder)((SubsBuilders.WBSBuilder)((SubsBuilders.WBSBuilder)((SubsBuilders.WBSBuilder)SubsBuilders.flightWBS().from("message")).toUserIdList(Collections.singletonList(message.getTargetUserId()))).content(new ParamContext().plainText(JSON.toJSONString((Object)message))).locale(Locale.CHINA)).tagList(Arrays.asList("message", "delete"))).client(new String[]{"iOS", "Android"}).messageType("1006").build();
                com.ovopark.module.shared.BaseResult baseResult = this.messageHubV2Api.send(messageRequest);
                String msgId = null;
                if (baseResult.getIsError().booleanValue()) continue;
                msgId = (String)baseResult.getData();
                log.info("message trace id: " + msgId);
            }
        });
    }
}

