/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.kernel;

import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import com.ovopark.messagehub.kernel.InternalWebSocketService;
import com.ovopark.messagehub.sdk.MessageHubV2Api;
import com.ovopark.messagehub.sdk.model.ParamContext;
import com.ovopark.messagehub.sdk.model.SubsBuilders;
import com.ovopark.messagehub.sdk.model.ToUserGroup;
import com.ovopark.module.shared.BaseResult;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SimpleWebSocketServiceImpl
implements InternalWebSocketService {
    @Autowired
    private MessageHubV2Api messageHubV2Api;

    @Override
    public void send(Integer userId, String message, String messageType, String ... clients) {
        BaseResult baseResult = this.messageHubV2Api.send(((SubsBuilders.WBSBuilder)SubsBuilders.flightWBS().toUserIdList(List.of(userId))).messageType(messageType).client(clients).content(new ParamContext().plainText(message)).build());
        Util.log.info("send wbs, result: " + JSONAccessor.impl().format((Object)baseResult));
    }

    @Override
    public void send(List<Integer> userIdList, String message, String messageType, String ... clients) {
        for (Integer u : userIdList) {
            this.send(u, message, messageType, clients);
        }
    }

    @Override
    public void broadcast(String message, String messageType) {
        BaseResult baseResult = this.messageHubV2Api.send(((SubsBuilders.WBSBuilder)SubsBuilders.flightWBS().toGroup(ToUserGroup.allConnectedUsersViaWbs())).messageType(messageType).client(new String[]{"web", "Android", "iOS"}).content(new ParamContext().plainText(message)).build());
        Util.log.info("broadcast wbs, result: " + JSONAccessor.impl().format((Object)baseResult));
    }
}

