/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.kernel;

import com.ovopark.kernel.shared.NetUtil;
import com.ovopark.kernel.shared.Util;
import com.ovopark.messagehub.kernel.MsgHubSharedConfig;
import com.ovopark.messagehub.kernel.NodeManager;
import com.ovopark.messagehub.kernel.SimpleNodeManager;
import jakarta.annotation.PostConstruct;
import java.net.InetAddress;
import java.net.URI;
import java.time.LocalDateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.stereotype.Component;

@Component
public class NacosNodeProvider
implements NodeManager.NodeProvider {
    @Autowired
    private ServiceInstance serviceInstance;
    @Autowired
    private MsgHubSharedConfig msgHubSharedConfig;
    @Value(value="${server.port:-1}")
    private int port;

    @PostConstruct
    private void post() {
        SimpleNodeManager.getOrCreate().register(this);
    }

    @Override
    public NodeManager.Node node() {
        URI uri = this.serviceInstance.getUri();
        String registerIp = this.msgHubSharedConfig.getIp();
        if (Util.isEmpty((CharSequence)registerIp)) {
            if (this.msgHubSharedConfig.isUseNacosIp()) {
                registerIp = uri.getHost();
            } else {
                InetAddress localAddress = NetUtil.getLocalAddress();
                registerIp = localAddress.getHostAddress();
            }
        }
        if (Util.isEmpty((CharSequence)registerIp)) {
            Util.log.error("cannot find right IP , exit JVM.");
            Runtime.getRuntime().exit(-1);
        }
        NodeManager.Node node = new NodeManager.Node();
        node.setId(this.serviceInstance.getServiceId() + ":" + NodeManager.UUID_STR);
        node.setNodeId(NodeManager.UUID_STR);
        node.setIp(registerIp);
        node.setPort(this.msgHubSharedConfig.isUseNacosIp() ? uri.getPort() : (this.msgHubSharedConfig.getPort() == 0 ? this.port : this.msgHubSharedConfig.getPort()));
        node.setType("control");
        node.setTime(LocalDateTime.now());
        return node;
    }
}

