/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.kernel.controller;

import com.alibaba.cloud.nacos.NacosServiceManager;
import com.alibaba.nacos.api.exception.NacosException;
import com.ovopark.kernel.shared.ShutdownManager;
import com.ovopark.messagehub.kernel.MsgHubSharedConfig;
import com.ovopark.module.shared.BaseResult;
import jakarta.annotation.Resource;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/k8s"})
public class K8HealthController
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(K8HealthController.class);
    @Autowired
    MsgHubSharedConfig msgHubSharedConfig;
    @Resource
    private NacosServiceManager nacosServiceManager;

    @RequestMapping(value={"/health"})
    public String test() {
        return BaseResult._module_static_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/shutdown"})
    public BaseResult<Boolean> shutdown(@RequestParam(value="token") String token) throws NacosException {
        if (StringUtils.isBlank((CharSequence)token)) {
            return BaseResult.success((Object)true);
        }
        if (!Objects.equals(token, this.msgHubSharedConfig.getShutdownToken())) {
            log.warn("cannot shutdown , maybe , a wrong token???: " + token);
            return BaseResult.success((Object)true);
        }
        ShutdownManager.getOrCreate().register2JVMHook();
        try {
            this.nacosServiceManager.nacosServiceShutDown();
        }
        catch (NacosException e) {
            BaseResult baseResult = BaseResult.success((Object)true);
            return baseResult;
        }
        finally {
            ShutdownManager.getOrCreate().shutdownAsync();
        }
        return BaseResult.success((Object)true);
    }

    public void run(String ... args) throws Exception {
        ShutdownManager.getOrCreate().register(K8HealthController.class.getName() + ":nacos-shutdown", () -> this.nacosServiceManager.nacosServiceShutDown(), Integer.MIN_VALUE);
    }
}

