/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.kernel.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ovopark.kernel.shared.Util;
import com.ovopark.messagehub.kernel.Cf;
import com.ovopark.messagehub.kernel.DefMsgCfService;
import com.ovopark.messagehub.kernel.GlobalCacheService;
import com.ovopark.messagehub.kernel.MsgGroup;
import com.ovopark.messagehub.kernel.MsgHubSharedConfig;
import com.ovopark.messagehub.kernel.MsgTypeConfig;
import com.ovopark.messagehub.kernel.MsgTypeConfigImpl;
import com.ovopark.messagehub.kernel.MsgTypeConfigNode;
import com.ovopark.messagehub.kernel.MsgTypeTemplate;
import com.ovopark.messagehub.kernel.MsgTypeTemplateImpl;
import com.ovopark.messagehub.kernel.UserMsgTypeConfigImpl;
import com.ovopark.messagehub.kernel.mapper.MessagePushTemplateMapper;
import com.ovopark.messagehub.kernel.mapper.MessageTypeEnterpriseConfigMapper;
import com.ovopark.messagehub.kernel.mapper.MessageTypeMapper;
import com.ovopark.messagehub.kernel.mapper.MessageTypeUserConfigMapper;
import com.ovopark.messagehub.kernel.mapper.MessageTypeUserGroupMapper;
import com.ovopark.messagehub.kernel.model.entity.MessagePushTemplate;
import com.ovopark.messagehub.kernel.model.entity.MessageType;
import com.ovopark.messagehub.kernel.model.entity.MessageTypeEnterpriseConfig;
import com.ovopark.messagehub.kernel.model.entity.MessageTypeUserConfig;
import com.ovopark.messagehub.kernel.model.entity.MessageTypeUserGroup;
import com.ovopark.messagehub.kernel.service.MsgConfigSharedService;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MsgConfigSharedServiceImpl
implements MsgConfigSharedService {
    @Autowired
    private MessageTypeMapper messageTypeMapper;
    @Autowired
    private MessageTypeEnterpriseConfigMapper enterpriseConfigMapper;
    @Autowired
    private MessageTypeUserConfigMapper userConfigMapper;
    @Autowired
    private MessageTypeUserGroupMapper messageTypeUserGroupMapper;
    @Autowired
    private MessagePushTemplateMapper messagePushTemplateMapper;
    @Autowired
    private MsgHubSharedConfig msgHubSharedConfig;
    @Autowired
    private DefMsgCfService defMsgCfService;

    @Override
    public MsgTypeConfig msgTypeConfig(String code) {
        return null;
    }

    @Override
    @Transactional
    public void syncMessageTypeFromXlsx(List<MessageType> messageTypeList) {
        messageTypeList.sort(Comparator.comparing(MessageType::getCode));
        for (MessageType messageType : messageTypeList) {
            MessageType type;
            if (Util.isEmpty((CharSequence)messageType.getName())) {
                messageType.setName(messageType.getCode());
            }
            if ((type = this.messageType(messageType.getCode())) == null) {
                if (!messageType.getCode().contains("_")) {
                    this.messageTypeMapper.insert(messageType);
                    continue;
                }
                String pc = messageType.getCode().substring(0, messageType.getCode().lastIndexOf("_"));
                MessageType parent = this.messageType(pc);
                if (parent == null) {
                    throw new IllegalArgumentException("parent is missing: " + pc);
                }
                messageType.setParentId(parent.getId());
                this.messageTypeMapper.insert(messageType);
                continue;
            }
            this.messageTypeMapper.updateById(type);
        }
    }

    private MessageType messageType(String code) {
        return (MessageType)this.messageTypeMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(MessageType::getCode, (Object)code));
    }

    @Override
    public List<MsgTypeConfigNode> sysConfig() {
        List list = (List)Util.globalTtl().putIfAbsentAndGet((Comparable)((Object)"tb_message_type:cache:0"), (Supplier)new Supplier<List<MessageType>>(){

            @Override
            public List<MessageType> get() {
                return MsgConfigSharedServiceImpl.this.messageTypeMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(MessageType::getDelFlag, (Object)0));
            }
        }, 15L, TimeUnit.SECONDS);
        List<MsgTypeConfigImpl> configList = list.stream().map(messageType -> {
            MsgTypeConfigImpl msgTypeConfig = new MsgTypeConfigImpl();
            msgTypeConfig.setMessageTypeId(messageType.getId());
            msgTypeConfig.setParentMessageTypeId(messageType.getParentId());
            msgTypeConfig.setCode(messageType.getCode());
            msgTypeConfig.setName(messageType.getName());
            Cf.copy(messageType, msgTypeConfig);
            return msgTypeConfig;
        }).toList();
        List nodeList = Util.constructTree(configList, MsgTypeConfigNode.class);
        return nodeList;
    }

    @Override
    public List<MsgTypeConfigNode> groupConfig(int group) {
        List enterpriseConfigList = this.enterpriseConfigMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(MessageTypeEnterpriseConfig.class).eq(MessageTypeEnterpriseConfig::getGroupId, (Object)group)).eq(MessageTypeEnterpriseConfig::getDelFlag, (Object)0));
        Map<Integer, MessageTypeEnterpriseConfig> map = enterpriseConfigList.stream().collect(Collectors.toMap(MessageTypeEnterpriseConfig::getMessageTypeId, v -> v));
        List<MsgTypeConfigNode> groupConfig = this.sysConfig();
        for (MsgTypeConfigNode msgTypeConfigNode : groupConfig) {
            Iterator iterator = msgTypeConfigNode.iterator();
            while (iterator.hasNext()) {
                MsgTypeConfigNode next = (MsgTypeConfigNode)((Object)iterator.next());
                this.doNode(next, map);
            }
        }
        return groupConfig;
    }

    private void doNode(MsgTypeConfigNode node, Map<Integer, ? extends Cf> groupConfig) {
        Integer id = (Integer)node.id();
        MsgTypeConfigImpl msgTypeConfig = (MsgTypeConfigImpl)node.nodeRef();
        Cf cf = groupConfig.get(id);
        if (cf != null) {
            MsgTypeConfigNode parent = (MsgTypeConfigNode)node.parent();
            Cf.setCf(msgTypeConfig, parent == null ? null : (Cf)parent.nodeRef(), cf);
        }
    }

    @Override
    public List<MsgTypeConfigNode> userConfig(int group, int user) {
        List userConfigList = this.userConfigMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(MessageTypeUserConfig.class).eq(MessageTypeUserConfig::getGroupId, (Object)group)).eq(MessageTypeUserConfig::getUserId, (Object)user)).eq(MessageTypeUserConfig::getDelFlag, (Object)0));
        Map<Integer, UserMsgTypeConfigImpl> map = userConfigList.stream().map(messageTypeUserConfig -> {
            UserMsgTypeConfigImpl userMsgTypeConfigImpl = new UserMsgTypeConfigImpl();
            Cf.setCf((Cf)userMsgTypeConfigImpl, messageTypeUserConfig.getReceiveMessageFlag());
            userMsgTypeConfigImpl.setWebMessageOpenFlag(messageTypeUserConfig.getWebMessageOpenFlag());
            userMsgTypeConfigImpl.setNoDisturbingFlag(messageTypeUserConfig.getNoDisturbingFlag());
            userMsgTypeConfigImpl.setReceiveMessageFlag(messageTypeUserConfig.getReceiveMessageFlag());
            userMsgTypeConfigImpl.setImportanceFlag(messageTypeUserConfig.getImportanceFlag());
            userMsgTypeConfigImpl.setTopFlag(messageTypeUserConfig.getTopFlag());
            userMsgTypeConfigImpl.setMessageTypeId(messageTypeUserConfig.getMessageTypeId());
            return userMsgTypeConfigImpl;
        }).collect(Collectors.toMap(MsgTypeConfigImpl::getMessageTypeId, v -> v));
        List<MsgTypeConfigNode> sysConfig = this.sysConfig();
        for (MsgTypeConfigNode msgTypeConfigNode : sysConfig) {
            Iterator iterator = msgTypeConfigNode.iterator();
            while (iterator.hasNext()) {
                MsgTypeConfigNode next = (MsgTypeConfigNode)((Object)iterator.next());
                this.doNode(next, map);
            }
        }
        for (MsgTypeConfigNode msgTypeConfigNode : sysConfig) {
            msgTypeConfigNode.walk(msgCf -> {
                MsgTypeConfigImpl msgTypeConfig = (MsgTypeConfigImpl)msgCf.nodeRef();
                UserMsgTypeConfigImpl userMsgTypeConfigImpl = new UserMsgTypeConfigImpl();
                userMsgTypeConfigImpl.setMessageTypeId(msgTypeConfig.getMessageTypeId());
                userMsgTypeConfigImpl.setParentMessageTypeId(msgTypeConfig.getParentMessageTypeId());
                userMsgTypeConfigImpl.setCode(msgTypeConfig.getCode());
                userMsgTypeConfigImpl.setName(msgTypeConfig.getName());
                Cf.setCf((Cf)userMsgTypeConfigImpl, 1);
                Cf.setCf((Cf)userMsgTypeConfigImpl, msgTypeConfig);
                UserMsgTypeConfigImpl config = (UserMsgTypeConfigImpl)map.get(msgTypeConfig.getMessageTypeId());
                if (config != null) {
                    userMsgTypeConfigImpl.setNoDisturbingFlag(config.getNoDisturbingFlag());
                    userMsgTypeConfigImpl.setWebMessageOpenFlag(config.getWebMessageOpenFlag());
                    userMsgTypeConfigImpl.setReceiveMessageFlag(config.getReceiveMessageFlag());
                    userMsgTypeConfigImpl.setImportanceFlag(config.getImportanceFlag());
                    userMsgTypeConfigImpl.setTopFlag(config.getTopFlag());
                }
                msgCf.nodeRef(userMsgTypeConfigImpl);
            });
        }
        return sysConfig;
    }

    private List<MessageType> find(String ... msgCode) {
        List<String> list = List.of(msgCode);
        ArrayList all = new ArrayList();
        List<MsgTypeConfigNode> sysConfig = this.sysConfig();
        for (MsgTypeConfigNode msgTypeConfigNode : sysConfig) {
            MsgTypeConfigNode node = (MsgTypeConfigNode)msgTypeConfigNode.get(msgTypeConfigNode1 -> list.contains(((MsgTypeConfigImpl)msgTypeConfigNode1.nodeRef()).getCode()));
            if (node == null) continue;
            node.walk(msgTypeConfigNode12 -> all.add(((MsgTypeConfigImpl)msgTypeConfigNode12.nodeRef()).getCode()));
        }
        if (Util.isEmpty(all)) {
            return new ArrayList<MessageType>();
        }
        List typeList = this.messageTypeMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(MessageType.class).in(MessageType::getCode, all)).eq(MessageType::getDelFlag, (Object)0));
        return typeList;
    }

    @Override
    public List<MsgGroup> msgGroup() {
        return GlobalCacheService.getOrCreate().threadCache().putIfAbsentAndGet("msgGroup()", new Supplier<List<MsgGroup>>(){

            @Override
            public List<MsgGroup> get() {
                return MsgConfigSharedServiceImpl.this.msgGroup0();
            }
        }, this.msgHubSharedConfig.getMsgGroupExpiredSec(), TimeUnit.SECONDS);
    }

    public List<MsgGroup> msgGroup0() {
        ArrayList<MsgGroup> msgGroupList = new ArrayList<MsgGroup>();
        List messageTypeUserGroups = this.messageTypeUserGroupMapper.selectList((Wrapper)new LambdaQueryWrapper(MessageTypeUserGroup.class));
        final HashSet codeList = new HashSet();
        List<MsgTypeConfigNode> sysConfig = this.sysConfig();
        for (MsgTypeConfigNode node : sysConfig) {
            node.walk(new Consumer<MsgTypeConfigNode>(){

                @Override
                public void accept(MsgTypeConfigNode msgTypeConfigNode) {
                    if (msgTypeConfigNode.level() == 1) {
                        codeList.add(((MsgTypeConfigImpl)msgTypeConfigNode.nodeRef()).getCode());
                    }
                }
            });
        }
        MessageTypeUserGroup allMessageTypeUserGroup = new MessageTypeUserGroup();
        allMessageTypeUserGroup.setName("ALL");
        allMessageTypeUserGroup.setCode("ALL");
        allMessageTypeUserGroup.setMsgCodes(String.join((CharSequence)",", codeList));
        messageTypeUserGroups.add(allMessageTypeUserGroup);
        for (MessageTypeUserGroup typeUserGroup : messageTypeUserGroups) {
            MsgGroup msgGroup = new MsgGroup();
            msgGroup.setCode(typeUserGroup.getCode());
            msgGroup.setName(typeUserGroup.getName());
            msgGroup.setMessageTypeList(new ArrayList<MessageType>());
            ArrayList<MsgGroup> childList = new ArrayList<MsgGroup>();
            msgGroup.setChildList(childList);
            String msgCodes = typeUserGroup.getMsgCodes();
            for (String c : List.of(msgCodes.split(","))) {
                if (Util.isEmpty((CharSequence)c)) continue;
                List<MessageType> messageTypeList = this.find(c);
                MessageType msgType = messageTypeList.stream().filter(messageType -> messageType.getCode().equals(c)).findFirst().orElse(null);
                if (msgType == null) continue;
                MsgGroup mg = new MsgGroup();
                mg.setCode(c);
                mg.setName(msgType.getName());
                mg.setMessageTypeId(msgType.getId());
                mg.setMessageTypeList(messageTypeList);
                childList.add(mg);
                msgGroup.getMessageTypeList().addAll(messageTypeList);
            }
            msgGroupList.add(msgGroup);
        }
        return msgGroupList;
    }

    @Override
    public MsgTypeTemplate localTemplate(String code) {
        MessageType messageType = this.messageType(code);
        return MsgConfigSharedServiceImpl.msgTypeTemplate(messageType);
    }

    private static MsgTypeTemplateImpl msgTypeTemplate(MessageType messageType) {
        MsgTypeTemplateImpl msgTypeTemplate = new MsgTypeTemplateImpl();
        msgTypeTemplate.setTemplateEngine(messageType.getTemplateEngine());
        String ruleId = messageType.getRuleId();
        if (Util.isEmpty((CharSequence)ruleId)) {
            ruleId = messageType.getCode();
        }
        msgTypeTemplate.setCode(ruleId);
        msgTypeTemplate.setTitleTemplateCn(messageType.getTitleTemplateCn());
        msgTypeTemplate.setTitleTemplateTw(messageType.getTitleTemplateTw());
        msgTypeTemplate.setTitleTemplateEn(messageType.getTitleTemplateEn());
        msgTypeTemplate.setTitleTemplateIndonesia(messageType.getTitleTemplateIndonesia());
        msgTypeTemplate.setContentTemplateCn(messageType.getContentTemplateCn());
        msgTypeTemplate.setContentTemplateTw(messageType.getContentTemplateTw());
        msgTypeTemplate.setContentTemplateEn(messageType.getContentTemplateEn());
        msgTypeTemplate.setContentTemplateIndonesia(messageType.getContentTemplateIndonesia());
        return msgTypeTemplate;
    }

    @Override
    public List<MsgTypeTemplate> localTemplateList() {
        List list = this.messageTypeMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(MessageType::getDelFlag, (Object)0));
        List<MsgTypeTemplate> templateList = list.stream().map(MsgConfigSharedServiceImpl::msgTypeTemplate).collect(Collectors.toList());
        return templateList;
    }

    @Override
    public List<MsgTypeTemplate> pushTemplate(String code) {
        List<MessagePushTemplate> list = this.messagePushTemplateMapper.getByCode(code);
        List<MsgTypeTemplate> result = list.stream().map(MsgConfigSharedServiceImpl::msgTypeTemplate).collect(Collectors.toList());
        return result;
    }

    @Override
    public List<MsgTypeTemplate> pushTemplateList() {
        List<MessagePushTemplate> list = this.messagePushTemplateMapper.getByCode(null);
        List<MsgTypeTemplate> result = list.stream().map(MsgConfigSharedServiceImpl::msgTypeTemplate).collect(Collectors.toList());
        return result;
    }

    private static MsgTypeTemplateImpl msgTypeTemplate(MessagePushTemplate messagePushTemplate) {
        MsgTypeTemplateImpl msgTypeTemplate = new MsgTypeTemplateImpl();
        msgTypeTemplate.setTemplateEngine(messagePushTemplate.getTemplateEngine());
        msgTypeTemplate.setCode(messagePushTemplate.getThirdTemplateCode());
        msgTypeTemplate.setType(messagePushTemplate.getType());
        msgTypeTemplate.setTitleTemplateCn(messagePushTemplate.getTitleTemplateCn());
        msgTypeTemplate.setTitleTemplateTw(messagePushTemplate.getTitleTemplateTw());
        msgTypeTemplate.setTitleTemplateEn(messagePushTemplate.getTitleTemplateEn());
        msgTypeTemplate.setTitleTemplateIndonesia(messagePushTemplate.getTitleTemplateIndonesia());
        msgTypeTemplate.setContentTemplateCn(messagePushTemplate.getContentTemplateCn());
        msgTypeTemplate.setContentTemplateTw(messagePushTemplate.getContentTemplateTw());
        msgTypeTemplate.setContentTemplateEn(messagePushTemplate.getContentTemplateEn());
        msgTypeTemplate.setContentTemplateIndonesia(messagePushTemplate.getContentTemplateIndonesia());
        return msgTypeTemplate;
    }

    @Override
    public MsgTypeTemplate pushTemplate(String code, int type) {
        MessagePushTemplate pushTemplate = this.messagePushTemplateMapper.getByCodeAndType(code, type);
        return MsgConfigSharedServiceImpl.msgTypeTemplate(pushTemplate);
    }
}

