/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.kernel;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.ovopark.kernel.shared.Util;
import com.ovopark.messagehub.kernel.DefMsgCfService;
import com.ovopark.messagehub.kernel.MsgCfService;
import com.ovopark.messagehub.kernel.MsgTypeConfig;
import com.ovopark.messagehub.kernel.MsgTypeConfigImpl;
import com.ovopark.messagehub.kernel.MsgTypeConfigNode;
import com.ovopark.messagehub.kernel.SimpleMsgCfService;
import com.ovopark.messagehub.kernel.UserMsgTypeConfig;
import com.ovopark.messagehub.kernel.mapper.MessageTypeEnterpriseConfigMapper;
import com.ovopark.messagehub.kernel.model.entity.MessageTypeEnterpriseConfig;
import com.ovopark.messagehub.kernel.service.MsgConfigSharedService;
import jakarta.annotation.PostConstruct;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;

@Primary
@Component
public class CompositeMsgCfService
implements MsgCfService {
    private static final Logger log = LoggerFactory.getLogger(CompositeMsgCfService.class);
    @Autowired
    private SimpleMsgCfService simpleMsgCfService;
    @Autowired
    private DefMsgCfService defMsgCfService;
    @Autowired
    private MsgConfigSharedService msgConfigSharedService;
    @Autowired
    private MessageTypeEnterpriseConfigMapper enterpriseConfigMapper;
    private static final Map<Integer, GroupCf> groupCfMap = new ConcurrentHashMap<Integer, GroupCf>();
    static final ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1, Util.newThreadFactory((String)"group-cfg-load"));

    @Override
    public UserMsgTypeConfig cfOnSelf(Integer groupId, Integer userId, String code) {
        return this.simpleMsgCfService.cfOnSelf(groupId, userId, code);
    }

    @Override
    public UserMsgTypeConfig cfOnLink(Integer groupId, Integer userId, String code) {
        UserMsgTypeConfig userMsgTypeConfig = this.cfOnSelf(groupId, userId, code);
        MsgTypeConfig msgTypeConfig = null;
        GroupCf groupCf = groupCfMap.get(groupId);
        if (groupCf != null) {
            msgTypeConfig = groupCf.msgTypeConfigMap.get(code);
        }
        UserMsgTypeConfigLink userMsgTypeConfigLink = new UserMsgTypeConfigLink(this, userMsgTypeConfig, msgTypeConfig, this.defMsgCfService.cfg(code));
        return userMsgTypeConfigLink;
    }

    @PostConstruct
    private void post() {
        Util.schedule((ScheduledExecutorService)scheduledExecutorService, this::refresh, (long)60L, (TimeUnit)TimeUnit.SECONDS, e -> {
            log.error(e.getMessage(), e);
            return true;
        }, () -> true);
    }

    void refresh() {
        List enterpriseConfigList = this.enterpriseConfigMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(MessageTypeEnterpriseConfig.class).groupBy(MessageTypeEnterpriseConfig::getGroupId)).select(new SFunction[]{MessageTypeEnterpriseConfig::getGroupId}));
        for (final MessageTypeEnterpriseConfig enterpriseConfig : enterpriseConfigList) {
            List<MsgTypeConfigNode> msgTypeConfigNodeList = this.msgConfigSharedService.groupConfig(enterpriseConfig.getGroupId());
            for (MsgTypeConfigNode msgTypeConfigNode : msgTypeConfigNodeList) {
                msgTypeConfigNode.walk(new Consumer<MsgTypeConfigNode>(){

                    @Override
                    public void accept(MsgTypeConfigNode msgTypeConfigNode) {
                        GroupCf groupCf = groupCfMap.computeIfAbsent(enterpriseConfig.getGroupId(), integer -> new GroupCf());
                        groupCf.msgTypeConfigMap.put(((MsgTypeConfigImpl)msgTypeConfigNode.nodeRef()).code(), (MsgTypeConfig)msgTypeConfigNode.nodeRef());
                    }
                });
            }
        }
    }

    private static class GroupCf {
        private final Map<String, MsgTypeConfig> msgTypeConfigMap = new ConcurrentHashMap<String, MsgTypeConfig>();

        private GroupCf() {
        }
    }

    private class UserMsgTypeConfigLink
    implements UserMsgTypeConfig {
        private final UserMsgTypeConfig userMsgTypeConfig;
        private final MsgTypeConfig groupCfg;
        private final DefMsgCfService.DefMsgCf defMsgCf;

        public UserMsgTypeConfigLink(CompositeMsgCfService compositeMsgCfService, UserMsgTypeConfig userMsgTypeConfig, MsgTypeConfig groupCfg, DefMsgCfService.DefMsgCf defMsgCf) {
            this.userMsgTypeConfig = userMsgTypeConfig;
            this.groupCfg = groupCfg;
            this.defMsgCf = defMsgCf;
        }

        @Override
        public boolean jg() {
            if (this.defMsgCf.getUseJg() == -1 && this.defMsgCf.getAppSysNotify() == -1) {
                return false;
            }
            return Util.compare2((Comparable)Integer.valueOf(this.userMsgTypeConfig.receiveMessageFlag()), (Comparable)Integer.valueOf(1)) == 0 && Util.compare2((Comparable)Integer.valueOf(this.userMsgTypeConfig.noDisturbingFlag()), (Comparable)Integer.valueOf(0)) == 0 && (this.groupCfg == null && this.defMsgCf.getUseJg() == 1 && this.defMsgCf.getAppSysNotify() == 1 || this.groupCfg != null && this.groupCfg.jg());
        }

        @Override
        public boolean mail() {
            if (this.defMsgCf.getUseMail() == -1) {
                return false;
            }
            return Util.compare2((Comparable)Integer.valueOf(this.userMsgTypeConfig.receiveMessageFlag()), (Comparable)Integer.valueOf(1)) == 0 && (this.groupCfg == null && this.defMsgCf.getUseMail() == 1 || this.groupCfg != null && this.groupCfg.mail());
        }

        @Override
        public boolean qw() {
            if (this.defMsgCf.getUseQiWei() == -1) {
                return false;
            }
            return Util.compare2((Comparable)Integer.valueOf(this.userMsgTypeConfig.receiveMessageFlag()), (Comparable)Integer.valueOf(1)) == 0 && (this.groupCfg == null && this.defMsgCf.getUseQiWei() == 1 || this.groupCfg != null && this.groupCfg.qw());
        }

        @Override
        public boolean sms() {
            if (this.defMsgCf.getUseSms() == -1) {
                return false;
            }
            return Util.compare2((Comparable)Integer.valueOf(this.userMsgTypeConfig.receiveMessageFlag()), (Comparable)Integer.valueOf(1)) == 0 && (this.groupCfg == null && this.defMsgCf.getUseSms() == 1 || this.groupCfg != null && this.groupCfg.sms());
        }

        @Override
        public boolean gzh() {
            return Util.compare2((Comparable)Integer.valueOf(this.userMsgTypeConfig.receiveMessageFlag()), (Comparable)Integer.valueOf(1)) == 0 && (this.groupCfg == null || this.groupCfg.gzh());
        }

        @Override
        public boolean wbs() {
            return this.userMsgTypeConfig.wbs() && (this.groupCfg == null || this.groupCfg.wbs());
        }

        @Override
        public boolean dd() {
            if (this.defMsgCf.getUseDingDing() == -1) {
                return false;
            }
            return Util.compare2((Comparable)Integer.valueOf(this.userMsgTypeConfig.receiveMessageFlag()), (Comparable)Integer.valueOf(1)) == 0 && (this.groupCfg == null && this.defMsgCf.getUseDingDing() == 1 || this.groupCfg != null && this.groupCfg.dd());
        }

        @Override
        public boolean fs() {
            if (this.defMsgCf.getUseFeiShu() == -1) {
                return false;
            }
            return Util.compare2((Comparable)Integer.valueOf(this.userMsgTypeConfig.receiveMessageFlag()), (Comparable)Integer.valueOf(1)) == 0 && (this.groupCfg == null && this.defMsgCf.getUseFeiShu() == 1 || this.groupCfg != null && this.groupCfg.fs());
        }

        @Override
        public boolean third() {
            if (this.defMsgCf.getThird() == -1) {
                return false;
            }
            return Util.compare2((Comparable)Integer.valueOf(this.userMsgTypeConfig.receiveMessageFlag()), (Comparable)Integer.valueOf(1)) == 0 && (this.groupCfg == null && this.defMsgCf.getThird() == 1 || this.groupCfg != null && this.groupCfg.third());
        }

        @Override
        public boolean pop() {
            if (this.defMsgCf.getPop() == -1) {
                return false;
            }
            return Util.compare2((Comparable)Integer.valueOf(this.userMsgTypeConfig.receiveMessageFlag()), (Comparable)Integer.valueOf(1)) == 0 && (this.groupCfg == null && this.defMsgCf.getPop() == 1 || this.groupCfg != null && this.groupCfg.pop());
        }

        @Override
        public boolean appSysNotify() {
            if (this.defMsgCf.getAppSysNotify() == -1) {
                return false;
            }
            return Util.compare2((Comparable)Integer.valueOf(this.userMsgTypeConfig.receiveMessageFlag()), (Comparable)Integer.valueOf(1)) == 0 && Util.compare2((Comparable)Integer.valueOf(this.userMsgTypeConfig.noDisturbingFlag()), (Comparable)Integer.valueOf(0)) == 0 && (this.groupCfg == null && this.defMsgCf.getAppSysNotify() == 1 || this.groupCfg != null && this.groupCfg.appSysNotify());
        }

        @Override
        public int frequencyTimeSec() {
            return 0;
        }

        @Override
        public boolean mc() {
            return UserMsgTypeConfig.super.mc();
        }

        @Override
        public boolean floatWindow() {
            return this.userMsgTypeConfig.floatWindow();
        }

        @Override
        public boolean topWindow() {
            return UserMsgTypeConfig.super.topWindow();
        }

        @Override
        public String code() {
            return this.defMsgCf.getCode();
        }

        @Override
        public String name() {
            return this.defMsgCf.getName();
        }

        @Override
        public int webMessageOpenFlag() {
            return this.userMsgTypeConfig.webMessageOpenFlag();
        }

        @Override
        public int noDisturbingFlag() {
            return this.userMsgTypeConfig.noDisturbingFlag();
        }

        @Override
        public int receiveMessageFlag() {
            return this.userMsgTypeConfig.receiveMessageFlag();
        }

        @Override
        public int importanceFlag() {
            return this.userMsgTypeConfig.importanceFlag();
        }

        @Override
        public int getUseMail() {
            return this.defMsgCf.getUseMail();
        }

        @Override
        public int getUseSms() {
            return this.defMsgCf.getUseSms();
        }

        @Override
        public int getUseWeiXin() {
            return this.defMsgCf.getUseWeiXin();
        }

        @Override
        public int getUseQiWei() {
            return this.defMsgCf.getUseQiWei();
        }

        @Override
        public int getUseDingDing() {
            return this.defMsgCf.getUseDingDing();
        }

        @Override
        public int getUseJg() {
            return this.defMsgCf.getUseJg();
        }

        @Override
        public int getUseWebSocket() {
            return this.defMsgCf.getUseWebSocket();
        }

        @Override
        public int getUseFeiShu() {
            return this.defMsgCf.getUseFeiShu();
        }

        @Override
        public int getAppSysNotify() {
            return this.defMsgCf.getAppSysNotify();
        }

        @Override
        public int getPop() {
            return this.defMsgCf.getPop();
        }

        @Override
        public int getPushFrequencyTime() {
            return this.defMsgCf.getPushFrequencyTime();
        }

        @Override
        public int getFloatWindow() {
            return this.defMsgCf.getFloatWindow();
        }

        @Override
        public int getTopWindow() {
            return this.defMsgCf.getTopWindow();
        }

        @Override
        public void setUseMail(int useMail) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setUseSms(int useSms) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setUseWeiXin(int useWeiXin) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setUseQiWei(int useQiWei) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setUseDingDing(int useDingDing) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setUseJg(int useJg) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setUseWebSocket(int useWebSocket) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setUseFeiShu(int useFeiShu) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setAppSysNotify(int appSysNotify) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPop(int pop) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPushFrequencyTime(int pushFrequencyTime) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setFloatWindow(int floatWindow) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setTopWindow(int topWindow) {
            throw new UnsupportedOperationException();
        }
    }
}

