/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.kernel;

import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import com.ovopark.messagehub.kernel.DefMsgCfService;
import com.ovopark.messagehub.kernel.MessageFsyncService;
import com.ovopark.messagehub.kernel.MessageQuery;
import com.ovopark.messagehub.kernel.MsgHubSharedConfig;
import com.ovopark.messagehub.kernel.MsgTypeStat;
import com.ovopark.messagehub.kernel.MsgTypeTopN;
import com.ovopark.messagehub.kernel.UserMessageElasticsearchManager;
import com.ovopark.messagehub.kernel.UserMsgPositionService;
import com.ovopark.messagehub.kernel.model.es.MessageTask;
import com.ovopark.messagehub.kernel.model.es.UserMessage;
import com.ovopark.messagehub.kernel.model.es.UserMsgPosition;
import com.ovopark.module.shared.PageModel;
import com.ovopark.module.shared.es7x.Document;
import com.ovopark.module.shared.es7x.ElasticsearchOperations;
import jakarta.annotation.Resource;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.core.CountRequest;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.filter.FilterAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.filter.ParsedFilter;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedStringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.ParsedTopHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MessageFsyncESService
implements MessageFsyncService {
    private static final Logger log = LoggerFactory.getLogger(MessageFsyncESService.class);
    @Autowired
    private RestHighLevelClient elasticsearchClient;
    @Resource(name="ES_JSONAccessor")
    private JSONAccessor jsonAccessor;
    @Autowired
    private ElasticsearchOperations elasticsearchOperations;
    @Autowired
    private MsgHubSharedConfig msgHubSharedConfig;
    @Autowired
    private DefMsgCfService defMsgCfService;
    @Autowired
    private UserMsgPositionService userMsgPositionService;

    @Override
    public void save(MessageTask messageTask) {
        this.elasticsearchOperations.save(MessageTask.INDEX, (Document)messageTask);
    }

    @Override
    public MessageTask getTask(String taskId) {
        MessageTask messageTask = (MessageTask)this.elasticsearchOperations.get(MessageTask.INDEX, taskId, MessageTask.class);
        return messageTask;
    }

    @Override
    public UserMsgPosition position(int userId) {
        UserMsgPosition userMsgPosition = (UserMsgPosition)this.elasticsearchOperations.get(UserMsgPosition.INDEX, String.valueOf(userId), UserMsgPosition.class);
        return userMsgPosition;
    }

    @Override
    public MessageTask getTaskByTraceId(String msgTraceId) {
        SearchRequest searchRequest = new SearchRequest(new String[]{MessageTask.INDEX});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"msgTraceId", (String)msgTraceId));
        searchSourceBuilder.size(1);
        searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = this.elasticsearchOperations.search(searchRequest);
        SearchHits hits = searchResponse.getHits();
        Iterator iterator = hits.iterator();
        if (iterator.hasNext()) {
            SearchHit hit = (SearchHit)iterator.next();
            String source = hit.getSourceAsString();
            MessageTask read = (MessageTask)this.jsonAccessor.read(source, MessageTask.class);
            read.setId(hit.getId());
            return read;
        }
        return null;
    }

    @Override
    public ElasticsearchOperations.BulkUpdateResponse updatePartOfIndex(final List<String> ids, final Consumer<BoolQueryBuilder> boolQueryBuilderConsumer, Supplier<Script> scriptSupplier, String ... alias) {
        if (Util.isEmpty(ids)) {
            return new ElasticsearchOperations.BulkUpdateResponse();
        }
        return this.elasticsearchOperations.updatePartOfDocInMultiIndex((Supplier)new Supplier<BoolQueryBuilder>(){

            @Override
            public BoolQueryBuilder get() {
                BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
                boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termsQuery((String)"_id", (Collection)ids));
                boolQueryBuilderConsumer.accept(boolQueryBuilder);
                return boolQueryBuilder;
            }
        }, scriptSupplier, alias);
    }

    @Override
    public void save(UserMessage userMessage) {
        if (Util.isNotEmpty((CharSequence)userMessage.getId())) {
            throw new RuntimeException("id must be empty.");
        }
        if (userMessage.getCreateAt() == null) {
            userMessage.setCreateAt(LocalDateTime.now());
        }
        if (userMessage.getModifyAt() == null) {
            userMessage.setModifyAt(LocalDateTime.now());
        }
        this.elasticsearchOperations.save(UserMessage.INDEX_WRITE, (Document)userMessage);
    }

    @Override
    public UserMessage getInMultiIndex(String msgId) {
        UserMessage userMessage = (UserMessage)this.elasticsearchOperations.getInMultiIndex(msgId, UserMessage.class, new String[]{UserMessage.INDEX_READ});
        return userMessage;
    }

    @Override
    public void updatePartOfDoc(String msgId, Supplier<Script> scriptSupplier, String ... alias) {
        this.elasticsearchOperations.updatePartOfDocInMultiIndex(msgId, scriptSupplier, alias);
    }

    @Override
    public void updatePartOfDoc(String index, String msgId, Supplier<Script> scriptSupplier) {
        this.elasticsearchOperations.updatePartOfDoc(index, msgId, scriptSupplier);
    }

    @Override
    public ElasticsearchOperations.BulkUpdateResponse updatePartOfDoc(final Integer userId, final Consumer<BoolQueryBuilder> boolQueryBuilderConsumer, Supplier<Script> scriptSupplier, String ... alias) {
        Objects.requireNonNull(userId);
        return this.elasticsearchOperations.updatePartOfDocInMultiIndex((Supplier)new Supplier<BoolQueryBuilder>(){

            @Override
            public BoolQueryBuilder get() {
                BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
                boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"userId", (Object)userId));
                boolQueryBuilderConsumer.accept(boolQueryBuilder);
                return boolQueryBuilder;
            }
        }, scriptSupplier, new String[]{UserMessage.INDEX_WRITE});
    }

    @Override
    public ElasticsearchOperations.BulkUpdateResponse updatePartOfDoc(List<String> ids, Supplier<Script> scriptSupplier) {
        if (Util.isEmpty(ids)) {
            return new ElasticsearchOperations.BulkUpdateResponse();
        }
        return this.elasticsearchOperations.updatePartOfDocInMultiIndex(ids, scriptSupplier, new String[]{UserMessage.INDEX_WRITE});
    }

    @Override
    public List<UserMessage> getMsgByMail(String taskId, List<String> mail) {
        SearchRequest searchRequest = new SearchRequest(new String[]{UserMessage.INDEX_READ});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"taskId", (String)taskId));
        boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termsQuery((String)"mailAddress.keyword", mail));
        MessageFsyncESService.boolQueryFilter(boolQueryBuilder).notDeleted().notHidden().dateLimit(LocalDateTime.now().minusDays(this.msgHubSharedConfig.getSearchableDays()), null);
        searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
        searchRequest.source(searchSourceBuilder);
        return this.elasticsearchOperations.list(searchRequest, UserMessage.class);
    }

    @Override
    public List<UserMessage> getMsgByUserId(String taskId, List<Integer> userId) {
        SearchRequest searchRequest = new SearchRequest(new String[]{UserMessage.INDEX_READ});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"taskId", (String)taskId));
        boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termsQuery((String)"userId", userId));
        MessageFsyncESService.boolQueryFilter(boolQueryBuilder).notDeleted().notHidden().dateLimit(LocalDateTime.now().minusDays(this.msgHubSharedConfig.getSearchableDays()), null);
        searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
        searchRequest.source(searchSourceBuilder);
        return this.elasticsearchOperations.list(searchRequest, UserMessage.class);
    }

    @Override
    public List<UserMessage> query(MessageQuery messageQuery) {
        messageQuery.setPageNumber(-1L);
        SearchRequest searchRequest = this.searchRequest(messageQuery);
        return this.elasticsearchOperations.list(searchRequest, UserMessage.class);
    }

    private SearchRequest searchRequest(MessageQuery messageQuery) {
        List<String> searchableIndex = UserMessageElasticsearchManager.getOrCreate().searchableIndex();
        log.info("construct searchRequest, from index: " + JSONAccessor.impl().format(searchableIndex));
        SearchRequest searchRequest = new SearchRequest(searchableIndex.toArray(new String[0]));
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        Objects.requireNonNull(messageQuery.getUserId());
        Objects.requireNonNull(messageQuery.getGroupId());
        boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"userId", (Object)messageQuery.getUserId()));
        boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"groupId", (Object)messageQuery.getGroupId()));
        BoolQueryFilter boolQueryFilter = MessageFsyncESService.boolQueryFilter(boolQueryBuilder).notDeleted().dateLimit(LocalDateTime.now().minusDays(this.msgHubSharedConfig.getSearchableDays()), LocalDateTime.now());
        if (!messageQuery.isIncludeHidden()) {
            boolQueryFilter.notHidden();
        }
        if (Util.isNotEmpty((CharSequence)messageQuery.getTaskId())) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"taskId", (String)messageQuery.getTaskId()));
        }
        if (messageQuery.getReadFlag() != null) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"readFlag", (Object)messageQuery.getReadFlag()));
        }
        if (messageQuery.getPopOnOff() != null) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"popOnOff", (Object)messageQuery.getPopOnOff()));
        }
        if (messageQuery.getTopOnOff() != null) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"topOnOff", (Object)messageQuery.getTopOnOff()));
        }
        if (messageQuery.getFloatOnOff() != null) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"floatOnOff", (Object)messageQuery.getFloatOnOff()));
        }
        if (Util.isNotEmpty(messageQuery.getMsgCodeList()) && !messageQuery.isQueryAllMsgFlag()) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termsQuery((String)"msgTypeCode", messageQuery.getMsgCodeList()));
        }
        if (this.msgHubSharedConfig.isUsePositionFilter()) {
            ArrayList<String> excludeMsgTypeCodeList = new ArrayList<String>();
            BoolQueryBuilder unreadShouldBQB = QueryBuilders.boolQuery();
            List unreadShould = unreadShouldBQB.should();
            LocalDateTime now = LocalDateTime.now();
            LocalDateTime midnight = now.toLocalDate().atStartOfDay();
            long midMilli = midnight.toInstant(Util.GMT_08).toEpochMilli();
            for (UserMsgPosition.Position position : this.userMsgPositionService.position(messageQuery.getUserId(), this.defMsgCfService.allMsgTypeCode())) {
                long l = Math.max(messageQuery.getReadFlag() != null ? position.getReadPositionMs() : 0L, position.getDeletePositionMs());
                if (l <= midMilli) continue;
                BoolQueryBuilder mustBQB = QueryBuilders.boolQuery();
                List must = mustBQB.must();
                must.add(QueryBuilders.termQuery((String)"msgTypeCode", (String)position.getCode()));
                must.add(QueryBuilders.rangeQuery((String)"createAt").gt((Object)l));
                unreadShould.add(mustBQB);
                excludeMsgTypeCodeList.add(position.getCode());
            }
            if (Util.isNotEmpty(excludeMsgTypeCodeList)) {
                BoolQueryBuilder excludeBoolQueryBuilder = QueryBuilders.boolQuery();
                excludeBoolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"msgTypeCode", excludeMsgTypeCodeList));
                unreadShould.add(excludeBoolQueryBuilder);
            }
            boolQueryBuilder.filter((QueryBuilder)unreadShouldBQB);
        }
        searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
        long pageNumber = messageQuery.getPageNumber();
        int pageSize = messageQuery.getPageSize();
        if (pageSize > this.msgHubSharedConfig.getMaxPageSize()) {
            throw new IllegalArgumentException("exceed max page size: " + pageSize + " > " + this.msgHubSharedConfig.getMaxPageSize());
        }
        searchSourceBuilder.size(pageSize);
        if (pageNumber >= 0L) {
            int from = (int)(pageNumber * (long)pageSize);
            int maxFrom = this.msgHubSharedConfig.getMaxFrom();
            if (from > maxFrom) {
                throw new IllegalArgumentException("exceed max from: " + from + " > " + maxFrom);
            }
            searchSourceBuilder.from(from);
        }
        searchRequest.source(searchSourceBuilder);
        return searchRequest;
    }

    public static BoolQueryFilter boolQueryFilter(BoolQueryBuilder boolQueryBuilder) {
        return new BoolQueryFilter(boolQueryBuilder);
    }

    @Override
    public PageModel<UserMessage> page(MessageQuery messageQuery) {
        SearchRequest searchRequest = this.searchRequest(messageQuery);
        searchRequest.source().sort("createAt", SortOrder.DESC);
        return this.elasticsearchOperations.page(searchRequest, UserMessage.class);
    }

    @Override
    public List<MsgTypeTopN> msgCodeGroupView(MessageQuery messageQuery, int docSize) {
        if (messageQuery.isScanUnread()) {
            return this.unreadWithUnreadCount(messageQuery, docSize);
        }
        return this.allWithUnreadCount(messageQuery, docSize);
    }

    private List<MsgTypeTopN> allWithUnreadCount(MessageQuery messageQuery, int docSize) {
        List<String> codeFilterList;
        ArrayList<MsgTypeTopN> msgTypeTopNList = new ArrayList<MsgTypeTopN>();
        List<String> searchableIndex = UserMessageElasticsearchManager.getOrCreate().searchableIndex();
        log.info("construct allWithUnreadCount, from index: " + JSONAccessor.impl().format(searchableIndex));
        SearchRequest searchRequest = new SearchRequest(searchableIndex.toArray(new String[0]));
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        Objects.requireNonNull(messageQuery.getUserId());
        Objects.requireNonNull(messageQuery.getGroupId());
        boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"userId", (Object)messageQuery.getUserId()));
        boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"groupId", (Object)messageQuery.getGroupId()));
        if (Util.isNotEmpty(messageQuery.getMsgCodeList())) {
            if (!messageQuery.isQueryAllMsgFlag()) {
                boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termsQuery((String)"msgTypeCode", messageQuery.getMsgCodeList()));
            }
            codeFilterList = messageQuery.getMsgCodeList();
        } else {
            codeFilterList = this.defMsgCfService.allMsgTypeCode();
        }
        List<UserMsgPosition.Position> positionList = null;
        if (this.msgHubSharedConfig.isUsePositionFilter()) {
            ArrayList<String> excludeMsgTypeCodeList = new ArrayList<String>();
            positionList = this.userMsgPositionService.position(messageQuery.getUserId(), codeFilterList);
            BoolQueryBuilder deleteShouldBQB = QueryBuilders.boolQuery();
            List deleteShould = deleteShouldBQB.should();
            LocalDateTime now = LocalDateTime.now();
            LocalDateTime midnight = now.toLocalDate().atStartOfDay();
            long midMilli = midnight.toInstant(Util.GMT_08).toEpochMilli();
            for (UserMsgPosition.Position position : positionList) {
                long l = position.getDeletePositionMs();
                if (l <= midMilli) continue;
                BoolQueryBuilder mustBQB = QueryBuilders.boolQuery();
                List must = mustBQB.must();
                must.add(QueryBuilders.termQuery((String)"msgTypeCode", (String)position.getCode()));
                must.add(QueryBuilders.rangeQuery((String)"createAt").gt((Object)l));
                deleteShould.add(mustBQB);
                excludeMsgTypeCodeList.add(position.getCode());
            }
            if (Util.isNotEmpty(excludeMsgTypeCodeList)) {
                BoolQueryBuilder excludeBoolQueryBuilder = QueryBuilders.boolQuery();
                excludeBoolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"msgTypeCode", excludeMsgTypeCodeList));
                deleteShould.add(excludeBoolQueryBuilder);
            }
            boolQueryBuilder.filter((QueryBuilder)deleteShouldBQB);
        }
        if (messageQuery.getPopOnOff() != null) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"popOnOff", (Object)messageQuery.getPopOnOff()));
        }
        if (messageQuery.getTopOnOff() != null) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"topOnOff", (Object)messageQuery.getTopOnOff()));
        }
        if (messageQuery.getFloatOnOff() != null) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"floatOnOff", (Object)messageQuery.getFloatOnOff()));
        }
        MessageFsyncESService.boolQueryFilter(boolQueryBuilder).notDeleted().notHidden().dateLimit(LocalDateTime.now().minusDays(this.msgHubSharedConfig.getSearchableDays()), null);
        BoolQueryBuilder unreadBuilder = QueryBuilders.boolQuery();
        unreadBuilder.filter((QueryBuilder)QueryBuilders.termsQuery((String)"readFlag", (int[])new int[]{0}));
        if (this.msgHubSharedConfig.isUsePositionFilter()) {
            ArrayList<String> excludeMsgTypeCodeList = new ArrayList<String>();
            BoolQueryBuilder unreadShouldBQB = QueryBuilders.boolQuery();
            List unreadShould = unreadShouldBQB.should();
            LocalDateTime now = LocalDateTime.now();
            LocalDateTime midnight = now.toLocalDate().atStartOfDay();
            long midMilli = midnight.toInstant(Util.GMT_08).toEpochMilli();
            for (UserMsgPosition.Position position : positionList) {
                long l = position.getReadPositionMs();
                if (l <= midMilli) continue;
                BoolQueryBuilder mustBQB = QueryBuilders.boolQuery();
                List must = mustBQB.must();
                must.add(QueryBuilders.termQuery((String)"msgTypeCode", (String)position.getCode()));
                must.add(QueryBuilders.rangeQuery((String)"createAt").gt((Object)l));
                unreadShould.add(mustBQB);
                excludeMsgTypeCodeList.add(position.getCode());
            }
            if (Util.isNotEmpty(excludeMsgTypeCodeList)) {
                BoolQueryBuilder boolQueryBuilder2 = QueryBuilders.boolQuery();
                boolQueryBuilder2.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"msgTypeCode", excludeMsgTypeCodeList));
                unreadShould.add(boolQueryBuilder2);
            }
            unreadBuilder.filter((QueryBuilder)unreadShouldBQB);
        }
        FilterAggregationBuilder filter = (FilterAggregationBuilder)AggregationBuilders.filter((String)"readFlagFilter", (QueryBuilder)unreadBuilder).subAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"msgGroupUnreadAggr").field("msgTypeCode")).size(1000));
        searchSourceBuilder.aggregation((AggregationBuilder)filter);
        TermsAggregationBuilder msgGroupAllAggr = (TermsAggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"msgGroupAllAggr").field("msgTypeCode")).size(1000).subAggregation((AggregationBuilder)AggregationBuilders.topHits((String)"topN1").sort("createAt", SortOrder.DESC).size(docSize));
        searchSourceBuilder.aggregation((AggregationBuilder)msgGroupAllAggr);
        searchSourceBuilder.size(0);
        searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = this.elasticsearchOperations.search(searchRequest);
        Aggregations aggregations = searchResponse.getAggregations();
        HashMap<String, MsgTypeTopN> msgTypeTopNMap = new HashMap<String, MsgTypeTopN>();
        ParsedFilter parsedFilter = (ParsedFilter)aggregations.get("readFlagFilter");
        ParsedStringTerms unreadBuckets = (ParsedStringTerms)parsedFilter.getAggregations().get("msgGroupUnreadAggr");
        for (Terms.Bucket bucket : unreadBuckets.getBuckets()) {
            long docCount = bucket.getDocCount();
            String codeName = bucket.getKeyAsString();
            MsgTypeTopN msgTypeTopN = new MsgTypeTopN();
            msgTypeTopN.setMsgCode(codeName);
            msgTypeTopN.setUnreadCount(docCount);
            msgTypeTopNMap.put(codeName, msgTypeTopN);
        }
        ParsedStringTerms parsedStringTerms = (ParsedStringTerms)aggregations.get("msgGroupAllAggr");
        for (final Terms.Bucket bucket : parsedStringTerms.getBuckets()) {
            Aggregations aggr = bucket.getAggregations();
            ParsedTopHits topNAggr = (ParsedTopHits)aggr.get("topN1");
            SearchHits hits = topNAggr.getHits();
            MsgTypeTopN msgTypeTopN = msgTypeTopNMap.computeIfAbsent(bucket.getKeyAsString(), new Function<String, MsgTypeTopN>(){

                @Override
                public MsgTypeTopN apply(String s) {
                    MsgTypeTopN msgTypeTopN = new MsgTypeTopN();
                    msgTypeTopN.setMsgCode(bucket.getKeyAsString());
                    return msgTypeTopN;
                }
            });
            ArrayList<UserMessage> list = new ArrayList<UserMessage>();
            for (SearchHit hit : hits) {
                String source = hit.getSourceAsString();
                UserMessage read = (UserMessage)this.jsonAccessor.read(source, UserMessage.class);
                read.id(hit.getId());
                list.add(read);
            }
            msgTypeTopN.setUserMessageList(list);
            msgTypeTopNList.add(msgTypeTopN);
        }
        return msgTypeTopNList;
    }

    private List<MsgTypeTopN> unreadWithUnreadCount(MessageQuery messageQuery, int docSize) {
        List<String> codeFilterList;
        ArrayList<MsgTypeTopN> msgTypeTopNList = new ArrayList<MsgTypeTopN>();
        List<String> searchableIndex = UserMessageElasticsearchManager.getOrCreate().searchableIndex();
        log.info("construct unreadWithUnreadCount, from index: " + JSONAccessor.impl().format(searchableIndex));
        SearchRequest searchRequest = new SearchRequest(searchableIndex.toArray(new String[0]));
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        Objects.requireNonNull(messageQuery.getUserId());
        Objects.requireNonNull(messageQuery.getGroupId());
        boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"userId", (Object)messageQuery.getUserId()));
        boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"groupId", (Object)messageQuery.getGroupId()));
        boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"readFlag", (int)0));
        if (Util.isNotEmpty(messageQuery.getMsgCodeList())) {
            if (!messageQuery.isQueryAllMsgFlag()) {
                boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termsQuery((String)"msgTypeCode", messageQuery.getMsgCodeList()));
            }
            codeFilterList = messageQuery.getMsgCodeList();
        } else {
            codeFilterList = this.defMsgCfService.allMsgTypeCode();
        }
        if (this.msgHubSharedConfig.isUsePositionFilter()) {
            ArrayList<String> excludeMsgTypeCodeList = new ArrayList<String>();
            List<UserMsgPosition.Position> positionList = this.userMsgPositionService.position(messageQuery.getUserId(), codeFilterList);
            BoolQueryBuilder shouldBQB = QueryBuilders.boolQuery();
            List should = shouldBQB.should();
            LocalDateTime now = LocalDateTime.now();
            LocalDateTime midnight = now.toLocalDate().atStartOfDay();
            long midMilli = midnight.toInstant(Util.GMT_08).toEpochMilli();
            for (UserMsgPosition.Position position : positionList) {
                long l = Math.max(position.getDeletePositionMs(), position.getReadPositionMs());
                if (l <= midMilli) continue;
                BoolQueryBuilder mustBQB = QueryBuilders.boolQuery();
                List must = mustBQB.must();
                must.add(QueryBuilders.termQuery((String)"msgTypeCode", (String)position.getCode()));
                must.add(QueryBuilders.rangeQuery((String)"createAt").gt((Object)l));
                should.add(mustBQB);
                excludeMsgTypeCodeList.add(position.getCode());
            }
            if (Util.isNotEmpty(excludeMsgTypeCodeList)) {
                BoolQueryBuilder excludeBoolQueryBuilder = QueryBuilders.boolQuery();
                excludeBoolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"msgTypeCode", excludeMsgTypeCodeList));
                should.add(excludeBoolQueryBuilder);
            }
            boolQueryBuilder.filter((QueryBuilder)shouldBQB);
        }
        if (messageQuery.getPopOnOff() != null) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"popOnOff", (Object)messageQuery.getPopOnOff()));
        }
        if (messageQuery.getTopOnOff() != null) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"topOnOff", (Object)messageQuery.getTopOnOff()));
        }
        if (messageQuery.getFloatOnOff() != null) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"floatOnOff", (Object)messageQuery.getFloatOnOff()));
        }
        MessageFsyncESService.boolQueryFilter(boolQueryBuilder).notDeleted().notHidden().dateLimit(LocalDateTime.now().minusDays(this.msgHubSharedConfig.getSearchableDays()), null);
        TermsAggregationBuilder msgGroupAllAggr = (TermsAggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"msgGroupUnreadAggr").field("msgTypeCode")).size(1000).subAggregation((AggregationBuilder)AggregationBuilders.topHits((String)"topN1").sort("createAt", SortOrder.DESC).size(docSize));
        searchSourceBuilder.aggregation((AggregationBuilder)msgGroupAllAggr);
        searchSourceBuilder.size(0);
        searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = this.elasticsearchOperations.search(searchRequest);
        Aggregations aggregations = searchResponse.getAggregations();
        HashMap<String, MsgTypeTopN> msgTypeTopNMap = new HashMap<String, MsgTypeTopN>();
        ParsedStringTerms parsedStringTerms = (ParsedStringTerms)aggregations.get("msgGroupUnreadAggr");
        for (final Terms.Bucket bucket : parsedStringTerms.getBuckets()) {
            final long docCount = bucket.getDocCount();
            Aggregations aggr = bucket.getAggregations();
            ParsedTopHits topNAggr = (ParsedTopHits)aggr.get("topN1");
            SearchHits hits = topNAggr.getHits();
            MsgTypeTopN msgTypeTopN = msgTypeTopNMap.computeIfAbsent(bucket.getKeyAsString(), new Function<String, MsgTypeTopN>(){

                @Override
                public MsgTypeTopN apply(String s) {
                    MsgTypeTopN msgTypeTopN = new MsgTypeTopN();
                    msgTypeTopN.setMsgCode(bucket.getKeyAsString());
                    msgTypeTopN.setUnreadCount(docCount);
                    return msgTypeTopN;
                }
            });
            ArrayList<UserMessage> list = new ArrayList<UserMessage>();
            for (SearchHit hit : hits) {
                String source = hit.getSourceAsString();
                UserMessage read = (UserMessage)this.jsonAccessor.read(source, UserMessage.class);
                read.id(hit.getId());
                list.add(read);
            }
            msgTypeTopN.setUserMessageList(list);
            msgTypeTopNList.add(msgTypeTopN);
        }
        return msgTypeTopNList;
    }

    @Override
    public List<MsgTypeStat> msgCodeGroupStat(MessageQuery messageQuery) {
        ArrayList<MsgTypeStat> msgTypeStatList = new ArrayList<MsgTypeStat>();
        List<String> searchableIndex = UserMessageElasticsearchManager.getOrCreate().searchableIndex();
        log.info("construct msgCodeGroupStat, from index: " + JSONAccessor.impl().format(searchableIndex));
        SearchRequest searchRequest = new SearchRequest(searchableIndex.toArray(new String[0]));
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        Objects.requireNonNull(messageQuery.getUserId());
        Objects.requireNonNull(messageQuery.getGroupId());
        boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"userId", (Object)messageQuery.getUserId()));
        boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"groupId", (Object)messageQuery.getGroupId()));
        boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"readFlag", (int)0));
        if (this.msgHubSharedConfig.isUsePositionFilter()) {
            ArrayList<String> excludeMsgTypeCodeList = new ArrayList<String>();
            BoolQueryBuilder unreadShouldBQB = QueryBuilders.boolQuery();
            List unreadShould = unreadShouldBQB.should();
            LocalDateTime now = LocalDateTime.now();
            LocalDateTime midnight = now.toLocalDate().atStartOfDay();
            long midMilli = midnight.toInstant(Util.GMT_08).toEpochMilli();
            for (UserMsgPosition.Position position : this.userMsgPositionService.position(messageQuery.getUserId(), this.defMsgCfService.allMsgTypeCode())) {
                long l = Math.max(position.getReadPositionMs(), position.getDeletePositionMs());
                if (l <= midMilli) continue;
                BoolQueryBuilder mustBQB = QueryBuilders.boolQuery();
                List must = mustBQB.must();
                must.add(QueryBuilders.termQuery((String)"msgTypeCode", (String)position.getCode()));
                must.add(QueryBuilders.rangeQuery((String)"createAt").gt((Object)l));
                unreadShould.add(mustBQB);
                excludeMsgTypeCodeList.add(position.getCode());
            }
            if (Util.isNotEmpty(excludeMsgTypeCodeList)) {
                BoolQueryBuilder excludeBoolQueryBuilder = QueryBuilders.boolQuery();
                excludeBoolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"msgTypeCode", excludeMsgTypeCodeList));
                unreadShould.add(excludeBoolQueryBuilder);
            }
            boolQueryBuilder.filter((QueryBuilder)unreadShouldBQB);
        }
        if (Util.isNotEmpty(messageQuery.getMsgCodeList()) && !messageQuery.isQueryAllMsgFlag()) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termsQuery((String)"msgTypeCode", messageQuery.getMsgCodeList()));
        }
        if (messageQuery.getPopOnOff() != null) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"popOnOff", (Object)messageQuery.getPopOnOff()));
        }
        if (messageQuery.getTopOnOff() != null) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"topOnOff", (Object)messageQuery.getTopOnOff()));
        }
        if (messageQuery.getFloatOnOff() != null) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"floatOnOff", (Object)messageQuery.getFloatOnOff()));
        }
        MessageFsyncESService.boolQueryFilter(boolQueryBuilder).notDeleted().notHidden().dateLimit(LocalDateTime.now().minusDays(this.msgHubSharedConfig.getSearchableDays()), null);
        TermsAggregationBuilder msgGroupAllAggr = (TermsAggregationBuilder)AggregationBuilders.terms((String)"msgGroupUnreadAggr").field("msgTypeCode");
        searchSourceBuilder.aggregation((AggregationBuilder)msgGroupAllAggr);
        searchSourceBuilder.size(0);
        searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = this.elasticsearchOperations.search(searchRequest);
        Aggregations aggregations = searchResponse.getAggregations();
        ParsedStringTerms parsedStringTerms = (ParsedStringTerms)aggregations.get("msgGroupUnreadAggr");
        for (Terms.Bucket bucket : parsedStringTerms.getBuckets()) {
            long docCount = bucket.getDocCount();
            MsgTypeStat msgTypeStat = new MsgTypeStat();
            msgTypeStat.setMsgCode(bucket.getKeyAsString());
            msgTypeStat.setUnreadCount(docCount);
            msgTypeStatList.add(msgTypeStat);
        }
        return msgTypeStatList;
    }

    @Override
    public MsgTypeTopN msgCodeView(MessageQuery messageQuery, int docSize) {
        List<String> searchableIndex = UserMessageElasticsearchManager.getOrCreate().searchableIndex();
        log.info("construct msgCodeView, from index: " + JSONAccessor.impl().format(searchableIndex));
        SearchRequest searchRequest = new SearchRequest(searchableIndex.toArray(new String[0]));
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        Objects.requireNonNull(messageQuery.getUserId());
        Objects.requireNonNull(messageQuery.getGroupId());
        boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"userId", (Object)messageQuery.getUserId()));
        boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"groupId", (Object)messageQuery.getGroupId()));
        if (messageQuery.getPopOnOff() != null) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"popOnOff", (Object)messageQuery.getPopOnOff()));
        }
        if (messageQuery.getTopOnOff() != null) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"topOnOff", (Object)messageQuery.getTopOnOff()));
        }
        if (messageQuery.getFloatOnOff() != null) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"floatOnOff", (Object)messageQuery.getFloatOnOff()));
        }
        if (Util.compare2((Comparable)messageQuery.getReadFlag(), (Comparable)Integer.valueOf(0)) == 0) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termsQuery((String)"readFlag", (int[])new int[]{0}));
        }
        if (Util.isNotEmpty(messageQuery.getMsgCodeList()) && !messageQuery.isQueryAllMsgFlag()) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termsQuery((String)"msgTypeCode", messageQuery.getMsgCodeList()));
        }
        List<UserMsgPosition.Position> positionList = null;
        if (this.msgHubSharedConfig.isUsePositionFilter()) {
            ArrayList<String> excludeMsgTypeCodeList = new ArrayList<String>();
            positionList = this.userMsgPositionService.position(messageQuery.getUserId(), Util.isNotEmpty(messageQuery.getMsgCodeList()) ? messageQuery.getMsgCodeList() : this.defMsgCfService.allMsgTypeCode());
            BoolQueryBuilder shouldBQB = QueryBuilders.boolQuery();
            List should = shouldBQB.should();
            LocalDateTime now = LocalDateTime.now();
            LocalDateTime midnight = now.toLocalDate().atStartOfDay();
            long midMilli = midnight.toInstant(Util.GMT_08).toEpochMilli();
            for (UserMsgPosition.Position position : positionList) {
                long l = Math.max(position.getDeletePositionMs(), Util.compare2((Comparable)messageQuery.getReadFlag(), (Comparable)Integer.valueOf(0)) == 0 ? position.getReadPositionMs() : 0L);
                if (l <= midMilli) continue;
                BoolQueryBuilder mustBQB = QueryBuilders.boolQuery();
                List must = mustBQB.must();
                must.add(QueryBuilders.termQuery((String)"msgTypeCode", (String)position.getCode()));
                must.add(QueryBuilders.rangeQuery((String)"createAt").gt((Object)l));
                should.add(mustBQB);
                excludeMsgTypeCodeList.add(position.getCode());
            }
            if (Util.isNotEmpty(excludeMsgTypeCodeList)) {
                BoolQueryBuilder excludeBoolQueryBuilder = QueryBuilders.boolQuery();
                excludeBoolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"msgTypeCode", excludeMsgTypeCodeList));
                should.add(excludeBoolQueryBuilder);
            }
            boolQueryBuilder.filter((QueryBuilder)shouldBQB);
        }
        MessageFsyncESService.boolQueryFilter(boolQueryBuilder).notDeleted().notHidden().dateLimit(LocalDateTime.now().minusDays(this.msgHubSharedConfig.getSearchableDays()), null);
        BoolQueryBuilder unreadBuilder = QueryBuilders.boolQuery();
        unreadBuilder.filter((QueryBuilder)QueryBuilders.termsQuery((String)"readFlag", (int[])new int[]{0}));
        if (this.msgHubSharedConfig.isUsePositionFilter()) {
            ArrayList<String> excludeMsgTypeCodeList = new ArrayList<String>();
            BoolQueryBuilder unreadShouldBQB = QueryBuilders.boolQuery();
            List unreadShould = unreadShouldBQB.should();
            LocalDateTime now = LocalDateTime.now();
            LocalDateTime midnight = now.toLocalDate().atStartOfDay();
            long midMilli = midnight.toInstant(Util.GMT_08).toEpochMilli();
            for (UserMsgPosition.Position position : positionList) {
                long l = position.getReadPositionMs();
                if (l <= midMilli) continue;
                BoolQueryBuilder mustBQB = QueryBuilders.boolQuery();
                List must = mustBQB.must();
                must.add(QueryBuilders.termQuery((String)"msgTypeCode", (String)position.getCode()));
                must.add(QueryBuilders.rangeQuery((String)"createAt").gt((Object)l));
                unreadShould.add(mustBQB);
                excludeMsgTypeCodeList.add(position.getCode());
            }
            if (Util.isNotEmpty(excludeMsgTypeCodeList)) {
                BoolQueryBuilder boolQueryBuilder2 = QueryBuilders.boolQuery();
                boolQueryBuilder2.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"msgTypeCode", excludeMsgTypeCodeList));
                unreadShould.add(boolQueryBuilder2);
            }
            unreadBuilder.filter((QueryBuilder)unreadShouldBQB);
        }
        FilterAggregationBuilder filter = AggregationBuilders.filter((String)"readFlagFilter", (QueryBuilder)unreadBuilder);
        searchSourceBuilder.aggregation((AggregationBuilder)filter);
        searchSourceBuilder.size(docSize);
        searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
        if (messageQuery.getLastTimeForSearchAfter() != null) {
            searchSourceBuilder.searchAfter(new Object[]{messageQuery.getLastTimeForSearchAfter(), messageQuery.getLastIdForSearchAfter()});
        }
        searchSourceBuilder.sort("createAt", SortOrder.DESC);
        searchSourceBuilder.sort("_id", SortOrder.ASC);
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = this.elasticsearchOperations.search(searchRequest);
        Map<String, UserMsgPosition.Position> positionMap = positionList.stream().collect(Collectors.toMap(UserMsgPosition.Position::getCode, v -> v));
        Aggregations aggregations = searchResponse.getAggregations();
        MsgTypeTopN msgTypeTopN = new MsgTypeTopN();
        ParsedFilter parsedFilter = (ParsedFilter)aggregations.get("readFlagFilter");
        msgTypeTopN.setUnreadCount(parsedFilter.getDocCount());
        SearchHits hits = searchResponse.getHits();
        ArrayList<UserMessage> arrayList = new ArrayList<UserMessage>();
        for (SearchHit hit : hits) {
            String source = hit.getSourceAsString();
            UserMessage read = (UserMessage)this.jsonAccessor.read(source, UserMessage.class);
            read.id(hit.getId());
            UserMsgPosition.Position position = positionMap.get(read.getMsgTypeCode());
            if (position != null && position.getReadPositionMs() > read.getCreateAt().toInstant(Util.GMT_08).toEpochMilli()) {
                read.setReadFlag(1);
            }
            arrayList.add(read);
        }
        msgTypeTopN.setUserMessageList(arrayList);
        return msgTypeTopN;
    }

    @Override
    public List<String> delete(List<String> ids) {
        ArrayList<String> undeleted = new ArrayList<String>();
        this.elasticsearchOperations.bulkDeleteInMultiIndex(ids, new String[]{UserMessage.INDEX_WRITE});
        return undeleted;
    }

    @Override
    public List<String> updateAsDel(List<String> ids) {
        ElasticsearchOperations.BulkUpdateResponse bulkUpdateResponse = this.elasticsearchOperations.updatePartOfDocInMultiIndex(ids, (Supplier)new Supplier<Script>(this){

            @Override
            public Script get() {
                HashMap params = new HashMap();
                Script script = new Script(ScriptType.INLINE, "painless", "ctx._source.delFlag=1;", params);
                return script;
            }
        }, new String[]{UserMessage.INDEX_WRITE});
        return new ArrayList<String>(bulkUpdateResponse.getFail());
    }

    @Override
    public long countMsg(Integer userId, Integer groupId, List<String> msgTypeCodeList, Integer readFlag) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (userId != null) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"userId", (Object)userId));
        }
        if (groupId != null) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"groupId", (Object)groupId));
        }
        if (readFlag != null) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"readFlag", (Object)readFlag));
        }
        MessageFsyncESService.boolQueryFilter(boolQueryBuilder).notDeleted().notHidden().dateLimit(LocalDateTime.now().minusDays(this.msgHubSharedConfig.getSearchableDays()), null);
        if (this.msgHubSharedConfig.isUsePositionFilter()) {
            ArrayList<String> excludeMsgTypeCodeList = new ArrayList<String>();
            BoolQueryBuilder unreadShouldBQB = QueryBuilders.boolQuery();
            List unreadShould = unreadShouldBQB.should();
            LocalDateTime now = LocalDateTime.now();
            LocalDateTime midnight = now.toLocalDate().atStartOfDay();
            long midMilli = midnight.toInstant(Util.GMT_08).toEpochMilli();
            for (UserMsgPosition.Position position : this.userMsgPositionService.position(userId, this.defMsgCfService.allMsgTypeCode())) {
                long l = Math.max(position.getReadPositionMs(), position.getDeletePositionMs());
                if (l <= midMilli) continue;
                BoolQueryBuilder mustBQB = QueryBuilders.boolQuery();
                List must = mustBQB.must();
                must.add(QueryBuilders.termQuery((String)"msgTypeCode", (String)position.getCode()));
                must.add(QueryBuilders.rangeQuery((String)"createAt").gt((Object)l));
                unreadShould.add(mustBQB);
                excludeMsgTypeCodeList.add(position.getCode());
            }
            if (Util.isNotEmpty(excludeMsgTypeCodeList)) {
                BoolQueryBuilder excludeBoolQueryBuilder = QueryBuilders.boolQuery();
                excludeBoolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"msgTypeCode", excludeMsgTypeCodeList));
                unreadShould.add(excludeBoolQueryBuilder);
            }
            boolQueryBuilder.filter((QueryBuilder)unreadShouldBQB);
        }
        CountRequest countRequest = new CountRequest();
        List<String> searchableIndex = UserMessageElasticsearchManager.getOrCreate().searchableIndex();
        log.info("construct countMsg, from index: " + JSONAccessor.impl().format(searchableIndex));
        countRequest.indices(searchableIndex.toArray(new String[0])).query((QueryBuilder)boolQueryBuilder);
        return this.elasticsearchOperations.count(countRequest);
    }

    public static class BoolQueryFilter {
        final BoolQueryBuilder boolQueryBuilder;

        public BoolQueryFilter(BoolQueryBuilder boolQueryBuilder) {
            this.boolQueryBuilder = boolQueryBuilder;
        }

        public BoolQueryFilter del(int del) {
            this.boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"delFlag", (int)del));
            return this;
        }

        public BoolQueryFilter readFlag(int readFlag) {
            this.boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"readFlag", (int)readFlag));
            return this;
        }

        public BoolQueryFilter hidden(int hidden) {
            this.boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"hidden", (int)hidden));
            return this;
        }

        public BoolQueryFilter userId(int userId) {
            this.boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"userId", (int)userId));
            return this;
        }

        public BoolQueryFilter dateLimit(LocalDateTime start, LocalDateTime end) {
            this.boolQueryBuilder.filter((QueryBuilder)QueryBuilders.rangeQuery((String)"createAt").from((Object)start, true).to((Object)end, true));
            return this;
        }

        public BoolQueryFilter msgTypeCodeList(List<String> msgTypeCodeList) {
            if (Util.isNotEmpty(msgTypeCodeList)) {
                this.boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termsQuery((String)"msgTypeCode", msgTypeCodeList));
            }
            return this;
        }

        public BoolQueryFilter append(Consumer<BoolQueryBuilder> consumer) {
            consumer.accept(this.boolQueryBuilder);
            return this;
        }

        public BoolQueryFilter notDeleted() {
            return this.del(0);
        }

        public BoolQueryFilter notHidden() {
            return this.hidden(0);
        }
    }
}

