/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.kernel;

import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.kv.TtlCacheServiceV2;
import com.ovopark.messagehub.kernel.DefMsgCfService;
import com.ovopark.messagehub.kernel.InternalWebSocketService;
import com.ovopark.messagehub.kernel.MessageFsyncService;
import com.ovopark.messagehub.kernel.MsgCfService;
import com.ovopark.messagehub.kernel.MsgHubSharedConfig;
import com.ovopark.messagehub.kernel.TodoMsgService;
import com.ovopark.messagehub.kernel.UserEventNotify;
import com.ovopark.messagehub.kernel.UserMsgTypeConfig;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserEventNotifyImpl
implements UserEventNotify {
    static volatile TtlCacheServiceV2<String> ttlCacheServiceV2;
    @Autowired
    private MessageFsyncService messageFsyncService;
    @Autowired
    private TodoMsgService todoMsgService;
    @Autowired
    private MsgHubSharedConfig msgHubSharedConfig;
    @Autowired
    private MsgCfService msgCfService;
    @Autowired
    private DefMsgCfService defMsgCfService;
    private ExecutorService countEventExecutor;
    private ExecutorService refreshEventExecutor;
    @Autowired
    private InternalWebSocketService internalWebSocketService;

    @PostConstruct
    private void post() {
        if (ttlCacheServiceV2 == null) {
            this.countEventExecutor = Util.defaultExecutorService((String)"user-count-event-notify", (int)16, (int)1, (RejectedExecutionHandler)new ThreadPoolExecutor.AbortPolicy());
            this.refreshEventExecutor = Util.defaultExecutorService((String)"user-refresh-event-notify", (int)16, (int)16, (int)1000000, (RejectedExecutionHandler)new ThreadPoolExecutor.AbortPolicy());
            ttlCacheServiceV2 = TtlCacheServiceV2.impl((int)1000);
            ttlCacheServiceV2.subscribeTtl(k -> k.startsWith("todoMsgAnyEvent") || k.startsWith("msgCreatedEvent"), (TtlCacheServiceV2.TtlListener)new TtlCacheServiceV2.TtlListener<String>(){

                public void onTtl(String s, Object o, long l, long l1) {
                    UserCache userCache = (UserCache)o;
                    try {
                        UserEventNotifyImpl.this.refreshEventExecutor.execute(Util.catchRunnable(() -> UserEventNotifyImpl.this.notifyUserOnCreated(userCache)));
                    }
                    catch (RejectedExecutionException e) {
                        Util.log.info("reject refresh event , key: " + s + ", value: " + JSONAccessor.impl().format((Object)userCache));
                    }
                }
            });
            ttlCacheServiceV2.subscribeTtl(k -> k.startsWith("todoMsgEvent") || k.startsWith("msgEvent"), (TtlCacheServiceV2.TtlListener)new TtlCacheServiceV2.TtlListener<String>(){

                public void onTtl(String s, Object o, long l, long l1) {
                    UserCache userCache = (UserCache)o;
                    try {
                        UserEventNotifyImpl.this.countEventExecutor.execute(Util.catchRunnable(() -> UserEventNotifyImpl.this.notifyUserOnCount(userCache)));
                    }
                    catch (RejectedExecutionException e) {
                        Util.log.info("reject count event , key: " + s + ", value: " + JSONAccessor.impl().format((Object)userCache));
                    }
                }
            });
        }
    }

    private void notifyUserOnCreated(UserCache entryValue) {
        Integer userId = entryValue.getUserId();
        this.internalWebSocketService.send(userId, JSONAccessor.impl().format((Object)entryValue), entryValue.isTodoMsg() ? "5006" : "5001", "web", "Android", "iOS");
        Util.log.info("send wbs notify , " + (entryValue.isTodoMsg() ? "todoMsg" : "msg") + " event : " + JSONAccessor.impl().format((Object)entryValue));
    }

    private void notifyUserOnCount(final UserCache entryValue) {
        long c;
        final Integer userId = entryValue.getUserId();
        Count count = new Count(this);
        if (entryValue.isTodoMsg()) {
            c = this.todoMsgService.count(userId);
        } else {
            final ArrayList<String> foundMsgCodeList = new ArrayList<String>();
            for (DefMsgCfService.DefMsgCfNode defMsgCfNode : this.defMsgCfService.treeView()) {
                defMsgCfNode.walk(new Consumer<DefMsgCfService.DefMsgCfNode>(){

                    @Override
                    public void accept(DefMsgCfService.DefMsgCfNode defMsgCfNode) {
                        String code = ((DefMsgCfService.DefMsgCf)defMsgCfNode.nodeRef()).getCode();
                        UserMsgTypeConfig cf = UserEventNotifyImpl.this.msgCfService.cfOnSelf(entryValue.getGroupId(), userId, code);
                        if (cf != null && cf.noDisturbingFlag() == 0) {
                            foundMsgCodeList.add(code);
                        }
                    }
                });
            }
            c = Util.isEmpty(foundMsgCodeList) ? 0L : this.messageFsyncService.countMsg(userId, null, foundMsgCodeList, 0);
        }
        count.setCount(c);
        this.internalWebSocketService.send(userId, JSONAccessor.impl().format((Object)count), entryValue.isTodoMsg() ? "5005" : "5004", "web", "Android", "iOS");
        Util.log.info("send wbs notify, " + (entryValue.isTodoMsg() ? "todoMsg" : "msg") + " count : " + JSONAccessor.impl().format((Object)count));
    }

    @Override
    public void notifyUserOnTodoMsg(final Integer userId, final Integer groupId, Long todoMsgId, UserEventNotify.Operation operation) {
        Util.log.info("notifyUserOnTodoMsg (" + String.valueOf((Object)operation) + "), interval: " + this.msgHubSharedConfig.getMsgUpdatedPushSec() + " , push cache , then notify user event: " + userId + ", " + groupId + ", todoMsgId: " + todoMsgId);
        ttlCacheServiceV2.putAndGet((Comparable)((Object)("todoMsgAnyEvent:" + userId)), (Function)new Function<UserCache, UserCache>(){

            @Override
            public UserCache apply(UserCache userCache) {
                if (userCache == null) {
                    userCache = new UserCache();
                    userCache.setTodoMsg(true);
                }
                userCache.setUserId(userId);
                if (groupId != null) {
                    userCache.setGroupId(groupId);
                }
                return userCache;
            }
        }, (long)this.msgHubSharedConfig.getTodoMsgEventPushSec(), TimeUnit.SECONDS);
        ttlCacheServiceV2.putAndGet((Comparable)((Object)("todoMsgEvent:" + userId)), (Function)new Function<UserCache, UserCache>(){

            @Override
            public UserCache apply(UserCache userCache) {
                if (userCache == null) {
                    userCache = new UserCache();
                    userCache.setTodoMsg(true);
                }
                userCache.setUserId(userId);
                if (groupId != null) {
                    userCache.setGroupId(groupId);
                }
                return userCache;
            }
        }, (long)this.msgHubSharedConfig.getTodoMsgCountPushSec(), TimeUnit.SECONDS);
    }

    @Override
    public void notifyUserOnMsg(final Integer userId, final Integer groupId, String msgId, UserEventNotify.Operation operation) {
        Util.log.info("notifyUserOnMsg (" + String.valueOf((Object)operation) + "), interval: " + this.msgHubSharedConfig.getMsgUpdatedPushSec() + " ,push cache , then notify user event: " + userId + ", " + groupId + ", msgId: " + msgId);
        if (operation == UserEventNotify.Operation.CREATE) {
            ttlCacheServiceV2.putAndGet((Comparable)((Object)("msgCreatedEvent:" + userId)), (Function)new Function<UserCache, UserCache>(){

                @Override
                public UserCache apply(UserCache userCache) {
                    if (userCache == null) {
                        userCache = new UserCache();
                    }
                    userCache.setUserId(userId);
                    if (groupId != null) {
                        userCache.setGroupId(groupId);
                    }
                    return userCache;
                }
            }, (long)this.msgHubSharedConfig.getMsgCreatedPushSec(), TimeUnit.SECONDS);
        } else {
            ttlCacheServiceV2.putAndGet((Comparable)((Object)("msgEvent:" + userId)), (Function)new Function<UserCache, UserCache>(){

                @Override
                public UserCache apply(UserCache userCache) {
                    if (userCache == null) {
                        userCache = new UserCache();
                    }
                    userCache.setUserId(userId);
                    if (groupId != null) {
                        userCache.setGroupId(groupId);
                    }
                    return userCache;
                }
            }, (long)this.msgHubSharedConfig.getMsgUpdatedPushSec(), TimeUnit.SECONDS);
        }
    }

    static class UserCache {
        private boolean todoMsg;
        private Integer userId;
        private Integer groupId;

        public boolean isTodoMsg() {
            return this.todoMsg;
        }

        public Integer getUserId() {
            return this.userId;
        }

        public Integer getGroupId() {
            return this.groupId;
        }

        public void setTodoMsg(boolean todoMsg) {
            this.todoMsg = todoMsg;
        }

        public void setUserId(Integer userId) {
            this.userId = userId;
        }

        public void setGroupId(Integer groupId) {
            this.groupId = groupId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UserCache)) {
                return false;
            }
            UserCache other = (UserCache)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isTodoMsg() != other.isTodoMsg()) {
                return false;
            }
            Integer this$userId = this.getUserId();
            Integer other$userId = other.getUserId();
            if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
                return false;
            }
            Integer this$groupId = this.getGroupId();
            Integer other$groupId = other.getGroupId();
            return !(this$groupId == null ? other$groupId != null : !((Object)this$groupId).equals(other$groupId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UserCache;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isTodoMsg() ? 79 : 97);
            Integer $userId = this.getUserId();
            result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
            Integer $groupId = this.getGroupId();
            result = result * 59 + ($groupId == null ? 43 : ((Object)$groupId).hashCode());
            return result;
        }

        public String toString() {
            return "UserEventNotifyImpl.UserCache(todoMsg=" + this.isTodoMsg() + ", userId=" + this.getUserId() + ", groupId=" + this.getGroupId() + ")";
        }
    }

    class Count {
        private long count;

        public Count(UserEventNotifyImpl this$0) {
        }

        public long getCount() {
            return this.count;
        }

        public void setCount(long count) {
            this.count = count;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Count)) {
                return false;
            }
            Count other = (Count)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.getCount() == other.getCount();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Count;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $count = this.getCount();
            result = result * 59 + (int)($count >>> 32 ^ $count);
            return result;
        }

        public String toString() {
            return "UserEventNotifyImpl.Count(count=" + this.getCount() + ")";
        }
    }
}

