/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.kernel.config;

import com.ovopark.kernel.shared.Util;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.UUID;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

@Component
public class LogInterceptor
implements HandlerInterceptor {
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object object) throws Exception {
        String requestId = request.getHeader("requestId");
        if (Util.isEmpty((CharSequence)requestId)) {
            requestId = UUID.randomUUID().toString();
        }
        MDC.put((String)"requestId", (String)requestId);
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        MDC.remove((String)"requestId");
    }
}

