/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.plugins.bridge.reply;

import com.ovopark.messagehub.plugins.bridge.reply.ReplyEvent;
import com.ovopark.messagehub.plugins.bridge.reply.UserIdAsResponse;
import com.ovopark.messagehub.plugins.bridge.reply.UserRefResponse;
import com.ovopark.messagehub.sdk.model.Subs;
import java.util.List;

public class MessageReply<T>
implements ReplyEvent {
    private String msgTraceId;
    private String taskId;
    private String msgId;
    private int status;
    private String desc;
    private Subs subs;
    private T response;

    public static MessageReply<? super Object> success(Subs subs, String msgTraceId, String taskId, String msgId) {
        MessageReply messageReply = new MessageReply();
        messageReply.setSubs(subs);
        messageReply.setMsgTraceId(msgTraceId);
        messageReply.setTaskId(taskId);
        messageReply.setMsgId(msgId);
        messageReply.setStatus(1);
        return messageReply;
    }

    public static MessageReply<? super Object> fail(Subs subs, String msgTraceId, String taskId, String msgId) {
        MessageReply messageReply = new MessageReply();
        messageReply.setSubs(subs);
        messageReply.setMsgTraceId(msgTraceId);
        messageReply.setTaskId(taskId);
        messageReply.setMsgId(msgId);
        messageReply.setStatus(-1);
        return messageReply;
    }

    public static MessageReply<UserIdAsResponse> userAsSuccess(Subs subs, String msgTraceId, String taskId, String msgId, List<Integer> userId) {
        MessageReply<UserIdAsResponse> messageReply = new MessageReply<UserIdAsResponse>();
        messageReply.setSubs(subs);
        messageReply.setMsgTraceId(msgTraceId);
        messageReply.setTaskId(taskId);
        messageReply.setMsgId(msgId);
        messageReply.setStatus(1);
        UserRefResponse userRefResponse = new UserRefResponse();
        userRefResponse.setUserIdList(userId);
        messageReply.setResponse(userRefResponse);
        return messageReply;
    }

    public static MessageReply<UserIdAsResponse> userAsFail(Subs subs, String msgTraceId, String taskId, String msgId, List<Integer> userId, String desc) {
        MessageReply<UserIdAsResponse> messageReply = new MessageReply<UserIdAsResponse>();
        messageReply.setSubs(subs);
        messageReply.setMsgTraceId(msgTraceId);
        messageReply.setTaskId(taskId);
        messageReply.setMsgId(msgId);
        messageReply.setStatus(-1);
        messageReply.setDesc(desc);
        UserRefResponse userRefResponse = new UserRefResponse();
        userRefResponse.setUserIdList(userId);
        messageReply.setResponse(userRefResponse);
        return messageReply;
    }

    public static MessageReply<? super Object> success(Subs subs, String msgTraceId, String taskId, String msgId, UserIdAsResponse userIdAsResponse) {
        MessageReply<UserIdAsResponse> messageReply = new MessageReply<UserIdAsResponse>();
        messageReply.setSubs(subs);
        messageReply.setMsgTraceId(msgTraceId);
        messageReply.setTaskId(taskId);
        messageReply.setMsgId(msgId);
        messageReply.setStatus(1);
        messageReply.setResponse(userIdAsResponse);
        return messageReply;
    }

    public static MessageReply<? super Object> fail(Subs subs, String msgTraceId, String taskId, String msgId, UserIdAsResponse userIdAsResponse) {
        MessageReply<UserIdAsResponse> messageReply = new MessageReply<UserIdAsResponse>();
        messageReply.setSubs(subs);
        messageReply.setMsgTraceId(msgTraceId);
        messageReply.setTaskId(taskId);
        messageReply.setMsgId(msgId);
        messageReply.setStatus(-1);
        messageReply.setResponse(userIdAsResponse);
        return messageReply;
    }

    public String getMsgTraceId() {
        return this.msgTraceId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getMsgId() {
        return this.msgId;
    }

    public int getStatus() {
        return this.status;
    }

    public String getDesc() {
        return this.desc;
    }

    public Subs getSubs() {
        return this.subs;
    }

    public T getResponse() {
        return this.response;
    }

    public void setMsgTraceId(String msgTraceId) {
        this.msgTraceId = msgTraceId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public void setMsgId(String msgId) {
        this.msgId = msgId;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public void setSubs(Subs subs) {
        this.subs = subs;
    }

    public void setResponse(T response) {
        this.response = response;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessageReply)) {
            return false;
        }
        MessageReply other = (MessageReply)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStatus() != other.getStatus()) {
            return false;
        }
        String this$msgTraceId = this.getMsgTraceId();
        String other$msgTraceId = other.getMsgTraceId();
        if (this$msgTraceId == null ? other$msgTraceId != null : !this$msgTraceId.equals(other$msgTraceId)) {
            return false;
        }
        String this$taskId = this.getTaskId();
        String other$taskId = other.getTaskId();
        if (this$taskId == null ? other$taskId != null : !this$taskId.equals(other$taskId)) {
            return false;
        }
        String this$msgId = this.getMsgId();
        String other$msgId = other.getMsgId();
        if (this$msgId == null ? other$msgId != null : !this$msgId.equals(other$msgId)) {
            return false;
        }
        String this$desc = this.getDesc();
        String other$desc = other.getDesc();
        if (this$desc == null ? other$desc != null : !this$desc.equals(other$desc)) {
            return false;
        }
        Subs this$subs = this.getSubs();
        Subs other$subs = other.getSubs();
        if (this$subs == null ? other$subs != null : !this$subs.equals(other$subs)) {
            return false;
        }
        T this$response = this.getResponse();
        T other$response = other.getResponse();
        return !(this$response == null ? other$response != null : !this$response.equals(other$response));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MessageReply;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getStatus();
        String $msgTraceId = this.getMsgTraceId();
        result = result * 59 + ($msgTraceId == null ? 43 : $msgTraceId.hashCode());
        String $taskId = this.getTaskId();
        result = result * 59 + ($taskId == null ? 43 : $taskId.hashCode());
        String $msgId = this.getMsgId();
        result = result * 59 + ($msgId == null ? 43 : $msgId.hashCode());
        String $desc = this.getDesc();
        result = result * 59 + ($desc == null ? 43 : $desc.hashCode());
        Subs $subs = this.getSubs();
        result = result * 59 + ($subs == null ? 43 : $subs.hashCode());
        T $response = this.getResponse();
        result = result * 59 + ($response == null ? 43 : $response.hashCode());
        return result;
    }

    public String toString() {
        return "MessageReply(msgTraceId=" + this.getMsgTraceId() + ", taskId=" + this.getTaskId() + ", msgId=" + this.getMsgId() + ", status=" + this.getStatus() + ", desc=" + this.getDesc() + ", subs=" + String.valueOf(this.getSubs()) + ", response=" + String.valueOf(this.getResponse()) + ")";
    }
}

