/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.plugins.dd;

import com.ovopark.kernel.shared.stream.CoreSubscriber;
import com.ovopark.messagehub.plugins.bridge.DDMsg;
import com.ovopark.messagehub.plugins.bridge.KafkaReply;
import com.ovopark.messagehub.plugins.bridge.MsgContext;
import com.ovopark.messagehub.plugins.bridge.dd.DDMessage;
import com.ovopark.messagehub.plugins.bridge.qw.QWResponse;
import com.ovopark.messagehub.plugins.bridge.reply.MessageReply;
import com.ovopark.messagehub.plugins.dd.DDSender;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDSubscriber
extends CoreSubscriber<MsgContext<DDMsg>> {
    private static final Logger log = LoggerFactory.getLogger(DDSubscriber.class);
    private final KafkaReply kafkaReply;
    private final DDSender sender;

    public DDSubscriber(KafkaReply kafkaReply, DDSender sender) {
        this.kafkaReply = kafkaReply;
        this.sender = sender;
    }

    public void onNext(MsgContext<DDMsg> msgMsgContext) {
        DDMsg msg = (DDMsg)msgMsgContext.msg();
        DDMessage qwMessage = (DDMessage)msg.getBody();
        List<MessageReply<QWResponse>> replyList = this.sender.send(msg.getUsers(), qwMessage, msgMsgContext);
        for (MessageReply<QWResponse> reply : replyList) {
            this.kafkaReply.reply("messagehub-plugins-reply", reply, msgMsgContext);
        }
    }
}

