/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.plugins.gzh;

import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.stream.Stream;
import com.ovopark.kernel.shared.stream.Subscriber;
import com.ovopark.messagehub.plugins.bridge.GZHMsg;
import com.ovopark.messagehub.plugins.bridge.KafkaReply;
import com.ovopark.messagehub.plugins.bridge.Msg;
import com.ovopark.messagehub.plugins.bridge.MsgContext;
import com.ovopark.messagehub.plugins.bridge.gzh.GZHUser;
import com.ovopark.messagehub.plugins.gzh.GZHSubscriber;
import com.ovopark.messagehub.plugins.gzh.GZHUserSyncHandler;
import com.ovopark.messagehub.plugins.gzh.api.WechatServerApi;
import com.ovopark.messagehub.plugins.kernel.ConditionOnSubs;
import com.ovopark.messagehub.plugins.kernel.service.PluginsCfgService;
import com.ovopark.messagehub.sdk.model.Subs;
import com.ovopark.messagehub.sdk.model.internal.PluginsManager;
import java.util.HashMap;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Component;

@ConditionOnSubs(value="GZH")
@Component
public class GZHInStream {
    private static final Logger log = LoggerFactory.getLogger(GZHInStream.class);
    @Autowired
    private KafkaReply kafkaReply;
    @Autowired
    private GZHUserSyncHandler gzhUserSyncHandler;
    @Autowired
    private PluginsCfgService pluginsCfgService;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private WechatServerApi wechatServerApi;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KafkaListener(concurrency="${messagehub.plugins.gzh.kafka.concurrency:10}", properties={"partition.assignment.strategy:org.apache.kafka.clients.consumer.CooperativeStickyAssignor"}, topicPattern="messagehub-plugins-gzh", groupId="${messagehub.plugins.gzh.kafka.group:messagehub-group-gzh}", containerFactory="gzhKafkaContainerFactory")
    public void message(ConsumerRecord<String, Object> record) {
        String topic = record.topic();
        int partition = record.partition();
        long offset = record.offset();
        log.info(Thread.currentThread().hashCode() + ",topic: " + topic + ", partition: " + partition + ", offset: " + offset);
        Object value = record.value();
        GZHMsg msg = (GZHMsg)JSONAccessor.impl().read((String)value, GZHMsg.class);
        log.info(msg.getMsgTraceId() + " from KAFKA: {}", value);
        String msgTraceId = msg.getMsgTraceId();
        MDC.put((String)"requestId", (String)msgTraceId);
        MDC.put((String)"traceId", (String)msgTraceId);
        try {
            Stream.from((Object)new MsgContext(msgTraceId, (Msg)msg)).doFinally(s -> {
                HashMap<String, String> meta = new HashMap<String, String>();
                meta.put("msgTraceId", msgTraceId);
                PluginsManager.getOrCreate().heartbeat(Subs.GZH, meta);
            }).subscribe((Subscriber)new GZHSubscriber(this.kafkaReply, this.pluginsCfgService, this.stringRedisTemplate, this.wechatServerApi));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            MDC.remove((String)"requestId");
            MDC.remove((String)"traceId");
        }
    }

    @KafkaListener(concurrency="${messagehub.plugins.gzh.kafka.concurrency:10}", properties={"partition.assignment.strategy:org.apache.kafka.clients.consumer.CooperativeStickyAssignor"}, topicPattern="wechat-user-bind", groupId="${messagehub.plugins.gzh.kafka.group:messagehub-group-wechat-user-bind}", containerFactory="wechatUserBindKafkaContainerFactory")
    public void userBindOrUnbind(ConsumerRecord<String, Object> record) {
        String topic = record.topic();
        int partition = record.partition();
        long offset = record.offset();
        log.info(Thread.currentThread().hashCode() + ",topic: " + topic + ", partition: " + partition + ", offset: " + offset);
        Object value = record.value();
        GZHUser user = (GZHUser)JSONAccessor.impl().read((String)value, GZHUser.class);
        log.info("Wechat userBindOrUnbind from KAFKA : {}", value);
        this.gzhUserSyncHandler.syncUser(user.getUserId().toString(), user.getOpenId(), user.getStatus() != null && user.getStatus() == 1);
    }
}

