/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.plugins.jg;

import cn.jiguang.common.resp.APIConnectionException;
import cn.jiguang.common.resp.APIRequestException;
import cn.jpush.api.JPushClient;
import cn.jpush.api.push.PushResult;
import cn.jpush.api.push.model.Message;
import cn.jpush.api.push.model.Options;
import cn.jpush.api.push.model.Platform;
import cn.jpush.api.push.model.PushPayload;
import cn.jpush.api.push.model.audience.Audience;
import cn.jpush.api.push.model.audience.AudienceTarget;
import cn.jpush.api.push.model.notification.AndroidNotification;
import cn.jpush.api.push.model.notification.IosNotification;
import cn.jpush.api.push.model.notification.Notification;
import cn.jpush.api.push.model.notification.PlatformNotification;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.messagehub.plugins.jg.JPush;
import com.ovopark.messagehub.plugins.jg.MessageObject;
import com.ovopark.messagehub.plugins.jg.PushNotificationParameter;
import com.ovopark.messagehub.plugins.kernel.ConditionOnSubs;
import com.ovopark.messagehub.sdk.model.MessageBody;
import jakarta.annotation.PostConstruct;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@ConditionOnSubs(value="JG")
@Configuration
public class JPushMessageUtil {
    @Value(value="${jpush.apnsProduction::1}")
    private String jpushapnsProduction;
    private static boolean apnsProduction = true;
    private static JPushMessageUtil instance = null;
    protected static final Logger LOG = LoggerFactory.getLogger(JPushMessageUtil.class);

    @PostConstruct
    public void setApnsProduction() {
        LOG.info("jpushapnsProduction:" + this.jpushapnsProduction.trim().equals("1"));
        apnsProduction = this.jpushapnsProduction.trim().equals("1");
        LOG.info("got jpushapnsProduction value: " + this.jpushapnsProduction + ". set apnsProduction:" + apnsProduction);
    }

    public static void sendPush(PushNotificationParameter param) {
        if (instance == null) {
            instance = new JPushMessageUtil();
        }
        if (io.micrometer.common.util.StringUtils.isNotEmpty((String)param.getSecret())) {
            JPushClient jpushClient = new JPushClient(param.getSecret(), param.getAppKey(), 3);
            PushPayload payload = null;
            if (param.getMessageType().equals(JPush.MASSAGE_TYPE_BROAD)) {
                payload = instance.buildPushObject_all_all_alert(param.getMessage());
                LOG.info("payload: 1:" + String.valueOf(payload));
            } else if (param.getMessageType().equals(JPush.MASSAGE_TYPE_NOTIFY)) {
                if (param.getBody() != null) {
                    if (!StringUtils.isEmpty((Object)param.getBody().getFaceType()) && "face".equals(param.getBody().getFaceType())) {
                        payload = instance.buildPushObject_android_and_ios_face(param.getPushAlias(), param.getMessage(), param.getTitle(), param.getBadge(), param.getBody());
                        LOG.info("payload: 2:" + String.valueOf(payload));
                    } else {
                        payload = instance.buildPushObject_android_and_ios(param.getPushAlias(), param.getMessage(), param.getTitle(), param.getBadge(), param.getChannelId(), param.getBody());
                        LOG.info("payload: 3:" + String.valueOf(payload));
                    }
                } else {
                    payload = instance.buildPushObjectAliasAlertWithTitle(param.getPushAlias(), param.getMessage(), param.getTitle());
                    LOG.info("payload: 4:" + String.valueOf(payload));
                }
            } else if (JPush.MASSAGE_TYPE_MSG == param.getMessageType()) {
                payload = JPushMessageUtil.buildPushObject_messageWithExtras(param.getPushAlias(), param.getMsgParam());
                LOG.info("payload: 5:" + String.valueOf(payload));
            } else {
                payload = instance.buildPushObject_all_tags_alert(param.getPushAlias().get(0), param.getMessage());
                LOG.info("payload: 6:" + String.valueOf(payload));
            }
            try {
                PushResult result = jpushClient.sendPush(payload);
                LOG.info("Got result - " + String.valueOf(result));
            }
            catch (APIConnectionException e) {
                LOG.error("Connection error. Should retry later. ", (Throwable)e);
            }
            catch (APIRequestException e) {
                LOG.error("Error response from JPush server. Should review and fix it. ", (Throwable)e);
                LOG.info("HTTP Status: " + e.getStatus());
                LOG.info("Error Code: " + e.getErrorCode());
                LOG.info("Error Message: " + e.getErrorMessage());
                LOG.info("Msg ID: " + e.getMsgId());
            }
        } else {
            LOG.info("jpush key-secret not configged, app key:" + param.getAppKey());
        }
    }

    private PushPayload buildPushObject_all_all_alert(String msg) {
        return PushPayload.alertAll((String)msg);
    }

    private PushPayload buildPushObject_all_tags_alert(String tag, String msg) {
        if (io.micrometer.common.util.StringUtils.isBlank((String)msg)) {
            msg = "";
        }
        return PushPayload.newBuilder().setPlatform(Platform.all()).setAudience(Audience.tag((String[])new String[]{tag})).setNotification(Notification.alert((Object)msg)).setOptions(Options.newBuilder().setApnsProduction(apnsProduction).build()).build();
    }

    private PushPayload buildPushObject_android_alais_alertWithTitle(String alais, String msg, String title) {
        if (io.micrometer.common.util.StringUtils.isBlank((String)msg)) {
            msg = "";
        }
        if (io.micrometer.common.util.StringUtils.isBlank((String)title)) {
            title = "";
        }
        return PushPayload.newBuilder().setPlatform(Platform.android()).setAudience(Audience.alias((String[])new String[]{alais})).setNotification(Notification.android((String)msg, (String)title, null)).build();
    }

    private PushPayload buildPushObject_ios_alais_alertWithTitle(String alais, String msg) {
        if (io.micrometer.common.util.StringUtils.isBlank((String)msg)) {
            msg = "";
        }
        return PushPayload.newBuilder().setPlatform(Platform.ios()).setAudience(Audience.tag((String[])new String[]{alais})).setNotification(Notification.ios((Object)msg, null)).build();
    }

    private PushPayload buildPushObjectAliasAlertWithTitle(List<String> alias, String msg, String title) {
        if (io.micrometer.common.util.StringUtils.isBlank((String)msg)) {
            msg = "";
        }
        if (io.micrometer.common.util.StringUtils.isBlank((String)title)) {
            title = "";
        }
        return PushPayload.newBuilder().setPlatform(Platform.all()).setAudience(Audience.alias(alias)).setNotification(Notification.newBuilder().setAlert((Object)msg).addPlatformNotification((PlatformNotification)AndroidNotification.newBuilder().setTitle(title).build()).addPlatformNotification((PlatformNotification)IosNotification.newBuilder().incrBadge(1).build()).build()).setOptions(Options.newBuilder().setApnsProduction(apnsProduction).build()).build();
    }

    private PushPayload buildPushObject_android_and_ios(List<String> alais, String msg, String title, Integer badge, String channelId, MessageBody body) {
        Map<String, Map<String, String>> thirdPartyChannel = this.thirdPartyChannelMap();
        if (io.micrometer.common.util.StringUtils.isBlank((String)msg)) {
            msg = "";
        }
        if (io.micrometer.common.util.StringUtils.isBlank((String)title)) {
            title = "";
        }
        if (body == null) {
            body = new MessageBody();
        }
        Gson gson = new Gson();
        JsonParser paser = new JsonParser();
        JsonObject jsonMsgBody = paser.parse(gson.toJson((Object)body)).getAsJsonObject();
        if (io.micrometer.common.util.StringUtils.isNotBlank((String)channelId)) {
            return PushPayload.newBuilder().setPlatform(Platform.android_ios()).setAudience(Audience.alias(alais)).setNotification(Notification.newBuilder().setAlert((Object)msg).addPlatformNotification((PlatformNotification)((AndroidNotification.Builder)((AndroidNotification.Builder)((AndroidNotification.Builder)((AndroidNotification.Builder)((AndroidNotification.Builder)((AndroidNotification.Builder)AndroidNotification.newBuilder().setTitle(title).setLargeIcon(body.getUrl()).addCustom("uri_activity", "com.kedacom.ovopark.ui.PushClickActivity")).addCustom("uri_action", "com.kedacom.ovopark.ui.PushClickActivity")).addCustom("badge_add_num", (Number)1)).addCustom("badge_class", "com.kedacom.ovopark.ui.SplashActivity")).addCustom("channel_id", channelId)).addExtra("content", jsonMsgBody)).build()).addPlatformNotification((PlatformNotification)((IosNotification.Builder)IosNotification.newBuilder().incrBadge(badge != null ? badge : 1).setSound((Object)"default").setMutableContent(true).addExtra("content", jsonMsgBody)).build()).build()).setOptions(Options.newBuilder().setApnsProduction(apnsProduction).setThirdPartyChannel(thirdPartyChannel).build()).build();
        }
        return PushPayload.newBuilder().setPlatform(Platform.android_ios()).setAudience(Audience.alias(alais)).setNotification(Notification.newBuilder().setAlert((Object)msg).addPlatformNotification((PlatformNotification)((AndroidNotification.Builder)((AndroidNotification.Builder)((AndroidNotification.Builder)((AndroidNotification.Builder)((AndroidNotification.Builder)AndroidNotification.newBuilder().setTitle(title).setLargeIcon(body.getUrl()).addCustom("uri_activity", "com.kedacom.ovopark.ui.PushClickActivity")).addCustom("uri_action", "com.kedacom.ovopark.ui.PushClickActivity")).addCustom("badge_add_num", (Number)1)).addCustom("badge_class", "com.kedacom.ovopark.ui.SplashActivity")).addExtra("content", jsonMsgBody)).build()).addPlatformNotification((PlatformNotification)((IosNotification.Builder)IosNotification.newBuilder().incrBadge(badge != null ? badge : 1).setSound((Object)"default").setMutableContent(true).addExtra("content", jsonMsgBody)).build()).build()).setOptions(Options.newBuilder().setApnsProduction(apnsProduction).setThirdPartyChannel(thirdPartyChannel).build()).build();
    }

    public static Map<String, Map<String, String>> thirdPartyChannelMap() {
        HashMap<String, String> distributionMap = new HashMap<String, String>();
        distributionMap.put("importance", "NORMAL");
        distributionMap.put("category", "IM");
        HashMap<String, Map<String, String>> thirdPartyChannelMap = new HashMap<String, Map<String, String>>();
        thirdPartyChannelMap.put("huawei", distributionMap);
        return thirdPartyChannelMap;
    }

    private PushPayload buildPushObject_android_and_ios_face(List<String> alias, String msg, String title, Integer badge, MessageBody body) {
        Map<String, Map<String, String>> thirdPartyChannel = this.thirdPartyChannelMap();
        if (io.micrometer.common.util.StringUtils.isBlank((String)msg)) {
            msg = "";
        }
        if (io.micrometer.common.util.StringUtils.isBlank((String)title)) {
            title = "";
        }
        if (body == null) {
            body = new MessageBody();
        }
        Gson gson = new Gson();
        JsonParser paser = new JsonParser();
        JsonObject jsonMsgBody = paser.parse(gson.toJson((Object)body)).getAsJsonObject();
        return PushPayload.newBuilder().setPlatform(Platform.android_ios()).setAudience(Audience.alias(alias)).setNotification(Notification.newBuilder().setAlert((Object)msg).addPlatformNotification((PlatformNotification)((AndroidNotification.Builder)((AndroidNotification.Builder)((AndroidNotification.Builder)((AndroidNotification.Builder)((AndroidNotification.Builder)AndroidNotification.newBuilder().setTitle(title).setLargeIcon(body.getUrl()).addCustom("uri_activity", "com.kedacom.ovopark.ui.PushClickActivity")).addCustom("uri_action", "com.kedacom.ovopark.ui.PushClickActivity")).addCustom("badge_add_num", (Number)1)).addCustom("badge_class", "com.kedacom.ovopark.ui.SplashActivity")).addExtra("content", jsonMsgBody)).build()).addPlatformNotification((PlatformNotification)((IosNotification.Builder)IosNotification.newBuilder().incrBadge(badge != null ? badge : 1).setSound((Object)"default").setMutableContent(true).addExtra("content", jsonMsgBody)).build()).build()).setOptions(Options.newBuilder().setApnsProduction(apnsProduction).setThirdPartyChannel(thirdPartyChannel).build()).build();
    }

    public static PushPayload buildPushObject_messageWithExtras(List<String> alias, MessageObject msgParam) {
        return PushPayload.newBuilder().setPlatform(Platform.android_ios()).setAudience(Audience.newBuilder().addAudienceTarget(AudienceTarget.alias(alias)).build()).setMessage(Message.newBuilder().setMsgContent(JSONAccessor.impl().format((Object)msgParam)).build()).setOptions(Options.newBuilder().setApnsProduction(apnsProduction).build()).build();
    }
}

