/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.plugins.jg;

import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.stream.Stream;
import com.ovopark.kernel.shared.stream.Subscriber;
import com.ovopark.messagehub.plugins.bridge.JGMsg;
import com.ovopark.messagehub.plugins.bridge.KafkaReply;
import com.ovopark.messagehub.plugins.bridge.Msg;
import com.ovopark.messagehub.plugins.bridge.MsgContext;
import com.ovopark.messagehub.plugins.jg.JGSubscriber;
import com.ovopark.messagehub.plugins.kernel.ConditionOnSubs;
import com.ovopark.messagehub.plugins.kernel.service.SubsRateLimiterClient;
import com.ovopark.messagehub.redis.RateLimiter;
import com.ovopark.messagehub.sdk.model.Subs;
import com.ovopark.messagehub.sdk.model.internal.PluginsManager;
import com.ovopark.organize.sdk.api.JpushApi;
import jakarta.annotation.Resource;
import java.util.HashMap;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Component;

@ConditionOnSubs(value="JG")
@Component
public class JGInStream {
    private static final Logger log = LoggerFactory.getLogger(JGInStream.class);
    @Resource
    private JpushApi jpushApi;
    @Autowired
    private KafkaReply kafkaReply;
    @Autowired
    private SubsRateLimiterClient subsRateLimiterClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KafkaListener(concurrency="${messagehub.plugins.jg.consumerConcurrency:10}", properties={"partition.assignment.strategy:org.apache.kafka.clients.consumer.CooperativeStickyAssignor"}, topicPattern="messagehub-plugins-jg", containerFactory="mainKafkaContainerFactory")
    public void message(ConsumerRecord<String, Object> record) {
        String topic = record.topic();
        int partition = record.partition();
        long offset = record.offset();
        log.info(Thread.currentThread().hashCode() + ",topic: " + topic + ", partition: " + partition + ", offset: " + offset);
        Object value = record.value();
        JGMsg jgMsg = (JGMsg)JSONAccessor.impl().read((String)value, JGMsg.class);
        log.info(jgMsg.getMsgTraceId() + " from KAFKA: " + String.valueOf(value));
        RateLimiter rateLimiter = this.subsRateLimiterClient.get(Subs.JG);
        rateLimiter.acquire();
        String msgTraceId = jgMsg.getMsgTraceId();
        MDC.put((String)"requestId", (String)msgTraceId);
        MDC.put((String)"traceId", (String)msgTraceId);
        try {
            Stream.from((Object)new MsgContext(msgTraceId, (Msg)jgMsg)).doFinally(s -> {
                HashMap<String, String> meta = new HashMap<String, String>();
                meta.put("msgTraceId", msgTraceId);
                PluginsManager.getOrCreate().heartbeat(Subs.JG, meta);
            }).subscribe((Subscriber)new JGSubscriber(this.jpushApi, this.kafkaReply));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            MDC.remove((String)"requestId");
            MDC.remove((String)"traceId");
        }
    }
}

