/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.plugins.jg;

import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.stream.CoreSubscriber;
import com.ovopark.messagehub.plugins.bridge.JGMsg;
import com.ovopark.messagehub.plugins.bridge.KafkaReply;
import com.ovopark.messagehub.plugins.bridge.MsgContext;
import com.ovopark.messagehub.plugins.bridge.jg.JGMessage;
import com.ovopark.messagehub.plugins.bridge.reply.MessageReply;
import com.ovopark.messagehub.plugins.jg.JiguangPushUtil;
import com.ovopark.messagehub.sdk.model.MessageBody;
import com.ovopark.messagehub.sdk.model.Subs;
import com.ovopark.messagehub.sdk.model.direct.jg.JPushAccount;
import com.ovopark.messagehub.sdk.model.direct.jg.PushNotificationParameter;
import com.ovopark.organize.common.base.BaseResult;
import com.ovopark.organize.common.model.mo.JpushMo;
import com.ovopark.organize.sdk.api.JpushApi;
import io.micrometer.common.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JGSubscriber
extends CoreSubscriber<MsgContext<JGMsg>> {
    private static final Logger log = LoggerFactory.getLogger(JGSubscriber.class);
    private final JpushApi jpushApi;
    private final KafkaReply kafkaReply;

    public JGSubscriber(JpushApi jpushApi, KafkaReply kafkaReply) {
        this.jpushApi = jpushApi;
        this.kafkaReply = kafkaReply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNext(MsgContext<JGMsg> msgMsgContext) {
        JGMsg msg = (JGMsg)msgMsgContext.msg();
        JGMessage payload = (JGMessage)msg.getBody();
        List userIds = payload.getUserIds();
        Integer messageType = payload.getMessageType();
        String channelId = payload.getChannelId();
        MessageBody body = payload.getMessageBody();
        if (body != null) {
            int type = body.getType();
            channelId = JGSubscriber.determineChannelId(type);
        }
        MessageReply success = MessageReply.success((Subs)Subs.JG, (String)msg.getMsgTraceId(), (String)msg.getTaskId(), (String[])new String[0]);
        MessageReply fail = MessageReply.fail((Subs)Subs.JG, (String)msg.getMsgTraceId(), (String)msg.getTaskId(), (String[])new String[0]);
        ArrayList sumUserIds = new ArrayList(userIds);
        try {
            BaseResult pushesData = this.jpushApi.getPushesByUserIds(userIds);
            if (pushesData != null && !pushesData.getIsError().booleanValue()) {
                List pushes = (List)pushesData.getData();
                Map<String, List<JpushMo>> pushMap = pushes.stream().collect(Collectors.groupingBy(JpushMo::getAppKey));
                for (Map.Entry<String, List<JpushMo>> pushEntry : pushMap.entrySet()) {
                    String masterSecret = JPushAccount.getMasterSecret((String)pushEntry.getKey());
                    if (!StringUtils.isNotBlank((String)masterSecret)) continue;
                    Map<String, List<JpushMo>> langPushMap = pushEntry.getValue().stream().collect(Collectors.groupingBy(JpushMo::getLang));
                    for (Map.Entry<String, List<JpushMo>> langPushEntry : langPushMap.entrySet()) {
                        try {
                            Locale locale = JGSubscriber.getLocaleFromLang(langPushEntry.getKey());
                            JGMessage.LC lc = (JGMessage.LC)payload.getLcMap().get(locale);
                            String titleStr = lc.getTitle();
                            String messageStr = lc.getContent();
                            PushNotificationParameter pushParam = new PushNotificationParameter();
                            pushParam.setAppKey(pushEntry.getKey());
                            pushParam.setSecret(masterSecret);
                            pushParam.setBody(body);
                            pushParam.setMessage(messageStr);
                            pushParam.setTitle(titleStr);
                            List alias = langPushEntry.getValue().stream().map(JpushMo::getPushAlias).collect(Collectors.toList());
                            pushParam.setPushAlias(alias);
                            pushParam.setMessageType(messageType);
                            pushParam.setChannelId(channelId);
                            JiguangPushUtil.sendPush(pushParam, false);
                            for (JpushMo jpushMo : langPushEntry.getValue()) {
                                Integer userId = jpushMo.getUserId();
                                success.append(msg.msgIdByUser(userId.intValue()));
                                sumUserIds.remove(userId);
                            }
                            log.info("JG SDK ,OK");
                        }
                        catch (Exception e) {
                            log.error(e.getMessage(), (Throwable)e);
                            for (JpushMo jpushMo : langPushEntry.getValue()) {
                                Integer userId = jpushMo.getUserId();
                                fail.append(msg.msgIdByUser(userId.intValue()));
                                sumUserIds.remove(userId);
                            }
                        }
                    }
                }
            }
        }
        finally {
            this.kafkaReply.reply("messagehub-plugins-reply", success, msgMsgContext);
            if (Util.isNotEmpty(sumUserIds)) {
                sumUserIds.forEach(u -> fail.append(msg.msgIdByUser(u.intValue())));
                fail.setDesc(fail.getDesc() + ", no process, no app key?");
            }
            this.kafkaReply.reply("messagehub-plugins-reply", fail, msgMsgContext);
        }
    }

    public static String determineChannelId(Integer type) {
        switch (type) {
            case 18: 
            case 63: 
            case 64: 
            case 85: 
            case 95: 
            case 98: 
            case 99: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 111: 
            case 112: 
            case 115: 
            case 124: 
            case 125: {
                return "110141";
            }
            case 7: 
            case 21: 
            case 31: 
            case 121: {
                return "110143";
            }
            case 110143: {
                return "110142";
            }
            case 8: 
            case 12: 
            case 13: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 92: 
            case 100: {
                return "110140";
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 56: 
            case 70: 
            case 72: 
            case 82: 
            case 93: 
            case 94: 
            case 97: 
            case 104: 
            case 105: 
            case 122: {
                return "110139";
            }
            case 87: 
            case 88: 
            case 89: {
                return "110138";
            }
            case 37: 
            case 49: {
                return "110137";
            }
        }
        return null;
    }

    public static Locale getLocaleFromLang(String lang) {
        if (StringUtils.isEmpty((String)lang) || "SIMPLIFIED_CHINESE".equalsIgnoreCase(lang)) {
            return Locale.SIMPLIFIED_CHINESE;
        }
        switch (lang = lang.toUpperCase()) {
            case "FRENCH": {
                return Locale.FRANCE;
            }
            case "GERMAN": {
                return Locale.GERMANY;
            }
            case "ITALIAN": {
                return Locale.ITALY;
            }
            case "JAPANESE": {
                return Locale.JAPAN;
            }
            case "KOREAN": {
                return Locale.KOREA;
            }
            case "ENGLISH": {
                return Locale.US;
            }
            case "TAIWAN": {
                return Locale.TAIWAN;
            }
            case "TRADITIONAL_CHINESE": {
                return Locale.TRADITIONAL_CHINESE;
            }
        }
        return Locale.SIMPLIFIED_CHINESE;
    }
}

