/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.plugins.jg;

import cn.jiguang.sdk.bean.device.DeviceSetParam;
import cn.jiguang.sdk.bean.push.PushSendParam;
import cn.jiguang.sdk.bean.push.PushSendResult;
import cn.jiguang.sdk.bean.push.audience.Audience;
import cn.jiguang.sdk.bean.push.message.notification.NotificationMessage;
import cn.jiguang.sdk.bean.push.options.Options;
import cn.jiguang.sdk.client.DeviceClient;
import cn.jiguang.sdk.client.PushClient;
import cn.jiguang.sdk.codec.ApiDecoder;
import cn.jiguang.sdk.codec.ApiEncoder;
import cn.jiguang.sdk.codec.ApiErrorDecoder;
import cn.jiguang.sdk.enums.platform.Platform;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ovopark.kernel.shared.Util;
import com.ovopark.messagehub.plugins.kernel.ConditionOnSubs;
import com.ovopark.messagehub.sdk.model.MessageBody;
import com.ovopark.messagehub.sdk.model.direct.jg.PushNotificationParameter;
import feign.Client;
import feign.Feign;
import feign.Logger;
import feign.RequestInterceptor;
import feign.auth.BasicAuthRequestInterceptor;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.slf4j.Slf4jLogger;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@ConditionOnSubs(value="JG")
@Configuration
public class JiguangPushUtil {
    private static final Logger log = LoggerFactory.getLogger(JiguangPushUtil.class);
    @Value(value="${jpush.apnsProduction:1}")
    private String jpushapnsProduction;
    private static boolean apnsProduction = true;
    private static JiguangPushUtil instance = null;
    private static String host = "https://device.jpush.cn";
    private static Logger.Level loggerLevel = Logger.Level.BASIC;

    @PostConstruct
    public void setApnsProduction() {
        log.info("jpushapnsProduction:" + this.jpushapnsProduction.trim().equals("1"));
        apnsProduction = this.jpushapnsProduction.trim().equals("1");
        log.info("got jpushapnsProduction value: " + this.jpushapnsProduction + ". set apnsProduction:" + apnsProduction);
    }

    public static void registerDeviceAlias(String registrationId, String alias, String appKey, String masterSecret) {
        OkHttpClient.Builder delegateBuilder = new OkHttpClient().newBuilder();
        DeviceClient deviceClient = (DeviceClient)Feign.builder().client((Client)new feign.okhttp.OkHttpClient(delegateBuilder.build())).requestInterceptor((RequestInterceptor)new BasicAuthRequestInterceptor(appKey, masterSecret)).encoder((Encoder)new ApiEncoder()).decoder((Decoder)new ApiDecoder()).errorDecoder((ErrorDecoder)new ApiErrorDecoder()).logger((feign.Logger)new Slf4jLogger()).logLevel(loggerLevel).target(DeviceClient.class, "https://device.jpush.cn");
        DeviceSetParam param = new DeviceSetParam();
        param.setAlias(alias);
        deviceClient.setDevice(registrationId, param);
    }

    public static void sendPush(PushNotificationParameter parameter, boolean tdr) {
        if (instance == null) {
            instance = new JiguangPushUtil();
        }
        if (Util.isNotEmpty((CharSequence)parameter.getSecret())) {
            OkHttpClient.Builder delegateBuilder = new OkHttpClient().newBuilder();
            PushClient pushClient = (PushClient)Feign.builder().client((Client)new feign.okhttp.OkHttpClient(delegateBuilder.build())).requestInterceptor((RequestInterceptor)new BasicAuthRequestInterceptor(parameter.getAppKey(), parameter.getSecret())).encoder((Encoder)new ApiEncoder()).decoder((Decoder)new ApiDecoder()).errorDecoder((ErrorDecoder)new ApiErrorDecoder()).logger((feign.Logger)new Slf4jLogger()).logLevel(loggerLevel).target(PushClient.class, "https://api.jpush.cn");
            PushSendParam param = new PushSendParam();
            if (Util.isEmpty((CharSequence)parameter.getMessage())) {
                parameter.setMessage("");
            }
            if (Util.isEmpty((CharSequence)parameter.getTitle())) {
                parameter.setTitle("");
            }
            if (parameter.getBody() == null) {
                parameter.setBody(new MessageBody());
            }
            HashMap jsonMsgBody = (HashMap)new ObjectMapper().convertValue((Object)parameter.getBody(), HashMap.class);
            jsonMsgBody.entrySet().removeIf(entry -> entry.getValue() == null);
            NotificationMessage.Android android = new NotificationMessage.Android();
            android.setAlert(parameter.getMessage());
            android.setTitle(parameter.getTitle());
            android.setLargeIcon(parameter.getBody().getUrl());
            if (tdr) {
                android.setUriAction("com.ovopark.mysteryshopping.ui.activity.PushClickActivity");
                android.setUriActivity("com.ovopark.mysteryshopping.ui.activity.PushClickActivity");
                android.setBadgeClass("com.ovopark.mysteryshopping.ui.activity.SplashActivity");
            } else {
                android.setUriAction("com.kedacom.ovopark.ui.PushClickActivity");
                android.setUriActivity("com.kedacom.ovopark.ui.PushClickActivity");
                android.setBadgeClass("com.kedacom.ovopark.ui.SplashActivity");
            }
            android.setBadgeAddNumber(Integer.valueOf(1));
            if (Util.isNotEmpty((CharSequence)parameter.getChannelId())) {
                android.setChannelId(parameter.getChannelId());
            }
            NotificationMessage.IOS iOS = new NotificationMessage.IOS();
            iOS.setMutableContent(Boolean.valueOf(true));
            iOS.setSound((Object)"default");
            iOS.setBadge("+1");
            NotificationMessage.HMOS hmos = new NotificationMessage.HMOS();
            hmos.setAlert(parameter.getMessage());
            hmos.setTitle(parameter.getTitle());
            hmos.setLargeIcon(parameter.getBody().getUrl());
            hmos.setBadgeAddNumber(Integer.valueOf(1));
            hmos.setCategory("IM");
            HashMap<String, HashMap> extrasMap = new HashMap<String, HashMap>();
            extrasMap.put("content", jsonMsgBody);
            android.setExtras(extrasMap);
            iOS.setExtras(extrasMap);
            hmos.setExtras(extrasMap);
            NotificationMessage notificationMessage = new NotificationMessage();
            notificationMessage.setAlert(parameter.getMessage());
            notificationMessage.setAndroid(android);
            notificationMessage.setIos(iOS);
            notificationMessage.setHmos(hmos);
            param.setNotification(notificationMessage);
            Audience audience = new Audience();
            audience.setAliasList(parameter.getPushAlias());
            param.setAudience((Object)audience);
            param.setPlatform(Arrays.asList(Platform.android, Platform.ios, Platform.hmos));
            Options options = new Options();
            Map<String, Object> thirdPartyChannel = JiguangPushUtil.thirdPartyChannelMap();
            options.setThirdPartyChannel(thirdPartyChannel);
            options.setApnsProduction(Boolean.valueOf(apnsProduction));
            param.setOptions(options);
            PushSendResult result = null;
            try {
                result = pushClient.send(param);
                log.info("result:{}", (Object)result);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw Util.convert2RuntimeException((Throwable)e);
            }
        } else {
            log.info("jpush key-secret not configged, app key:" + parameter.getAppKey());
        }
    }

    public static Map<String, Object> thirdPartyChannelMap() {
        HashMap<String, String> distributionMap = new HashMap<String, String>();
        distributionMap.put("importance", "NORMAL");
        distributionMap.put("category", "IM");
        HashMap<String, Object> thirdPartyChannelMap = new HashMap<String, Object>();
        thirdPartyChannelMap.put("huawei", distributionMap);
        return thirdPartyChannelMap;
    }

    public static void main(String[] args) {
        PushNotificationParameter param = new PushNotificationParameter();
        param.setAppKey("f76b18fee1b4d74b866e8897");
        param.setSecret("6f7cf0926afb1c085de9d52c");
        param.setBadge(Integer.valueOf(1));
        param.setMessage("this is message");
        param.setTitle("this is title");
        ArrayList<String> alias = new ArrayList<String>();
        alias.add("196e35f7e14b0c428dc_5819b777b8c9eab8");
        param.setPushAlias(alias);
        JiguangPushUtil.sendPush(param, false);
    }
}

