/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.plugins.jg;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.eatthepath.pushy.apns.ApnsClient;
import com.eatthepath.pushy.apns.ApnsClientBuilder;
import com.eatthepath.pushy.apns.ApnsPushNotification;
import com.eatthepath.pushy.apns.auth.ApnsSigningKey;
import com.eatthepath.pushy.apns.util.SimpleApnsPayloadBuilder;
import com.eatthepath.pushy.apns.util.SimpleApnsPushNotification;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ovopark.messagehub.sdk.model.direct.jg.PushNotificationParameter;
import java.io.File;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ResourceUtils;

public class ApnsPushTest {
    private static final Logger log = LoggerFactory.getLogger(ApnsPushTest.class);
    private static String jpushapnsProduction = "0";
    private static boolean apnsProduction = true;
    private static ApnsClient apnsClient = null;
    private static Map<String, String> pushBundles = new HashMap<String, String>();

    public static void push(PushNotificationParameter parameter) {
        log.info("apns push: " + JSON.toJSONString((Object)parameter));
        String bundle = pushBundles.get(parameter.getAppKey());
        if (StringUtils.isNotBlank((CharSequence)bundle)) {
            HashMap jsonMsgBody = (HashMap)new ObjectMapper().convertValue((Object)parameter.getBody(), HashMap.class);
            jsonMsgBody.entrySet().removeIf(entry -> entry.getValue() == null);
            String payload = new SimpleApnsPayloadBuilder().setAlertTitle(parameter.getTitle()).setAlertBody(parameter.getMessage()).addCustomProperty("content", (Object)jsonMsgBody).build();
            for (String pushAlias : parameter.getPushAlias()) {
                SimpleApnsPushNotification pushNotification = new SimpleApnsPushNotification(pushAlias, bundle, payload);
                try {
                    apnsClient.sendNotification((ApnsPushNotification)pushNotification).thenAccept(response -> log.info("apns push. payload:{}, result:{}", (Object)payload, (Object)JSON.toJSONString((Object)response)));
                }
                catch (Exception e) {
                    log.error("apns push. payload:{}, error:{}", (Object)payload, (Object)e.getMessage());
                }
            }
        } else {
            log.error("apns push. appKey:{} not found", (Object)parameter.getAppKey());
        }
    }

    public static void main(String[] args) {
        PushNotificationParameter parameter = (PushNotificationParameter)JSON.parseObject((String)"{\"appKey\":\"WDZ\",\"body\":{\"id\":94755,\"problemType\":6,\"subId\":6,\"type\":4,\"userType\":0},\"channelId\":\"110139\",\"message\":\"\u95ee\u9898\u590d\u68c0:\u7248\u672c\u8fed\u4ee3\u6d4b\u8bd5-\u7f51\u7ba1\u6444\u50cf\u5934-\u5f90\u661f-11\",\"messageType\":1,\"pushAlias\":[\"cf356d104595ba2f5381f1e577dffb8570adfc351cc648e4eb690c39cc5358bd\"],\"title\":\"\"}", PushNotificationParameter.class);
        ApnsPushTest.push(parameter);
    }

    static {
        log.info("jpushapnsProduction:" + jpushapnsProduction.trim().equals("1"));
        apnsProduction = jpushapnsProduction.trim().equals("1");
        log.info("got jpushapnsProduction value: " + jpushapnsProduction + ". set apnsProduction:" + apnsProduction);
        try {
            apnsClient = apnsProduction ? new ApnsClientBuilder().setApnsServer("api.push.apple.com").setSigningKey(ApnsSigningKey.loadFromPkcs8File((File)ResourceUtils.getFile((String)"classpath:AuthKey_Product.p8"), (String)"MTGQCB5B3L", (String)"HXRA6MGQLJ")).build() : new ApnsClientBuilder().setApnsServer("api.sandbox.push.apple.com").setSigningKey(ApnsSigningKey.loadFromPkcs8File((File)ResourceUtils.getFile((String)"classpath:AuthKey_Develop.p8"), (String)"MTGQCB5B3L", (String)"B4MCAZTS8X")).build();
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException e) {
            log.error("ApnsPushUtil init", (Throwable)e);
        }
        pushBundles.put("WDZ", "com.wandianzhang.wdz");
        pushBundles.put("OP", "com.wandianzhang.OPRetail");
        pushBundles.put("MCYP", "com.wandianzhang.MCYP");
        pushBundles.put("TJ", "com.taiji.wandianzhang");
        pushBundles.put("HJXD", "com.wandianzhang.hjxd");
        pushBundles.put("LYF", "com.wandianzhang.lyf");
        pushBundles.put("LBX", "com.lbxdrugs.wandianzhang");
        pushBundles.put("ZHTY", "com.wangxiaobao.wisdomeye");
        pushBundles.put("RLTY", "com.wandianzhang.REYES");
        pushBundles.put("YM", "com.wandianzhang.YM");
        pushBundles.put("JHDX", "com.wandianzhang.JHDX");
        pushBundles.put("KLTD", "com.wandianzhang.KLTD");
        pushBundles.put("ZYY", "com.wandianzhang.ovopark");
        pushBundles.put("SPS", "com.wandianzhang.SPS");
        pushBundles.put("HB", "com.wandianzhang.haiboss");
        pushBundles.put("HKD", "com.wandianzhang.HKD");
        pushBundles.put("YQB", "com.wandianzhang.YQB");
    }
}

