/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.plugins.jg;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.getui.push.v2.sdk.api.PushApi;
import com.getui.push.v2.sdk.common.ApiResult;
import com.getui.push.v2.sdk.dto.req.Audience;
import com.getui.push.v2.sdk.dto.req.message.PushChannel;
import com.getui.push.v2.sdk.dto.req.message.PushDTO;
import com.getui.push.v2.sdk.dto.req.message.PushMessage;
import com.getui.push.v2.sdk.dto.req.message.android.AndroidDTO;
import com.getui.push.v2.sdk.dto.req.message.android.GTNotification;
import com.getui.push.v2.sdk.dto.req.message.android.ThirdNotification;
import com.getui.push.v2.sdk.dto.req.message.android.Ups;
import com.ovopark.kernel.shared.Util;
import com.ovopark.messagehub.plugins.jg.GetuiPushAccount;
import com.ovopark.messagehub.sdk.model.MessageBody;
import com.ovopark.messagehub.sdk.model.direct.jg.PushNotificationParameter;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class GetuiPushUtil {
    private static final Logger log = LoggerFactory.getLogger(GetuiPushUtil.class);
    private static GetuiPushUtil instance = null;

    public static void push(PushApi pushApi, PushNotificationParameter parameter) {
        log.info("getui push: " + JSON.toJSONString((Object)parameter));
        if (pushApi != null) {
            if (Util.isEmpty((CharSequence)parameter.getMessage())) {
                parameter.setMessage("");
            }
            if (Util.isEmpty((CharSequence)parameter.getTitle())) {
                parameter.setTitle("");
            }
            if (parameter.getBody() == null) {
                parameter.setBody(new MessageBody());
            }
            HashMap jsonMsgBody = (HashMap)new ObjectMapper().convertValue((Object)parameter.getBody(), HashMap.class);
            jsonMsgBody.entrySet().removeIf(entry -> entry.getValue() == null);
            HashMap<String, HashMap> extrasMap = new HashMap<String, HashMap>();
            extrasMap.put("content", jsonMsgBody);
            PushDTO pushDTO = new PushDTO();
            pushDTO.setRequestId("" + System.currentTimeMillis());
            PushMessage pushMessage = new PushMessage();
            pushDTO.setPushMessage(pushMessage);
            GTNotification notification = new GTNotification();
            pushMessage.setNotification(notification);
            notification.setTitle(parameter.getTitle());
            notification.setBody(parameter.getMessage());
            notification.setClickType("payload");
            notification.setPayload(JSON.toJSONString((Object)parameter.getBody()));
            PushChannel pushChannel = new PushChannel();
            pushDTO.setPushChannel(pushChannel);
            AndroidDTO androidDTO = new AndroidDTO();
            Ups ups = new Ups();
            ThirdNotification thirdNotification = new ThirdNotification();
            thirdNotification.setTitle(parameter.getTitle());
            thirdNotification.setBody(parameter.getMessage());
            thirdNotification.setClickType("startapp");
            ups.setNotification(thirdNotification);
            ups.setOptions(GetuiPushUtil.thirdPartyChannelMap(parameter.getChannelId()));
            androidDTO.setUps(ups);
            pushChannel.setAndroid(androidDTO);
            Audience audience = new Audience();
            audience.setCid(parameter.getPushAlias());
            pushDTO.setAudience((Object)audience);
            log.info("getui push params:" + JSON.toJSONString((Object)pushDTO));
            ApiResult apiResult = pushApi.pushToSingleByCid(pushDTO);
            if (apiResult.isSuccess()) {
                log.info("getui push code:" + apiResult.getCode() + ", msg: " + apiResult.getMsg() + ", data: " + String.valueOf(apiResult.getData()));
            } else {
                log.info("getui push result:{}", (Object)JSON.toJSONString((Object)apiResult));
            }
        } else {
            log.info("getui key-secret not configged, app key:" + parameter.getAppKey());
        }
    }

    public static Map<String, Map<String, Object>> thirdPartyChannelMap(String channelId) {
        HashMap<String, Object> huaweiDistributionMap = new HashMap<String, Object>();
        huaweiDistributionMap.put("/message/android/notification/badge/class", "com.kedacom.ovopark.ui.SplashActivity");
        huaweiDistributionMap.put("/message/android/notification/badge/add_num", 1);
        huaweiDistributionMap.put("/message/android/category", "IM");
        HashMap<String, Object> oppoDistributionMap = new HashMap<String, Object>();
        if (Util.isNotEmpty((CharSequence)channelId)) {
            oppoDistributionMap.put("/channel_id", channelId);
        }
        oppoDistributionMap.put("/category", "IM");
        oppoDistributionMap.put("/notify_level", 16);
        HashMap<String, Map<String, Object>> thirdPartyChannelMap = new HashMap<String, Map<String, Object>>();
        thirdPartyChannelMap.put("HW", huaweiDistributionMap);
        thirdPartyChannelMap.put("OP", oppoDistributionMap);
        return thirdPartyChannelMap;
    }

    public static void main(String[] args) {
        PushApi pushApi = GetuiPushAccount.getPushApi("2Z3JEPQIFm7u19g8hgm2r1");
        PushNotificationParameter parameter = (PushNotificationParameter)JSONObject.parseObject((String)"{\"appKey\":\"2Z3JEPQIFm7u19g8hgm2r1\",\"body\":{\"faceType\":\"\",\"ids\":\"\",\"jsonContent\":\"\",\"jsonStr\":\"\",\"openVibrate\":\"\",\"openVoice\":\"\",\"storePlanJson\":\"\",\"taskJson\":\"{\\\"endTime\\\":1737438959000,\\\"id\\\":89031,\\\"startTime\\\":1737352500000,\\\"taskId\\\":89031,\\\"taskName\\\":\\\"\u8054\u8c03\\\",\\\"taskUserStatus\\\":1}\",\"titleStr\":\"\",\"type\":37,\"url\":\"\"},\"channelId\":\"110137\",\"message\":\"\u4efb\u52a1(\u8054\u8c03)\u88ab\u7528\u6237android2\u4fee\u6539\",\"messageType\":1,\"pushAlias\":[\"203531d28edff2508ecc6e5874953f53\"],\"title\":\"\u4efb\u52a1\u4fee\u6539\u901a\u77e5\"}", PushNotificationParameter.class);
        GetuiPushUtil.push(pushApi, parameter);
    }
}

