/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.plugins.jg;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.getui.push.v2.sdk.api.PushApi;
import com.getui.push.v2.sdk.common.ApiResult;
import com.getui.push.v2.sdk.dto.req.Audience;
import com.getui.push.v2.sdk.dto.req.AudienceDTO;
import com.getui.push.v2.sdk.dto.req.Settings;
import com.getui.push.v2.sdk.dto.req.Strategy;
import com.getui.push.v2.sdk.dto.req.message.PushChannel;
import com.getui.push.v2.sdk.dto.req.message.PushDTO;
import com.getui.push.v2.sdk.dto.req.message.PushMessage;
import com.getui.push.v2.sdk.dto.req.message.android.AndroidDTO;
import com.getui.push.v2.sdk.dto.req.message.android.GTNotification;
import com.getui.push.v2.sdk.dto.req.message.android.ThirdNotification;
import com.getui.push.v2.sdk.dto.req.message.android.Ups;
import com.getui.push.v2.sdk.dto.req.message.ios.Alert;
import com.getui.push.v2.sdk.dto.req.message.ios.Aps;
import com.getui.push.v2.sdk.dto.req.message.ios.IosDTO;
import com.getui.push.v2.sdk.dto.res.TaskIdDTO;
import com.ovopark.kernel.shared.Util;
import com.ovopark.messagehub.plugins.jg.GetuiPushAccount;
import com.ovopark.messagehub.sdk.model.MessageBody;
import com.ovopark.messagehub.sdk.model.direct.jg.PushNotificationParameter;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class GetuiPushUtil {
    private static final Logger log = LoggerFactory.getLogger(GetuiPushUtil.class);
    private static GetuiPushUtil instance = null;

    /*
     * Enabled aggressive block sorting
     */
    public static void push(PushApi pushApi, PushNotificationParameter parameter) {
        String getuiId = UUID.randomUUID().toString();
        log.info("getui push: getuiId:{} parameter:{}", (Object)getuiId, (Object)JSON.toJSONString((Object)parameter));
        if (pushApi == null) {
            log.info("getui key-secret not configged, getuiId:{},app key:{}", (Object)getuiId, (Object)parameter.getAppKey());
            return;
        }
        if (Util.isEmpty((CharSequence)parameter.getMessage())) {
            parameter.setMessage("");
        }
        if (Util.isEmpty((CharSequence)parameter.getTitle())) {
            parameter.setTitle("");
        }
        if (parameter.getBody() == null) {
            parameter.setBody(new MessageBody());
        }
        HashMap jsonMsgBody = (HashMap)new ObjectMapper().convertValue((Object)parameter.getBody(), HashMap.class);
        jsonMsgBody.entrySet().removeIf(entry -> entry.getValue() == null);
        HashMap<String, HashMap> extrasMap = new HashMap<String, HashMap>();
        extrasMap.put("content", jsonMsgBody);
        PushDTO pushDTO = new PushDTO();
        Settings settings = new Settings();
        Strategy strategy = new Strategy();
        strategy.setIos(Integer.valueOf(2));
        settings.setStrategy(strategy);
        pushDTO.setSettings(settings);
        pushDTO.setRequestId("" + System.currentTimeMillis());
        PushMessage pushMessage = new PushMessage();
        pushDTO.setPushMessage(pushMessage);
        GTNotification notification = new GTNotification();
        pushMessage.setNotification(notification);
        notification.setTitle(parameter.getTitle());
        notification.setBody(parameter.getMessage());
        notification.setClickType("payload");
        notification.setPayload(JSON.toJSONString((Object)parameter.getBody()));
        PushChannel pushChannel = new PushChannel();
        pushDTO.setPushChannel(pushChannel);
        AndroidDTO androidDTO = new AndroidDTO();
        Ups ups = new Ups();
        ThirdNotification thirdNotification = new ThirdNotification();
        thirdNotification.setTitle(parameter.getTitle());
        thirdNotification.setBody(parameter.getMessage());
        thirdNotification.setClickType("startapp");
        ups.setNotification(thirdNotification);
        ups.setOptions(GetuiPushUtil.thirdPartyChannelMap(parameter.getChannelId()));
        androidDTO.setUps(ups);
        pushChannel.setAndroid(androidDTO);
        IosDTO iosDTO = new IosDTO();
        Aps aps = new Aps();
        Alert alert = new Alert();
        alert.setTitle(parameter.getTitle());
        alert.setBody(parameter.getMessage());
        aps.setAlert(alert);
        iosDTO.setAps(aps);
        iosDTO.setPayload(JSON.toJSONString((Object)parameter.getBody()));
        iosDTO.setType("notify");
        iosDTO.setAutoBadge("+1");
        pushChannel.setIos(iosDTO);
        ApiResult createMsgResult = pushApi.createMsg(pushDTO);
        if (createMsgResult.isSuccess() && createMsgResult.getData() != null) {
            AudienceDTO audienceDTO = new AudienceDTO();
            String taskId = ((TaskIdDTO)createMsgResult.getData()).getTaskId();
            audienceDTO.setTaskid(taskId);
            Audience batchAudience = new Audience();
            batchAudience.setCid(parameter.getPushAlias());
            audienceDTO.setAudience(batchAudience);
            log.info("getui pushParams getuiId:{},pushDTO:{},audienceDTO:{}", new Object[]{getuiId, JSON.toJSONString((Object)pushDTO), JSON.toJSONString((Object)audienceDTO)});
            ApiResult pushResult = pushApi.pushListByCid(audienceDTO);
            if (pushResult.isSuccess()) {
                log.info("getui push ok getuiId:{},code:{}", (Object)getuiId, (Object)(pushResult.getCode() + ", msg: " + pushResult.getMsg() + ", data: " + String.valueOf(pushResult.getData())));
                return;
            }
            log.info("getui push error getuiId:{},params:{},result:{}", new Object[]{getuiId, JSON.toJSONString((Object)audienceDTO), JSON.toJSONString((Object)pushResult)});
            throw new RuntimeException("getui push error getuiId:" + getuiId + ",audienceDTO:" + JSON.toJSONString((Object)audienceDTO) + ",result:" + JSON.toJSONString((Object)pushResult));
        }
        log.info("getui createMsg error getuiId:{},params:{},result:{}", new Object[]{getuiId, JSON.toJSONString((Object)pushDTO), JSON.toJSONString((Object)createMsgResult)});
        throw new RuntimeException("getui push error getuiId:" + getuiId + ",result:" + JSON.toJSONString((Object)createMsgResult));
    }

    public static Map<String, Map<String, Object>> thirdPartyChannelMap(String channelId) {
        HashMap<String, Object> huaweiDistributionMap = new HashMap<String, Object>();
        huaweiDistributionMap.put("/message/android/notification/badge/class", "com.kedacom.ovopark.ui.SplashActivity");
        huaweiDistributionMap.put("/message/android/notification/badge/add_num", 1);
        huaweiDistributionMap.put("/message/android/category", "IM");
        huaweiDistributionMap.put("/message/android/receipt_id", "RCP2056FC70");
        HashMap<String, Object> oppoDistributionMap = new HashMap<String, Object>();
        if (Util.isNotEmpty((CharSequence)channelId)) {
            oppoDistributionMap.put("/channel_id", channelId);
        }
        oppoDistributionMap.put("/category", "IM");
        oppoDistributionMap.put("/notify_level", 16);
        HashMap<String, String> xiaomiDistributionMap = new HashMap<String, String>();
        if (Util.isNotEmpty((CharSequence)channelId)) {
            xiaomiDistributionMap.put("/extra.channel_id", channelId);
        }
        HashMap<String, Map<String, Object>> thirdPartyChannelMap = new HashMap<String, Map<String, Object>>();
        thirdPartyChannelMap.put("HW", huaweiDistributionMap);
        thirdPartyChannelMap.put("OP", oppoDistributionMap);
        thirdPartyChannelMap.put("XM", xiaomiDistributionMap);
        return thirdPartyChannelMap;
    }

    public static void main(String[] args) {
        PushApi pushApi = GetuiPushAccount.getPushApi("4MW5eGbyWiAcVARXUSIBI5");
        PushNotificationParameter parameter = (PushNotificationParameter)JSONObject.parseObject((String)"{\"appKey\":\"2Z3JEPQIFm7u19g8hgm2r1\",\"body\":{\"faceType\":\"\",\"ids\":\"\",\"jsonContent\":\"\",\"jsonStr\":\"\",\"openVibrate\":\"\",\"openVoice\":\"\",\"storePlanJson\":\"\",\"taskJson\":\"{\\\"endTime\\\":1737438959000,\\\"id\\\":89031,\\\"startTime\\\":1737352500000,\\\"taskId\\\":89031,\\\"taskName\\\":\\\"\u8054\u8c03\\\",\\\"taskUserStatus\\\":1}\",\"titleStr\":\"\",\"type\":37,\"url\":\"\"},\"channelId\":\"110142\",\"message\":\"\u4efb\u52a1(\u8054\u8c03)\u88ab\u7528\u6237android2\u4fee\u6539\",\"messageType\":1,\"pushAlias\":[\"b3250db2caba74ccd781a0ffc293f9a5\"],\"title\":\"lj_ios\u4efb\u52a1\u4fee\u6539\u901a\u77e5cidList2\"}", PushNotificationParameter.class);
        System.out.println(JSON.toJSONString((Object)parameter));
        GetuiPushUtil.push(pushApi, parameter);
    }
}

