/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.plugins.jg;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.eatthepath.pushy.apns.ApnsClient;
import com.eatthepath.pushy.apns.ApnsClientBuilder;
import com.eatthepath.pushy.apns.ApnsPushNotification;
import com.eatthepath.pushy.apns.auth.ApnsSigningKey;
import com.eatthepath.pushy.apns.util.SimpleApnsPayloadBuilder;
import com.eatthepath.pushy.apns.util.SimpleApnsPushNotification;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ovopark.messagehub.sdk.model.direct.jg.PushNotificationParameter;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ApnsPushUtil {
    private static final Logger log = LoggerFactory.getLogger(ApnsPushUtil.class);
    @Value(value="${jpush.apnsProduction:1}")
    private String jpushapnsProduction;
    private static boolean apnsProduction = true;
    private static ApnsClient apnsClient = null;
    private static Map<String, String> pushBundles = new HashMap<String, String>();

    @PostConstruct
    public void setApnsProduction() {
        log.info("jpushapnsProduction:" + this.jpushapnsProduction.trim().equals("1"));
        apnsProduction = this.jpushapnsProduction.trim().equals("1");
        log.info("got jpushapnsProduction value: " + this.jpushapnsProduction + ". set apnsProduction:" + apnsProduction);
        try {
            apnsClient = apnsProduction ? new ApnsClientBuilder().setApnsServer("api.push.apple.com").setSigningKey(ApnsSigningKey.loadFromInputStream((InputStream)this.getClass().getClassLoader().getResourceAsStream("AuthKey_533BH3667Q.p8"), (String)"MTGQCB5B3L", (String)"533BH3667Q")).build() : new ApnsClientBuilder().setApnsServer("api.sandbox.push.apple.com").setSigningKey(ApnsSigningKey.loadFromInputStream((InputStream)this.getClass().getClassLoader().getResourceAsStream("AuthKey_533BH3667Q.p8"), (String)"MTGQCB5B3L", (String)"533BH3667Q")).build();
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException e) {
            log.error("ApnsPushUtil init", (Throwable)e);
        }
        pushBundles.put("WDZ", "com.wandianzhang.wdz");
        pushBundles.put("OP", "com.wandianzhang.OPRetail");
        pushBundles.put("MCYP", "com.wandianzhang.MCYP");
        pushBundles.put("TJ", "com.taiji.wandianzhang");
        pushBundles.put("HJXD", "com.wandianzhang.hjxd");
        pushBundles.put("LYF", "com.wandianzhang.lyf");
        pushBundles.put("LBX", "com.lbxdrugs.wandianzhang");
        pushBundles.put("ZHTY", "com.wangxiaobao.wisdomeye");
        pushBundles.put("RLTY", "com.wandianzhang.REYES");
        pushBundles.put("YM", "com.wandianzhang.YM");
        pushBundles.put("JHDX", "com.wandianzhang.JHDX");
        pushBundles.put("KLTD", "com.wandianzhang.KLTD");
        pushBundles.put("ZYY", "com.wandianzhang.ovopark");
        pushBundles.put("SPS", "com.wandianzhang.SPS");
        pushBundles.put("HB", "com.wandianzhang.haiboss");
        pushBundles.put("HKD", "com.wandianzhang.HKD");
        pushBundles.put("YQB", "com.wandianzhang.YQB");
    }

    public static void push(PushNotificationParameter parameter) {
        log.info("apns push: " + JSON.toJSONString((Object)parameter));
        String bundle = pushBundles.get(parameter.getAppKey());
        if (StringUtils.isNotBlank((CharSequence)bundle)) {
            HashMap jsonMsgBody = (HashMap)new ObjectMapper().convertValue((Object)parameter.getBody(), HashMap.class);
            jsonMsgBody.entrySet().removeIf(entry -> entry.getValue() == null);
            String payload = new SimpleApnsPayloadBuilder().setAlertTitle(parameter.getTitle()).setAlertBody(parameter.getMessage()).setSound("default").setBadgeNumber(Integer.valueOf(1)).setMutableContent(true).addCustomProperty("content", (Object)jsonMsgBody).build();
            log.info("apns push. payload:{}", (Object)payload);
            String traceId = MDC.get((String)"traceId");
            String requestId = MDC.get((String)"requestId");
            for (String pushAlias : parameter.getPushAlias()) {
                SimpleApnsPushNotification pushNotification = new SimpleApnsPushNotification(pushAlias, bundle, payload);
                apnsClient.sendNotification((ApnsPushNotification)pushNotification).thenAccept(response -> log.info(traceId + ", " + requestId + ", apns push. payload:{}, result:{}", (Object)payload, (Object)JSON.toJSONString((Object)response)));
            }
        } else {
            log.error("apns push. appKey:{} not found", (Object)parameter.getAppKey());
        }
    }

    public static void main(String[] args) {
        PushNotificationParameter parameter = new PushNotificationParameter();
        parameter.setAppKey("WDZ");
        parameter.setTitle("\u6d4b\u8bd5");
        parameter.setMessage("\u6d4b\u8bd5");
        parameter.getPushAlias().add("cf356d104595ba2f5381f1e577dffb8570adfc351cc648e4eb690c39cc5358bd");
        ApnsPushUtil.push(parameter);
    }
}

