/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.plugins.kernel.controller;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.messagehub.plugins.bridge.ThirdMessage;
import com.ovopark.messagehub.plugins.kernel.module.MessageConfigure;
import com.ovopark.messagehub.plugins.kernel.service.DdMessageService;
import com.ovopark.messagehub.plugins.kernel.service.FsMessageService;
import com.ovopark.messagehub.plugins.kernel.service.MessageConfigureService;
import com.ovopark.messagehub.plugins.kernel.service.MessageService;
import com.ovopark.messagehub.plugins.kernel.service.RPCService;
import com.ovopark.module.shared.BaseResult;
import com.ovopark.organize.common.model.mo.SystemConfigureMo;
import com.ovopark.organize.common.model.pojo.DepartmentPojo;
import com.ovopark.organize.common.model.pojo.UsersPojo;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/thirdMessage"})
public class ThirdMessageController {
    private static final Logger log = LoggerFactory.getLogger(ThirdMessageController.class);
    @Autowired
    private DdMessageService ddMessageService;
    @Autowired
    private FsMessageService fsMessageService;
    @Autowired
    private MessageService messageService;
    @Autowired
    private MessageConfigureService messageConfigureService;
    @Autowired
    private RPCService rpcService;

    @PostMapping(value={"/deleteDdMessage"})
    public BaseResult<Boolean> deleteDdMessage(@RequestParam(value="groupId") Integer groupId, @RequestParam(value="dDMessageId") String dDMessageId, @RequestParam(value="objectType", required=false) String objectType) throws Exception {
        if (StringUtils.isNotEmpty((CharSequence)objectType) && this.checkObjectType(objectType).booleanValue()) {
            return BaseResult.success((Object)true);
        }
        Boolean result = this.ddMessageService.deleteDdMessage(groupId, dDMessageId);
        return BaseResult.success((Object)result);
    }

    @PostMapping(value={"/deleteFeishuMessage"})
    public BaseResult<Boolean> deleteFeishuMessage(@RequestParam(value="groupId") Integer groupId, @RequestParam(value="feishuMessageId") String feishuMessageId, @RequestParam(value="objectType", required=false) String objectType) throws Exception {
        if (StringUtils.isNotEmpty((CharSequence)objectType) && this.checkObjectType(objectType).booleanValue()) {
            return BaseResult.success((Object)true);
        }
        Boolean result = this.fsMessageService.deleteFsMessage(groupId, feishuMessageId);
        return BaseResult.success((Object)result);
    }

    @PostMapping(value={"/deleteQwMessage"})
    public BaseResult<Boolean> deleteQwMessage(@RequestParam(value="groupId") Integer groupId, @RequestParam(value="messageId") String messageId, @RequestParam(value="objectType", required=false) String objectType) throws Exception {
        if (StringUtils.isNotEmpty((CharSequence)objectType) && this.checkObjectType(objectType).booleanValue()) {
            return BaseResult.success((Object)true);
        }
        Boolean result = this.messageService.deleteQWMessage(groupId, messageId);
        return BaseResult.success((Object)result);
    }

    private Boolean checkObjectType(String objectType) {
        AtomicReference<Boolean> isReturn = new AtomicReference<Boolean>(false);
        List<String> objectTypes = this.messageConfigureService.getAllMessageNotDelete();
        if (CollectionUtils.isNotEmpty(objectTypes)) {
            objectTypes.forEach(objectType1 -> {
                if (objectType1.equals(objectType)) {
                    log.info("objectType:{}\u4e0d\u9700\u8981\u5220\u9664", (Object)objectType);
                    isReturn.set(true);
                    return;
                }
            });
        }
        return isReturn.get();
    }

    @PostMapping(value={"/getMessageUrl"})
    public BaseResult<String> getMessageUrl(@RequestBody ThirdMessage thirdMessage) {
        log.info("getMessageUrl: " + JSONAccessor.impl().format((Object)thirdMessage));
        String url = "";
        if (thirdMessage.getEnterpriseId() != null) {
            MessageConfigure thisConfigure = this.messageConfigureService.getMessageConfigure(thirdMessage.getCategory(), thirdMessage.getObjectType(), thirdMessage.getMainType(), thirdMessage.getJsonText());
            if (thirdMessage != null) {
                UsersPojo users = new UsersPojo();
                DepartmentPojo pojo = new DepartmentPojo();
                if (thirdMessage.getDepartmentId() != null) {
                    pojo = this.rpcService.department(thirdMessage.getDepartmentId());
                }
                if (thirdMessage.getTargetUserId() != null) {
                    users = this.rpcService.getUserById(thirdMessage.getTargetUserId());
                }
                url = this.messageConfigureService.getWechartMessageUrl(thisConfigure, new SystemConfigureMo(), thirdMessage, users, null, pojo.getName(), pojo, 1);
            }
        }
        return BaseResult.success((Object)url);
    }
}

