/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.plugins.kernel.service.serviceImpl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ovopark.dingding.sdk.api.DingdingMessageApi;
import com.ovopark.dingding.web.BaseResult;
import com.ovopark.dingding.web.MessageTxtMo;
import com.ovopark.messagehub.plugins.bridge.DDMsg;
import com.ovopark.messagehub.plugins.bridge.MsgContext;
import com.ovopark.messagehub.plugins.bridge.dd.DDMessage;
import com.ovopark.messagehub.plugins.bridge.qw.QWResponse;
import com.ovopark.messagehub.plugins.bridge.reply.MessageReply;
import com.ovopark.messagehub.plugins.kernel.module.MessageConfigure;
import com.ovopark.messagehub.plugins.kernel.module.mo.MessageUserMo;
import com.ovopark.messagehub.plugins.kernel.service.DdMessageService;
import com.ovopark.messagehub.plugins.kernel.service.MessageConfigureService;
import com.ovopark.messagehub.plugins.kernel.service.MessageService;
import com.ovopark.messagehub.plugins.kernel.service.RPCService;
import com.ovopark.messagehub.plugins.kernel.service.SystemConfigureService;
import com.ovopark.messagehub.plugins.kernel.util.NewMessageUtil;
import com.ovopark.messagehub.sdk.model.Subs;
import com.ovopark.organize.common.model.mo.SystemConfigureMo;
import com.ovopark.organize.common.model.pojo.DepartmentPojo;
import com.ovopark.organize.common.model.pojo.UsersPojo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class DdMessageServiceImpl
implements DdMessageService {
    private static final Logger log = LoggerFactory.getLogger(DdMessageServiceImpl.class);
    @Autowired
    private MessageConfigureService messageConfigureService;
    @Autowired
    private RPCService rpcService;
    @Autowired
    private SystemConfigureService systemConfigureService;
    @Autowired
    private MessageService messageService;
    @Autowired
    private DingdingMessageApi dingdingMessageApi;

    @Override
    public List<MessageReply<QWResponse>> sendMessageToUser(List<Integer> usersIds, DDMessage mo, MsgContext<DDMsg> msgMsgContext) {
        List<UsersPojo> usersList;
        DDMsg msg = (DDMsg)msgMsgContext.msg();
        String msgTraceId = msg.getMsgTraceId();
        if (CollectionUtils.isEmpty(usersIds) || mo == null) {
            return new ArrayList<MessageReply<QWResponse>>();
        }
        ArrayList<MessageReply<QWResponse>> messageReplies = new ArrayList<MessageReply<QWResponse>>();
        Integer groupThisId = mo.getEnterpriseId();
        if (groupThisId == null) {
            log.info("groupThisIdNull:" + msgTraceId + " groupThisId:" + groupThisId + "_" + String.valueOf(mo));
            this.resultList(messageReplies, msgMsgContext, null, usersIds, "groupThisIdNull\uff1a\u6e20\u9053\u7ba1\u7406\u914d\u7f6e \u672a\u914d\u7f6e\uff01");
            return messageReplies;
        }
        SystemConfigureMo configure = this.systemConfigureService.getSystemConfigureByGroupId(groupThisId, "", 1);
        if (configure == null || configure.getIsSendMessage() == 0) {
            log.info("configure is null:" + msgTraceId + " groupThisId:" + groupThisId + "messageCode:" + String.valueOf(JSON.toJSON((Object)mo)));
            this.resultList(messageReplies, msgMsgContext, null, usersIds, "SystemConfigureMo\uff1a\u6e20\u9053\u7ba1\u7406\u914d\u7f6e obejctType \u672a\u77e5\uff0c\u4e0d\u53ef\u53d1\u9001\u4e09\u65b9");
            return messageReplies;
        }
        Boolean checkExecution = this.messageService.checkExecution(mo.getCategory(), mo.getObjectType(), mo.getObjectId());
        if (!checkExecution.booleanValue()) {
            log.info("checkExecution:" + msgTraceId + " groupThisId" + groupThisId + "_" + JSON.toJSONString((Object)mo));
            this.resultList(messageReplies, msgMsgContext, null, usersIds, "checkExecution\uff1a\u6e20\u9053\u7ba1\u7406\u914d\u7f6e obejctType \u672a\u77e5\uff0c\u4e0d\u53ef\u53d1\u9001\u4e09\u65b9");
            return messageReplies;
        }
        MessageConfigure thisConfigure = this.messageConfigureService.getMessageConfigure(mo.getCategory(), mo.getObjectType(), mo.getMainType(), mo.getJsonText());
        if (thisConfigure == null) {
            log.info("thisConfigure is null:" + msgTraceId + " groupThisId" + groupThisId + "_" + JSON.toJSONString((Object)mo));
            this.resultList(messageReplies, msgMsgContext, null, usersIds, "thisConfigure\uff1a\u6e20\u9053\u7ba1\u7406\u914d\u7f6e obejctType \u672a\u77e5\uff0c\u4e0d\u53ef\u53d1\u9001\u4e09\u65b9");
            return messageReplies;
        }
        log.info("sendMessageDD start:" + msgTraceId + "mo:" + JSON.toJSONString((Object)mo) + "userIds:" + JSON.toJSONString(usersIds));
        ArrayList<MessageUserMo> batchUser = new ArrayList<MessageUserMo>();
        if (batchUser == null || CollectionUtils.isEmpty(batchUser)) {
            batchUser = new ArrayList();
        }
        Integer userId = mo.getTargetUserId();
        UsersPojo users = null;
        if (userId != null && !usersIds.contains(userId)) {
            usersIds.add(userId);
        }
        if (userId != null) {
            users = this.rpcService.getUserById(userId);
        }
        if (CollectionUtils.isNotEmpty(usersIds) && CollectionUtils.isNotEmpty(usersList = this.rpcService.getUserByIdList(usersIds))) {
            for (UsersPojo user : usersList) {
                if (user == null || !com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotEmpty((CharSequence)user.getDingdingUserId())) continue;
                MessageUserMo userMo = new MessageUserMo();
                userMo.setUserId(user.getId());
                userMo.setTrilateralId(user.getDingdingUserId());
                batchUser.add(userMo);
            }
        }
        if (CollectionUtils.isEmpty(batchUser)) {
            log.info("batchUserNull:" + msgTraceId + "groupThisId:" + groupThisId + "_" + JSON.toJSONString((Object)mo));
            this.resultList(messageReplies, msgMsgContext, null, usersIds, "batchUserNull\uff1a\u672a\u7ed1\u5b9a\u4e09\u65b9\u8d26\u53f7");
            return messageReplies;
        }
        DepartmentPojo pojo = new DepartmentPojo();
        if (mo.getDepartmentId() != null) {
            pojo = this.rpcService.department(mo.getDepartmentId());
        }
        String changeCardType = thisConfigure.getTitle();
        String url = this.messageConfigureService.getWechartMessageUrl(thisConfigure, configure, mo, users, null, pojo.getName(), pojo, null);
        log.info("urlDD:" + msgTraceId + "url:" + url);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String messageType = thisConfigure.getDingdingMessageType();
        String picUrl = thisConfigure.getTitleImage();
        if (StringUtils.isEmpty((Object)mo.getTitleName())) {
            mo.setTitleName(changeCardType);
        }
        Object content = "";
        if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotBlank((CharSequence)mo.getTitleName())) {
            content = mo.getTitleName();
        }
        if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotBlank((CharSequence)mo.getDescription())) {
            content = (String)content + "\r\n" + mo.getDescription();
        }
        if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isBlank((CharSequence)content)) {
            content = changeCardType;
        }
        String key = "\u72b6\u6001";
        String value = NewMessageUtil.changeStatusAdd(mo.getObjectType(), mo.getWStatus(), mo.getCategory());
        if (!StringUtils.isEmpty((Object)value)) {
            content = key + ":" + value + "\r\n" + (String)content;
        }
        content = (String)content + "\r\n\u65e5\u671f\uff1a" + format.format(new Date());
        Integer numberSize = 90;
        if (mo.getSingleAdd().booleanValue()) {
            numberSize = 1;
        }
        ArrayList<String> newUser = new ArrayList<String>();
        ArrayList<Integer> usereIds = new ArrayList<Integer>();
        Integer num = batchUser.size();
        log.info("batchUserSize:" + msgTraceId + "batchUser:" + JSON.toJSONString(batchUser));
        for (MessageUserMo user : batchUser) {
            String dingdingId = user.getTrilateralId();
            newUser.add(dingdingId);
            usereIds.add(user.getUserId());
            if (newUser.size() < numberSize && newUser.size() != batchUser.size()) continue;
            String taskId = this.sendMessage(msgTraceId, newUser, mo, url, thisConfigure, (String)content, messageType, configure);
            this.resultList(messageReplies, msgMsgContext, taskId, usereIds, null);
            num = num - newUser.size();
            newUser = new ArrayList();
            usereIds = new ArrayList();
        }
        return messageReplies;
    }

    @Override
    public Boolean deleteDdMessage(Integer groupId, String messageId) {
        BaseResult result = this.dingdingMessageApi.deleteDdMessagesById(groupId, messageId);
        if (result != null && !result.getIsError().booleanValue()) {
            return (Boolean)result.getData();
        }
        return false;
    }

    private String sendMessage(String msgTraceId, List<String> users, DDMessage mo, String url, MessageConfigure thisConfigure, String content, String messageType, SystemConfigureMo configure) {
        Object message = "";
        try {
            MessageTxtMo param = new MessageTxtMo();
            param.setGroupId(mo.getEnterpriseId());
            param.setMessage(content);
            param.setUsers(users);
            param.setMsgType(messageType);
            param.setUrl(url);
            param.setTitle(mo.getTitleName());
            if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty((CharSequence)param.getTitle())) {
                param.setTitle(thisConfigure.getTitle());
            }
            String msgType = thisConfigure.getDingdingMessageType();
            param.setMsgType(msgType);
            String titleImage = thisConfigure.getTitleImage();
            param.setTitlePicUrl(titleImage);
            param.setPictureName(mo.getPictureName());
            param.setPictureUrl(mo.getPictureUrl());
            param.setAgengId(Long.valueOf(configure.getAgentId()));
            log.info("paramDD:" + msgTraceId + "param:" + JSON.toJSONString((Object)param));
            BaseResult dingding = this.dingdingMessageApi.sendDdMessage(param);
            log.info("paramDD result:" + msgTraceId + "dingding:" + JSON.toJSONString((Object)dingding));
            if (dingding == null || dingding.getIsError().booleanValue()) {
                message = "error:" + String.valueOf(dingding);
                return message;
            }
            return (String)dingding.getData();
        }
        catch (Exception e) {
            message = "error:" + e.getMessage();
            return message;
        }
    }

    public List<MessageReply<QWResponse>> resultList(List<MessageReply<QWResponse>> messageReplies, MsgContext<DDMsg> msgMsgContext, String messageId, List<Integer> userId, String desc) {
        DDMsg msg = (DDMsg)msgMsgContext.msg();
        if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty((CharSequence)messageId) || com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotEmpty((CharSequence)messageId) && messageId.contains("error")) {
            QWResponse fail = new QWResponse();
            ArrayList<String> msgIdList = new ArrayList<String>();
            for (Integer user : userId) {
                String messageCodeId = ((DDMsg)msgMsgContext.msg()).msgIdByUser(user.intValue());
                if (!com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotEmpty((CharSequence)messageCodeId)) continue;
                msgIdList.add(messageCodeId);
            }
            MessageReply failReply = MessageReply.fail((Subs)Subs.DD, (String)msg.getMsgTraceId(), (String)msg.getTaskId(), (String[])msgIdList.toArray(new String[0]));
            failReply.setResponse((Object)fail);
            failReply.setDesc(desc);
            messageReplies.add((MessageReply<QWResponse>)failReply);
        } else {
            HashMap<String, String> msgIdLink2QWMessageIdSuccess = new HashMap<String, String>();
            for (Integer user : userId) {
                String messageCodeId = ((DDMsg)msgMsgContext.msg()).msgIdByUser(user.intValue());
                if (!com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotEmpty((CharSequence)messageCodeId)) continue;
                msgIdLink2QWMessageIdSuccess.put(messageCodeId, messageId);
            }
            QWResponse success = new QWResponse();
            success.setMsgIdLink2QWMessageId(msgIdLink2QWMessageIdSuccess);
            MessageReply successReply = MessageReply.success((Subs)Subs.DD, (String)msg.getMsgTraceId(), (String)msg.getTaskId(), (String[])msgIdLink2QWMessageIdSuccess.keySet().toArray(new String[0]));
            successReply.setResponse((Object)success);
            messageReplies.add((MessageReply<QWResponse>)successReply);
        }
        return messageReplies;
    }
}

