/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.plugins.kernel.service.serviceImpl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ovopark.feishu.sdk.api.FeishuMessageApi;
import com.ovopark.feishu.web.BaseResult;
import com.ovopark.feishu.web.MessageSendMo;
import com.ovopark.messagehub.plugins.bridge.FSMsg;
import com.ovopark.messagehub.plugins.bridge.MsgContext;
import com.ovopark.messagehub.plugins.bridge.fs.FSMessage;
import com.ovopark.messagehub.plugins.bridge.qw.QWResponse;
import com.ovopark.messagehub.plugins.bridge.reply.MessageReply;
import com.ovopark.messagehub.plugins.kernel.module.MessageConfigure;
import com.ovopark.messagehub.plugins.kernel.module.mo.MessageUserMo;
import com.ovopark.messagehub.plugins.kernel.service.FsMessageService;
import com.ovopark.messagehub.plugins.kernel.service.MessageConfigureService;
import com.ovopark.messagehub.plugins.kernel.service.MessageService;
import com.ovopark.messagehub.plugins.kernel.service.RPCService;
import com.ovopark.messagehub.plugins.kernel.service.SystemConfigureService;
import com.ovopark.messagehub.plugins.kernel.util.FsMessageUtil;
import com.ovopark.messagehub.sdk.model.Subs;
import com.ovopark.organize.common.model.mo.SystemConfigureMo;
import com.ovopark.organize.common.model.pojo.DepartmentPojo;
import com.ovopark.organize.common.model.pojo.UsersPojo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class FsMessageServiceImpl
implements FsMessageService {
    private static final Logger log = LoggerFactory.getLogger(FsMessageServiceImpl.class);
    @Autowired
    private MessageConfigureService messageConfigureService;
    @Autowired
    private RPCService rpcService;
    @Autowired
    private SystemConfigureService systemConfigureService;
    @Autowired
    private MessageService messageService;
    @Autowired
    private FeishuMessageApi feishuMessageApi;

    @Override
    public List<MessageReply<QWResponse>> sendMessageToUser(List<Integer> usersIds, FSMessage mo, MsgContext<FSMsg> msgMsgContext) {
        List<UsersPojo> usersList;
        FSMsg msg = (FSMsg)msgMsgContext.msg();
        String msgTraceId = msg.getMsgTraceId();
        if (CollectionUtils.isEmpty(usersIds) || mo == null) {
            return new ArrayList<MessageReply<QWResponse>>();
        }
        ArrayList<MessageReply<QWResponse>> messageReplies = new ArrayList<MessageReply<QWResponse>>();
        Integer groupThisId = mo.getEnterpriseId();
        if (groupThisId == null) {
            log.info("groupThisIdNull:" + msgTraceId + "groupThisId:" + groupThisId + "_" + String.valueOf(mo));
            this.resultList(messageReplies, msgMsgContext, null, usersIds, "groupThisIdNull\uff1a\u6e20\u9053\u7ba1\u7406\u914d\u7f6e \u672a\u914d\u7f6e\uff01");
            return messageReplies;
        }
        SystemConfigureMo configure = this.systemConfigureService.getSystemConfigureByGroupId(groupThisId, "", 2);
        if (configure == null || configure.getIsSendMessage() == 0) {
            log.info("configure is null:" + msgTraceId + "groupThisId:" + groupThisId + "messageCode:" + String.valueOf(JSON.toJSON((Object)mo)));
            this.resultList(messageReplies, msgMsgContext, null, usersIds, "SystemConfigureMo\uff1a\u6e20\u9053\u7ba1\u7406\u914d\u7f6e obejctType \u672a\u77e5\uff0c\u4e0d\u53ef\u53d1\u9001\u4e09\u65b9");
            return messageReplies;
        }
        Boolean checkExecution = this.messageService.checkExecution(mo.getCategory(), mo.getObjectType(), mo.getObjectId());
        if (!checkExecution.booleanValue()) {
            log.info("checkExecution:" + msgTraceId + "groupThisId:" + groupThisId + "_" + JSON.toJSONString((Object)mo));
            this.resultList(messageReplies, msgMsgContext, null, usersIds, "checkExecution\uff1a\u6e20\u9053\u7ba1\u7406\u914d\u7f6e obejctType \u672a\u77e5\uff0c\u4e0d\u53ef\u53d1\u9001\u4e09\u65b9");
            return messageReplies;
        }
        MessageConfigure thisConfigure = this.messageConfigureService.getMessageConfigure(mo.getCategory(), mo.getObjectType(), mo.getMainType(), mo.getJsonText());
        if (thisConfigure == null) {
            log.info("thisConfigure is null:" + msgTraceId + "groupThisId:" + groupThisId + "_" + JSON.toJSONString((Object)mo));
            this.resultList(messageReplies, msgMsgContext, null, usersIds, "thisConfigure\uff1a\u6e20\u9053\u7ba1\u7406\u914d\u7f6e obejctType \u672a\u77e5\uff0c\u4e0d\u53ef\u53d1\u9001\u4e09\u65b9");
            return messageReplies;
        }
        log.info("sendMessageToUser feishu:" + msgTraceId + "mo:" + JSON.toJSONString((Object)mo) + "userIds:" + JSON.toJSONString(usersIds));
        ArrayList<MessageUserMo> batchUser = new ArrayList<MessageUserMo>();
        if (batchUser == null || CollectionUtils.isEmpty(batchUser)) {
            batchUser = new ArrayList();
        }
        Integer userId = mo.getTargetUserId();
        UsersPojo users = null;
        if (userId != null && !usersIds.contains(userId)) {
            usersIds.add(userId);
        }
        if (userId != null) {
            users = this.rpcService.getUserById(userId);
        }
        if (CollectionUtils.isNotEmpty(usersIds) && CollectionUtils.isNotEmpty(usersList = this.rpcService.getUserByIdList(usersIds))) {
            for (UsersPojo user : usersList) {
                if (user == null || !com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotEmpty((CharSequence)user.getFeishuUserId())) continue;
                MessageUserMo userMo = new MessageUserMo();
                userMo.setUserId(user.getId());
                userMo.setTrilateralId(user.getFeishuOpenId());
                batchUser.add(userMo);
            }
        }
        if (CollectionUtils.isEmpty(batchUser)) {
            log.info("batchUserNull:" + msgTraceId + "groupThisId:" + groupThisId + "_" + JSON.toJSONString((Object)mo));
            this.resultList(messageReplies, msgMsgContext, null, usersIds, "batchUserNull\uff1a\u672a\u7ed1\u5b9a\u4e09\u65b9\u8d26\u53f7");
            return messageReplies;
        }
        DepartmentPojo pojo = new DepartmentPojo();
        if (mo.getDepartmentId() != null) {
            pojo = this.rpcService.department(mo.getDepartmentId());
        }
        String changeCardType = thisConfigure.getTitle();
        String url = this.messageConfigureService.getWechartMessageUrl(thisConfigure, configure, mo, users, null, pojo.getName(), pojo, null);
        log.info("url feishu:" + msgTraceId + "url:" + url);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String messageType = thisConfigure.getFeishuMessageType();
        String picUrl = thisConfigure.getTitleImage();
        if (StringUtils.isEmpty((Object)mo.getTitleName())) {
            mo.setTitleName(changeCardType);
        }
        String imageKey = this.imgKey(mo.getPictureUrl(), mo.getEnterpriseId(), mo.getPictureName());
        String contentText = FsMessageUtil.getContentText(messageType, url, mo, imageKey);
        Integer numSize = 90;
        if (mo.getSingleAdd().booleanValue()) {
            numSize = 1;
        }
        ArrayList<String> newUser = new ArrayList<String>();
        ArrayList<Integer> userIds = new ArrayList<Integer>();
        log.info("batchUser feishu:" + msgTraceId + "batchUser:" + JSON.toJSONString(batchUser));
        Integer num = batchUser.size();
        for (MessageUserMo userMo : batchUser) {
            userIds.add(userMo.getUserId());
            newUser.add(userMo.getTrilateralId());
            if (newUser.size() < numSize && newUser.size() != num.intValue()) continue;
            String taskId = this.sendMessage(msgTraceId, mo.getEnterpriseId(), newUser, messageType, contentText);
            this.resultList(messageReplies, msgMsgContext, taskId, userIds, "");
            num = num - newUser.size();
            newUser = new ArrayList();
            userIds = new ArrayList();
        }
        return messageReplies;
    }

    @Override
    public Boolean deleteFsMessage(Integer groupId, String messageId) {
        log.info("deleteFsMessage:" + groupId + "_" + messageId);
        BaseResult baseResult = this.feishuMessageApi.deleteMessageByFeishuTaskId(groupId, messageId);
        log.info("deleteFsMessage:" + JSON.toJSONString((Object)baseResult));
        if (baseResult != null && !baseResult.getIsError().booleanValue()) {
            return (Boolean)baseResult.getData();
        }
        return false;
    }

    private String imgKey(String pictureUrl, Integer groupId, String pictureName) {
        if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotEmpty((CharSequence)pictureUrl) && groupId != null && com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotEmpty((CharSequence)pictureName)) {
            MessageSendMo mo = new MessageSendMo();
            mo.setGroupId(groupId);
            mo.setPictureUrl(pictureUrl);
            mo.setPictureName(pictureName);
            BaseResult imgKey = this.feishuMessageApi.getImgKey(mo);
            if (imgKey != null && !imgKey.getIsError().booleanValue()) {
                return (String)imgKey.getData();
            }
        }
        return "";
    }

    private String sendMessage(String msgTraceId, Integer groupId, List<String> users, String messageType, String contentText) {
        MessageSendMo mo = new MessageSendMo();
        mo.setGroupId(groupId);
        mo.setContent(contentText);
        mo.setToUser(users);
        mo.setMsgType(messageType);
        log.info("sendMessageFs:" + msgTraceId + "mo:" + JSON.toJSONString((Object)mo));
        BaseResult task = this.feishuMessageApi.sendMessageByGroupId(mo);
        log.info("sendMessageFs result:" + msgTraceId + "task:" + JSON.toJSONString((Object)task));
        if (task != null && !task.getIsError().booleanValue()) {
            return (String)task.getData();
        }
        return "";
    }

    public List<MessageReply<QWResponse>> resultList(List<MessageReply<QWResponse>> messageReplies, MsgContext<FSMsg> msgMsgContext, String messageId, List<Integer> userId, String desc) {
        FSMsg msg = (FSMsg)msgMsgContext.msg();
        if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty((CharSequence)messageId) || com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotEmpty((CharSequence)messageId) && messageId.contains("error")) {
            QWResponse fail = new QWResponse();
            ArrayList<String> msgIdList = new ArrayList<String>();
            for (Integer user : userId) {
                String messageCodeId = ((FSMsg)msgMsgContext.msg()).msgIdByUser(user.intValue());
                if (!com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotEmpty((CharSequence)messageCodeId)) continue;
                msgIdList.add(messageCodeId);
            }
            MessageReply failReply = MessageReply.fail((Subs)Subs.FS, (String)msg.getMsgTraceId(), (String)msg.getTaskId(), (String[])msgIdList.toArray(new String[0]));
            failReply.setResponse((Object)fail);
            failReply.setDesc(desc);
            messageReplies.add((MessageReply<QWResponse>)failReply);
        } else {
            HashMap<String, String> msgIdLink2QWMessageIdSuccess = new HashMap<String, String>();
            for (Integer user : userId) {
                String messageCodeId = ((FSMsg)msgMsgContext.msg()).msgIdByUser(user.intValue());
                if (!com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotEmpty((CharSequence)messageCodeId)) continue;
                msgIdLink2QWMessageIdSuccess.put(messageCodeId, messageId);
            }
            QWResponse success = new QWResponse();
            success.setMsgIdLink2QWMessageId(msgIdLink2QWMessageIdSuccess);
            MessageReply successReply = MessageReply.success((Subs)Subs.FS, (String)msg.getMsgTraceId(), (String)msg.getTaskId(), (String[])msgIdLink2QWMessageIdSuccess.keySet().toArray(new String[0]));
            successReply.setResponse((Object)success);
            messageReplies.add((MessageReply<QWResponse>)successReply);
        }
        return messageReplies;
    }
}

