/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.plugins.kernel.service.serviceImpl;

import com.ovopark.messagehub.plugins.kernel.service.SubsRateLimiterClient;
import com.ovopark.messagehub.sdk.model.Subs;
import com.ovopark.module.shared.redis.RateLimiter;
import com.ovopark.module.shared.redis.RateLimiterClient;
import com.ovopark.module.shared.redis.RateLimiterConf;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SubsRateLimiterClientImpl
implements SubsRateLimiterClient {
    @Autowired
    RateLimiterClient rateLimiterClient;

    @Override
    public RateLimiter get(Subs subs) {
        return this.rateLimiterClient.get("messagehub.rate." + subs.getName().toLowerCase());
    }

    @Override
    public RateLimiter upset(Subs subs, RateLimiterConf rateLimiterConf) {
        return this.rateLimiterClient.upset("messagehub.rate." + subs.getName().toLowerCase(), rateLimiterConf);
    }

    @Override
    public RateLimiter upset(Subs subs, int ratePerSec) {
        return this.rateLimiterClient.upset("messagehub.rate." + subs.getName().toLowerCase(), ratePerSec);
    }

    @Override
    public RateLimiter setIfAbsent(Subs subs, int ratePerSec) {
        return this.rateLimiterClient.setIfAbsent("messagehub.rate." + subs.getName().toLowerCase(), ratePerSec);
    }

    @Override
    public RateLimiter setIfAbsent(Subs subs, int groupId, int ratePerSec) {
        return this.rateLimiterClient.setIfAbsent(SubsRateLimiterClientImpl.key(subs, groupId), ratePerSec);
    }

    @Override
    public RateLimiter get(Subs subs, int groupId) {
        return this.rateLimiterClient.get(SubsRateLimiterClientImpl.key(subs, groupId));
    }

    private static String key(Subs subs, int groupId) {
        return "messagehub.rate.group." + groupId + "." + subs.getName().toLowerCase();
    }
}

