/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.plugins.kernel.config;

import com.ovopark.messagehub.plugins.kernel.config.MsgHubKafkaSharedConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.annotation.EnableKafka;
import org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.springframework.kafka.config.KafkaListenerContainerFactory;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaProducerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.core.ProducerFactory;
import org.springframework.kafka.listener.ConcurrentMessageListenerContainer;

@EnableKafka
@Configuration
public class KafkaMainConfig {
    private static final Logger log = LoggerFactory.getLogger(KafkaMainConfig.class);
    @Autowired
    private MsgHubKafkaSharedConfig msgHubKafkaSharedConfig;
    @Value(value="${messagehub.plugins.kafka.main.bootstrap-servers}")
    private String bootstrapServers;
    @Value(value="${messagehub.plugins.kafka.main.consumer.group-id}")
    private String groupId;
    @Value(value="${messagehub.plugins.kafka.main.consumer.enable-auto-commit:true}")
    private boolean enableAutoCommit;
    @Value(value="${messagehub.plugins.kafka.main.consumer.max-poll-records:30}")
    private int maxPollRecords;
    @Value(value="${messagehub.plugins.kafka.main.consumer.max-poll-interval-ms:300000}")
    private int maxPollIntervalMs;

    @Bean(value={"mainKafkaContainerFactory"})
    KafkaListenerContainerFactory<ConcurrentMessageListenerContainer<Integer, String>> mainKafkaContainerFactory() {
        ConcurrentKafkaListenerContainerFactory factory = new ConcurrentKafkaListenerContainerFactory();
        factory.setConsumerFactory(this.consumerFactory());
        factory.setConcurrency(Integer.valueOf(3));
        factory.getContainerProperties().setPollTimeout(3000L);
        return factory;
    }

    @Bean(value={"jgKafkaContainerFactory"})
    KafkaListenerContainerFactory<ConcurrentMessageListenerContainer<Integer, String>> jgKafkaContainerFactory() {
        ConcurrentKafkaListenerContainerFactory factory = new ConcurrentKafkaListenerContainerFactory();
        factory.setConsumerFactory(this.consumerFactory());
        factory.setConcurrency(Integer.valueOf(3));
        factory.getContainerProperties().setPollTimeout(3000L);
        return factory;
    }

    @Bean(value={"mailKafkaContainerFactory"})
    KafkaListenerContainerFactory<ConcurrentMessageListenerContainer<Integer, String>> mailKafkaContainerFactory() {
        ConcurrentKafkaListenerContainerFactory factory = new ConcurrentKafkaListenerContainerFactory();
        factory.setConsumerFactory(this.consumerFactory());
        factory.setConcurrency(Integer.valueOf(3));
        factory.getContainerProperties().setPollTimeout(3000L);
        return factory;
    }

    @Bean(value={"smsKafkaContainerFactory"})
    KafkaListenerContainerFactory<ConcurrentMessageListenerContainer<Integer, String>> smsKafkaContainerFactory() {
        ConcurrentKafkaListenerContainerFactory factory = new ConcurrentKafkaListenerContainerFactory();
        factory.setConsumerFactory(this.consumerFactory());
        factory.setConcurrency(Integer.valueOf(3));
        factory.getContainerProperties().setPollTimeout(3000L);
        return factory;
    }

    @Bean(value={"qwKafkaContainerFactory"})
    KafkaListenerContainerFactory<ConcurrentMessageListenerContainer<Integer, String>> qwKafkaContainerFactory() {
        ConcurrentKafkaListenerContainerFactory factory = new ConcurrentKafkaListenerContainerFactory();
        factory.setConsumerFactory(this.consumerFactory());
        factory.setConcurrency(Integer.valueOf(3));
        factory.getContainerProperties().setPollTimeout(3000L);
        return factory;
    }

    @Bean(value={"ddKafkaContainerFactory"})
    KafkaListenerContainerFactory<ConcurrentMessageListenerContainer<Integer, String>> ddKafkaContainerFactory() {
        ConcurrentKafkaListenerContainerFactory factory = new ConcurrentKafkaListenerContainerFactory();
        factory.setConsumerFactory(this.consumerFactory());
        factory.setConcurrency(Integer.valueOf(3));
        factory.getContainerProperties().setPollTimeout(3000L);
        return factory;
    }

    @Bean(value={"fsKafkaContainerFactory"})
    KafkaListenerContainerFactory<ConcurrentMessageListenerContainer<Integer, String>> fsKafkaContainerFactory() {
        ConcurrentKafkaListenerContainerFactory factory = new ConcurrentKafkaListenerContainerFactory();
        factory.setConsumerFactory(this.consumerFactory());
        factory.setConcurrency(Integer.valueOf(3));
        factory.getContainerProperties().setPollTimeout(3000L);
        return factory;
    }

    @Bean(value={"gzhKafkaContainerFactory"})
    KafkaListenerContainerFactory<ConcurrentMessageListenerContainer<Integer, String>> gzhKafkaContainerFactory() {
        ConcurrentKafkaListenerContainerFactory factory = new ConcurrentKafkaListenerContainerFactory();
        factory.setConsumerFactory(this.consumerFactory());
        factory.setConcurrency(Integer.valueOf(3));
        factory.getContainerProperties().setPollTimeout(3000L);
        return factory;
    }

    @Bean(value={"voiceKafkaContainerFactory"})
    KafkaListenerContainerFactory<ConcurrentMessageListenerContainer<Integer, String>> voiceKafkaContainerFactory() {
        ConcurrentKafkaListenerContainerFactory factory = new ConcurrentKafkaListenerContainerFactory();
        factory.setConsumerFactory(this.consumerFactory());
        factory.setConcurrency(Integer.valueOf(3));
        factory.getContainerProperties().setPollTimeout(3000L);
        return factory;
    }

    @Bean(value={"wechatUserBindKafkaContainerFactory"})
    KafkaListenerContainerFactory<ConcurrentMessageListenerContainer<Integer, String>> wechatUserBindKafkaContainerFactory() {
        ConcurrentKafkaListenerContainerFactory factory = new ConcurrentKafkaListenerContainerFactory();
        factory.setConsumerFactory(this.consumerFactory());
        factory.setConcurrency(Integer.valueOf(3));
        factory.getContainerProperties().setPollTimeout(3000L);
        return factory;
    }

    public ConsumerFactory<Integer, String> consumerFactory() {
        return new DefaultKafkaConsumerFactory(this.consumerConfigs());
    }

    private Map<String, Object> consumerConfigs() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        Map<String, Object> extPros = this.msgHubKafkaSharedConfig.getExtPros();
        if (extPros != null) {
            extPros.forEach((k, v) -> {
                log.info(k + " : " + String.valueOf(v));
                props.put(k.replaceAll("-", "."), v);
            });
        }
        props.put("bootstrap.servers", this.bootstrapServers);
        props.put("group.id", Optional.ofNullable(this.groupId).orElse("messagehub-group"));
        props.put("enable.auto.commit", this.enableAutoCommit);
        props.put("key.deserializer", StringDeserializer.class);
        props.put("value.deserializer", StringDeserializer.class);
        props.put("max.poll.records", this.maxPollRecords);
        props.put("max.poll.interval.ms", this.maxPollIntervalMs);
        return props;
    }

    @Bean(value={"kafkaMainTemplate"})
    public KafkaTemplate<String, String> kafkaMainTemplate() {
        return new KafkaTemplate(this.producerFactory());
    }

    private ProducerFactory<String, String> producerFactory() {
        return new DefaultKafkaProducerFactory(this.producerConfigs());
    }

    private Map<String, Object> producerConfigs() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        Map<String, Object> extPros = this.msgHubKafkaSharedConfig.getExtPros();
        if (extPros != null) {
            extPros.forEach((k, v) -> {
                log.info(k + " : " + String.valueOf(v));
                props.put(k.replaceAll("-", "."), v);
            });
        }
        props.put("bootstrap.servers", this.bootstrapServers);
        props.put("retries", 0);
        props.put("acks", "1");
        props.put("key.serializer", StringSerializer.class);
        props.put("value.serializer", StringSerializer.class);
        return props;
    }
}

