/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.plugins.kernel.service.serviceImpl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ovopark.messagehub.plugins.bridge.MsgContext;
import com.ovopark.messagehub.plugins.bridge.QWMsg;
import com.ovopark.messagehub.plugins.bridge.qw.QWResponse;
import com.ovopark.messagehub.plugins.bridge.reply.MessageReply;
import com.ovopark.messagehub.plugins.kernel.module.MessageConfigure;
import com.ovopark.messagehub.plugins.kernel.module.QWMessage;
import com.ovopark.messagehub.plugins.kernel.module.mo.MessageUserMo;
import com.ovopark.messagehub.plugins.kernel.service.MessageConfigureService;
import com.ovopark.messagehub.plugins.kernel.service.MessageService;
import com.ovopark.messagehub.plugins.kernel.service.RPCService;
import com.ovopark.messagehub.plugins.kernel.service.SystemConfigureService;
import com.ovopark.messagehub.plugins.kernel.util.NewMessageUtil;
import com.ovopark.messagehub.sdk.model.Subs;
import com.ovopark.organize.common.model.mo.SystemConfigureMo;
import com.ovopark.organize.common.model.pojo.DepartmentPojo;
import com.ovopark.organize.common.model.pojo.UsersPojo;
import com.ovopark.thirdparty.sdk.api.ThirdpartyMessageApi;
import com.ovopark.thirdparty.web.BaseResult;
import com.ovopark.thirdparty.web.CardMessagePojo;
import com.ovopark.thirdparty.web.MeaasgeBo;
import com.ovopark.thirdparty.web.TemplateMessagePojo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MessageServiceImpl
implements MessageService {
    private static final Logger log = LoggerFactory.getLogger(MessageServiceImpl.class);
    @Autowired
    private RPCService rpcService;
    @Autowired
    private SystemConfigureService systemConfigureService;
    @Autowired
    private ThirdpartyMessageApi thirdpartyMessageApi;
    @Autowired
    private MessageConfigureService messageConfigureService;

    @Override
    public Boolean checkExecution(String category, String objectType, Integer objectId) {
        if (StringUtils.isEmpty((CharSequence)category) && StringUtils.isEmpty((CharSequence)objectType)) {
            return false;
        }
        return true;
    }

    @Override
    public List<MessageReply<QWResponse>> sendMessageToUser(List<Integer> userIds, QWMessage mo, MsgContext<QWMsg> msgMsgContext) {
        String weixinMessagId;
        QWMsg msg = (QWMsg)msgMsgContext.msg();
        String msgTraceId = msg.getMsgTraceId();
        ArrayList<MessageReply<QWResponse>> messageReplies = new ArrayList<MessageReply<QWResponse>>();
        Integer groupThisId = mo.getEnterpriseId();
        if (groupThisId == null) {
            log.info("groupThisIdNull:" + msgTraceId + "groupThisId:" + groupThisId + "_" + String.valueOf((Object)mo));
            this.resultList(messageReplies, msgMsgContext, null, userIds, "groupThisIdNull\uff1a\u6e20\u9053\u7ba1\u7406\u914d\u7f6e \u672a\u914d\u7f6e\uff01");
            return messageReplies;
        }
        SystemConfigureMo configure = this.systemConfigureService.getSystemConfigureByGroupId(groupThisId, null, 0);
        if (configure == null || configure.getIsSendMessage() == 0) {
            log.info("configure is null:" + msgTraceId + "groupThisId:" + groupThisId + "messageCode:" + String.valueOf(JSON.toJSON((Object)((Object)mo))) + "getIsSendMessage:" + String.valueOf(JSON.toJSON((Object)configure)));
            this.resultList(messageReplies, msgMsgContext, null, userIds, "SystemConfigureMo\uff1a\u6e20\u9053\u7ba1\u7406\u914d\u7f6e obejctType \u672a\u77e5\uff0c\u4e0d\u53ef\u53d1\u9001\u4e09\u65b9");
            return messageReplies;
        }
        log.info("sendMessageToUser configure:" + msgTraceId + "_" + JSON.toJSONString(userIds) + "mo:" + JSON.toJSONString((Object)((Object)mo)) + "configure:" + JSON.toJSONString((Object)configure));
        Boolean checkExecution = this.checkExecution(mo.getCategory(), mo.getObjectType(), mo.getObjectId());
        if (!checkExecution.booleanValue()) {
            log.info("checkExecution:" + groupThisId + "_" + JSON.toJSONString((Object)((Object)mo)));
            this.resultList(messageReplies, msgMsgContext, null, userIds, "checkExecution\uff1a\u6e20\u9053\u7ba1\u7406\u914d\u7f6e obejctType \u672a\u77e5\uff0c\u4e0d\u53ef\u53d1\u9001\u4e09\u65b9");
            return messageReplies;
        }
        MessageConfigure thisConfigure = this.messageConfigureService.getMessageConfigure(mo.getCategory(), mo.getObjectType(), mo.getMainType(), mo.getJsonText());
        log.info("sendMessageToUser start:" + msgTraceId + "mo:" + JSON.toJSONString((Object)((Object)mo)) + "userIds:" + JSON.toJSONString(userIds));
        ArrayList<MessageUserMo> batchUser = new ArrayList<MessageUserMo>();
        if (batchUser == null || CollectionUtils.isEmpty(batchUser)) {
            batchUser = new ArrayList();
        }
        Integer userId = mo.getTargetUserId();
        UsersPojo users = null;
        if (userId != null && !userIds.contains(userId)) {
            userIds.add(userId);
        }
        if (CollectionUtils.isNotEmpty(userIds)) {
            users = this.rpcService.getUserById(userId);
            List<UsersPojo> usersList = this.rpcService.getUserByIdList(userIds);
            if (CollectionUtils.isNotEmpty(usersList)) {
                for (UsersPojo user : usersList) {
                    if (user == null || !StringUtils.isNotEmpty((CharSequence)user.getTrilateralId()) && !StringUtils.isNotEmpty((CharSequence)user.getEncryptionUserid())) continue;
                    MessageUserMo userMo = new MessageUserMo();
                    userMo.setUserId(user.getId());
                    userMo.setEncryptionUserid(user.getEncryptionUserid());
                    userMo.setTrilateralId(user.getTrilateralId());
                    batchUser.add(userMo);
                }
            }
        }
        if (CollectionUtils.isEmpty(batchUser)) {
            log.info("batchUserNull:" + msgTraceId + "groupThisId:" + groupThisId + "_" + JSON.toJSONString((Object)((Object)mo)));
            this.resultList(messageReplies, msgMsgContext, null, userIds, "batchUserNull\uff1a\u672a\u7ed1\u5b9a\u4e09\u65b9\u8d26\u53f7");
            return messageReplies;
        }
        ArrayList<MessageUserMo> toUserId = new ArrayList<MessageUserMo>();
        Boolean isAuth = false;
        if (StringUtils.isNotEmpty((CharSequence)configure.getEncryptionCorpid()) && StringUtils.isNotEmpty((CharSequence)configure.getAuthInfoAgentid())) {
            isAuth = true;
        }
        for (MessageUserMo usermo : batchUser) {
            Boolean saveMessage = true;
            String oneToUser = "";
            if (usermo.getTrilateralId() != null && StringUtils.isNotEmpty((CharSequence)usermo.getTrilateralId())) {
                oneToUser = usermo.getTrilateralId();
            } else if (StringUtils.isNotEmpty((CharSequence)usermo.getEncryptionUserid())) {
                oneToUser = usermo.getEncryptionUserid();
            }
            if (isAuth.booleanValue() && StringUtils.isNotEmpty((CharSequence)usermo.getEncryptionUserid())) {
                oneToUser = usermo.getEncryptionUserid();
            }
            if (StringUtils.isNotEmpty((CharSequence)oneToUser)) {
                usermo.setSendMessageUserId(oneToUser);
            }
            if (!mo.getSingleAdd().booleanValue() && !toUserId.contains(oneToUser)) {
                toUserId.add(usermo);
                saveMessage = false;
            }
            if (StringUtils.isEmpty((CharSequence)oneToUser)) {
                log.info("batchUsersnull:" + msgTraceId + "usermo:" + JSON.toJSONString((Object)usermo));
                continue;
            }
            if (!saveMessage.booleanValue()) continue;
            try {
                if (!mo.getSingleAdd().booleanValue()) continue;
                ArrayList<String> newUserOne = new ArrayList<String>();
                newUserOne.add(oneToUser);
                weixinMessagId = null;
                try {
                    weixinMessagId = this.sendMessageNew(msgTraceId, mo, configure, newUserOne, users, thisConfigure);
                    ArrayList<Integer> sendUserId = new ArrayList<Integer>();
                    sendUserId.add(usermo.getUserId());
                    this.resultList(messageReplies, msgMsgContext, weixinMessagId, sendUserId, null);
                }
                catch (Exception e) {
                    ArrayList<Integer> sendUserId = new ArrayList<Integer>();
                    sendUserId.add(usermo.getUserId());
                    this.resultList(messageReplies, msgMsgContext, weixinMessagId, sendUserId, e.getMessage());
                }
            }
            catch (Exception e) {
                log.info("saveOrUpdateBean==" + String.valueOf(JSON.toJSON((Object)usermo)) + String.valueOf(e));
            }
        }
        if (CollectionUtils.isNotEmpty(toUserId)) {
            log.info("toUserId:" + JSON.toJSONString(toUserId));
            ArrayList<String> newUser = new ArrayList<String>();
            ArrayList<Integer> sendUserId = new ArrayList<Integer>();
            Integer num = toUserId.size();
            for (int i = 0; i < toUserId.size(); ++i) {
                MessageUserMo usermo = (MessageUserMo)toUserId.get(i);
                newUser.add(usermo.getSendMessageUserId());
                sendUserId.add(usermo.getUserId());
                if (newUser.size() < 300 && newUser.size() != num.intValue()) continue;
                weixinMessagId = null;
                try {
                    weixinMessagId = this.sendMessageNew(msgTraceId, mo, configure, newUser, users, thisConfigure);
                    this.resultList(messageReplies, msgMsgContext, weixinMessagId, sendUserId, null);
                    num = num - newUser.size();
                    newUser = new ArrayList();
                    sendUserId = new ArrayList();
                    continue;
                }
                catch (Exception e) {
                    this.resultList(messageReplies, msgMsgContext, null, sendUserId, e.getMessage());
                }
            }
        }
        return messageReplies;
    }

    @Override
    public List<MessageReply<QWResponse>> resultList(List<MessageReply<QWResponse>> messageReplies, MsgContext<QWMsg> msgMsgContext, String messageId, List<Integer> userId, String errorDesc) {
        QWMsg msg = (QWMsg)msgMsgContext.msg();
        if (StringUtils.isEmpty((CharSequence)messageId) || StringUtils.isNotEmpty((CharSequence)messageId) && messageId.contains("error")) {
            QWResponse fail = new QWResponse();
            ArrayList<String> msgIdList = new ArrayList<String>();
            for (Integer user : userId) {
                String messageCodeId = ((QWMsg)msgMsgContext.msg()).msgIdByUser(user.intValue());
                if (!StringUtils.isNotEmpty((CharSequence)messageCodeId)) continue;
                msgIdList.add(messageCodeId);
            }
            MessageReply failReply = MessageReply.fail((Subs)Subs.QW, (String)msg.getMsgTraceId(), (String)msg.getTaskId(), (String[])msgIdList.toArray(new String[0]));
            failReply.setResponse((Object)fail);
            failReply.setDesc(errorDesc);
            messageReplies.add((MessageReply<QWResponse>)failReply);
        } else {
            HashMap<String, String> msgIdLink2QWMessageIdSuccess = new HashMap<String, String>();
            for (Integer user : userId) {
                String messageCodeId = ((QWMsg)msgMsgContext.msg()).msgIdByUser(user.intValue());
                if (!StringUtils.isNotEmpty((CharSequence)messageCodeId)) continue;
                msgIdLink2QWMessageIdSuccess.put(messageCodeId, messageId);
            }
            QWResponse success = new QWResponse();
            success.setMsgIdLink2QWMessageId(msgIdLink2QWMessageIdSuccess);
            MessageReply successReply = MessageReply.success((Subs)Subs.QW, (String)msg.getMsgTraceId(), (String)msg.getTaskId(), (String[])msgIdLink2QWMessageIdSuccess.keySet().toArray(new String[0]));
            successReply.setResponse((Object)success);
            messageReplies.add((MessageReply<QWResponse>)successReply);
        }
        return messageReplies;
    }

    @Override
    public Boolean deleteQWMessage(Integer groupId, String messageId) {
        log.info("deleteQWMessage:" + groupId + "messageId:" + messageId);
        BaseResult baseResult = this.thirdpartyMessageApi.recall(groupId, messageId);
        log.info("deleteQWMessage: result:" + JSON.toJSONString((Object)baseResult));
        if (baseResult != null && !baseResult.getIsError().booleanValue()) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean deleteBatchQWMessage(Integer groupId, List<String> messageIds) {
        if (CollectionUtils.isNotEmpty(messageIds) && groupId != null) {
            MeaasgeBo meaasgeBo = new MeaasgeBo();
            meaasgeBo.setGroupId(groupId);
            meaasgeBo.setMsgIds(messageIds);
            SystemConfigureMo configure = this.systemConfigureService.getSystemConfigureByGroupId(groupId, "", 0);
            if (configure != null) {
                Integer oauthType = null;
                if (StringUtils.isNotEmpty((CharSequence)configure.getAuthInfoAgentid())) {
                    oauthType = 1;
                }
                meaasgeBo.setOauthType(oauthType);
            }
            log.info("deleteBatchQWMessage:" + JSON.toJSONString((Object)meaasgeBo));
            BaseResult result = this.thirdpartyMessageApi.batchRecall(meaasgeBo);
            log.info("deleteBatchQWMessage: result:" + JSON.toJSONString((Object)result));
            if (result != null && !result.getIsError().booleanValue()) {
                return true;
            }
        }
        return false;
    }

    private String sendMessageNew(String msgTraceId, QWMessage mo, SystemConfigureMo configure, List<String> toUserId, UsersPojo users, MessageConfigure thisConfigure) {
        log.info("sendMessageNew:" + msgTraceId + "mo:" + JSON.toJSONString((Object)((Object)mo)) + "toUserId:" + JSON.toJSONString(toUserId) + "users:" + JSON.toJSONString((Object)users) + "thisConfigure:" + JSON.toJSONString((Object)thisConfigure));
        String messageFirstUrl = thisConfigure.getPrefixUrl();
        Object weixinMessagId = "";
        Integer groupId = mo.getEnterpriseId();
        String cardType = thisConfigure.getTitle();
        String status = NewMessageUtil.changeStatusByCategoryOrMessageCode(mo.getObjectType(), mo.getWStatus(), mo.getCategory());
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
        if (CollectionUtils.isNotEmpty(toUserId)) {
            Object url;
            String date = dateFormat.format(new Date());
            String depName = "";
            DepartmentPojo dep = new DepartmentPojo();
            if (mo.getDepartmentId() != null) {
                dep = this.rpcService.department(mo.getDepartmentId());
                if (dep != null) {
                    depName = dep.getName();
                }
                if (dep == null) {
                    log.info("\u95e8\u5e97\u4e3a\u7a7a:" + JSON.toJSONString((Object)((Object)mo)));
                }
            }
            Integer oauthType = 0;
            Boolean isAuth = false;
            if (StringUtils.isNotEmpty((CharSequence)configure.getEncryptionCorpid()) && StringUtils.isNotEmpty((CharSequence)configure.getAuthInfoAgentid())) {
                isAuth = true;
                if (!mo.getCategory().equals("Authorized_USER")) {
                    oauthType = 1;
                }
            }
            if (StringUtils.isEmpty((CharSequence)(url = this.messageConfigureService.getWechartMessageUrl(thisConfigure, configure, (Object)mo, users, oauthType, depName, dep, null))) && !thisConfigure.getWechartMessageType().equals("text")) {
                throw new IllegalStateException("url\u4e3a\u7a7a");
            }
            if (isAuth.booleanValue() && StringUtils.isNotEmpty((CharSequence)url)) {
                ArrayList<String> nullOauthType = new ArrayList<String>();
                nullOauthType.add("Authorized_USER");
                if (!nullOauthType.contains(mo.getCategory())) {
                    url = (String)url + "&oauthType=1";
                }
            }
            if (oauthType == 0) {
                oauthType = null;
            }
            switch (thisConfigure.getWechartMessageType()) {
                case "templateCard": {
                    String titleName = mo.getTitleName();
                    if (StringUtils.isEmpty((CharSequence)titleName)) {
                        titleName = cardType;
                    }
                    String pictureUrl = "";
                    if (StringUtils.isNotEmpty((CharSequence)mo.getPictureUrl())) {
                        pictureUrl = mo.getPictureUrl();
                    }
                    String msg = NewMessageUtil.getMsgByType(mo.getObjectType(), (String)url, cardType, titleName, mo.getDescription(), status, depName, mo.getObjectId().intValue(), mo.getEnterpriseId(), mo.getDetails(), thisConfigure, pictureUrl);
                    if (!CollectionUtils.isNotEmpty(toUserId)) break;
                    TemplateMessagePojo pojo = new TemplateMessagePojo();
                    pojo.setGroupId(groupId);
                    pojo.setMessage(msg);
                    pojo.setOauthType(oauthType);
                    pojo.setToUserList(toUserId);
                    log.info("sendTemplateMessageToUser\uff1a" + msgTraceId + "pojo:" + JSON.toJSONString((Object)pojo));
                    BaseResult result = this.thirdpartyMessageApi.sendTemplateMessageToUser(pojo);
                    log.info("sendTemplateMessageToUser:" + msgTraceId + "result:" + JSON.toJSONString((Object)result));
                    if (result == null || result.getIsError().booleanValue()) {
                        log.info("getMsgByType" + JSON.toJSONString((Object)((Object)mo)) + "result:" + JSON.toJSONString((Object)result));
                        weixinMessagId = "error:" + JSON.toJSONString((Object)result);
                        break;
                    }
                    weixinMessagId = ((JSONObject)result.getData()).get((Object)"msgid").toString();
                    break;
                }
                case "text": {
                    if (!CollectionUtils.isNotEmpty(toUserId)) break;
                    Object descriptionTest = "";
                    if (StringUtils.isNotEmpty((CharSequence)mo.getTitleName())) {
                        descriptionTest = mo.getTitleName() + "\r\n";
                    }
                    descriptionTest = (String)descriptionTest + mo.getDescription();
                    TemplateMessagePojo pojo = new TemplateMessagePojo();
                    pojo.setGroupId(groupId);
                    pojo.setMessage((String)descriptionTest);
                    pojo.setOauthType(oauthType);
                    pojo.setToUserList(toUserId);
                    log.info("sendMessageToUser\uff1a" + msgTraceId + "pojo:" + JSON.toJSONString((Object)pojo));
                    BaseResult weixinMessagIdResult = this.thirdpartyMessageApi.sendMessageToUser(pojo);
                    log.info("sendMessageToUser:" + msgTraceId + "result:" + JSON.toJSONString((Object)weixinMessagIdResult));
                    if (weixinMessagIdResult == null || weixinMessagIdResult.getIsError().booleanValue()) {
                        log.info("sendTextCardMessage:text toUserId:" + users.getUserName() + " Result:" + JSON.toJSONString((Object)weixinMessagIdResult));
                        weixinMessagId = "error:" + JSON.toJSONString((Object)weixinMessagIdResult);
                        break;
                    }
                    weixinMessagId = (String)weixinMessagIdResult.getData();
                    break;
                }
                default: {
                    if (!CollectionUtils.isNotEmpty(toUserId)) break;
                    String description = "<div class=\"gray\">" + date + "</div>";
                    StringBuffer buf = new StringBuffer();
                    buf.append(description);
                    if (StringUtils.isNotEmpty((CharSequence)mo.getTitleName())) {
                        buf.append(mo.getTitleName());
                        buf.append("\r\n");
                    }
                    buf.append(mo.getDescription());
                    CardMessagePojo pojo = new CardMessagePojo();
                    pojo.setDescription(buf.toString());
                    pojo.setGroupId(groupId);
                    pojo.setOauthType(oauthType);
                    pojo.setToUserList(toUserId);
                    pojo.setTitle(cardType);
                    pojo.setUrl((String)url);
                    log.info("sendTextCardMessage\uff1a" + msgTraceId + "pojo:" + JSON.toJSONString((Object)pojo));
                    BaseResult weixinMessagIdResult = this.thirdpartyMessageApi.sendTextCardMessage(pojo);
                    log.info("sendTextCardMessage:" + msgTraceId + "pojo:" + JSON.toJSONString((Object)pojo) + "result:" + JSON.toJSONString((Object)weixinMessagIdResult));
                    if (weixinMessagIdResult == null || weixinMessagIdResult.getIsError().booleanValue()) {
                        log.info("sendTextCardMessage: default toUserId:" + users.getUserName() + " Result:" + JSON.toJSONString((Object)weixinMessagIdResult));
                        weixinMessagId = "error:" + JSON.toJSONString((Object)weixinMessagIdResult);
                        break;
                    }
                    weixinMessagId = (String)weixinMessagIdResult.getData();
                }
            }
        }
        return weixinMessagId;
    }
}

