/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.plugins.kernel.util;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ovopark.messagehub.plugins.bridge.fs.FSMessage;
import com.ovopark.messagehub.plugins.kernel.module.feishu.MessageContentVo;
import com.ovopark.messagehub.plugins.kernel.util.NewMessageUtil;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FsMessageUtil {
    private static final Logger log = LoggerFactory.getLogger(FsMessageUtil.class);

    public static String getContentText(String messageType, String url, FSMessage mo, String imageKey) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Object content = format.format(new Date());
        if (StringUtils.isNotBlank((CharSequence)mo.getDescription())) {
            content = (String)content + "\n" + mo.getDescription();
        }
        String key = "\u72b6\u6001";
        String value = NewMessageUtil.changeStatusAdd(mo.getObjectType(), mo.getWStatus(), mo.getCategory());
        if (!org.springframework.util.StringUtils.isEmpty((Object)value)) {
            content = key + ":" + value + "\r\n" + (String)content;
        }
        log.info("content==" + ((String)content).trim());
        String picUrl = NewMessageUtil.getImageByType(mo.getObjectType());
        switch (messageType) {
            case "interactive": {
                HashMap<String, Cloneable> messageText = new HashMap<String, Cloneable>();
                HashMap<String, Boolean> messageWide = new HashMap<String, Boolean>();
                messageWide.put("wide_screen_mode", true);
                messageText.put("config", messageWide);
                ArrayList elements = new ArrayList();
                if (StringUtils.isNotEmpty((CharSequence)imageKey)) {
                    HashMap<String, Object> pictureVo = new HashMap<String, Object>();
                    HashMap<String, String> alt = new HashMap<String, String>();
                    alt.put("content", "");
                    alt.put("tag", "plain_text");
                    pictureVo.put("alt", alt);
                    pictureVo.put("tag", "img");
                    pictureVo.put("img_key", imageKey);
                    elements.add(pictureVo);
                }
                HashMap<String, Object> messageContent = new HashMap<String, Object>();
                messageContent.put("tag", "div");
                MessageContentVo contentVo = new MessageContentVo();
                if (!(!StringUtils.isNotEmpty((CharSequence)url) || StringUtils.isNotEmpty((CharSequence)content) && ((String)content).contains("\u70b9\u51fb\u67e5\u770b") || ((String)content).contains("\u70b9\u51fb\u67e5\u770b\u8be6\u60c5") || ((String)content).contains("\u70b9\u51fb\u5b66\u4e60") || ((String)content).contains("\u70b9\u51fb\u53bb\u6279\u9605"))) {
                    content = (String)content + "\n\u70b9\u51fb\u67e5\u770b\u8be6\u60c5!";
                }
                contentVo.setContent((String)content);
                contentVo.setTag("lark_md");
                messageContent.put("text", contentVo);
                elements.add(messageContent);
                if (StringUtils.isNotEmpty((CharSequence)url)) {
                    HashMap<String, Object> linkMap = new HashMap<String, Object>();
                    linkMap.put("url", url);
                    try {
                        String pcUrl = URLEncoder.encode(url);
                        linkMap.put("pc_url", "https://applink.feishu.cn/client/web_url/open?mode=window&url=" + pcUrl);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    messageText.put("card_link", linkMap);
                }
                HashMap<String, Object> messageHead = new HashMap<String, Object>();
                messageHead.put("template", "turquoise");
                MessageContentVo contentVoHead = new MessageContentVo();
                contentVoHead.setTag("plain_text");
                contentVoHead.setContent(mo.getTitleName());
                messageHead.put("title", contentVoHead);
                messageText.put("elements", elements);
                messageText.put("header", messageHead);
                content = JSONObject.toJSONString(messageText);
                log.info("content===" + (String)content);
                break;
            }
            case "file_key": {
                content = "";
                break;
            }
            case "text": {
                if (StringUtils.isNotBlank((CharSequence)mo.getTitleName())) {
                    content = mo.getTitleName() + "\n" + (String)content;
                }
                content = "{'text':" + (String)content + "}";
            }
        }
        return content;
    }
}

