/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.plugins.kernel.service.serviceImpl;

import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.messagehub.sdk.internal.MessageHubInternalApi;
import com.ovopark.messagehub.sdk.model.internal.Node;
import com.ovopark.messagehub.sdk.model.internal.PluginsService;
import com.ovopark.module.shared.BaseResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.stereotype.Component;

@Component
public class PluginsServiceViaFeign
implements PluginsService {
    private static final Logger log = LoggerFactory.getLogger(PluginsServiceViaFeign.class);
    @Autowired
    private ServiceInstance serviceInstance;
    @Autowired
    private MessageHubInternalApi messageHubInternalApi;

    public String ip() {
        return this.serviceInstance.getHost();
    }

    public void heartbeat(Node node) {
        BaseResult baseResult = this.messageHubInternalApi.heartbeat(node);
        if (baseResult != null && baseResult.getIsError().booleanValue()) {
            log.info("heartbeat error: " + JSONAccessor.impl().format((Object)node));
        }
    }
}

