/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.plugins.kernel.util;

import com.ovopark.kernel.shared.Util;
import com.ovopark.messagehub.plugins.kernel.MsgHubPluginsSharedConfig;
import com.ovopark.messagehub.plugins.kernel.service.SubsRateLimiterClient;
import com.ovopark.messagehub.sdk.model.Subs;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

@Component
public class SubsRateLimiterInit
implements CommandLineRunner {
    @Autowired
    SubsRateLimiterClient subsRateLimiterClient;
    @Autowired
    MsgHubPluginsSharedConfig msgHubPluginsSharedConfig;

    public void run(String ... args) throws Exception {
        Set<Integer> limitFsRateGroupIdList;
        this.subsRateLimiterClient.setIfAbsent(Subs.JG, 1000);
        this.subsRateLimiterClient.setIfAbsent(Subs.MAIL, 20);
        this.subsRateLimiterClient.setIfAbsent(Subs.VOICE, 20);
        this.subsRateLimiterClient.setIfAbsent(Subs.SMS, 100);
        this.subsRateLimiterClient.setIfAbsent(Subs.JG, 100);
        this.subsRateLimiterClient.setIfAbsent(Subs.DD, 100);
        this.subsRateLimiterClient.setIfAbsent(Subs.QW, 100);
        this.subsRateLimiterClient.setIfAbsent(Subs.FS, 100);
        this.subsRateLimiterClient.setIfAbsent(Subs.GZH, 100);
        Set<Integer> limitDdRateGroupIdList = this.msgHubPluginsSharedConfig.getLimitDdRateGroupIdList();
        if (Util.isNotEmpty(limitDdRateGroupIdList)) {
            for (Integer i : limitDdRateGroupIdList) {
                this.subsRateLimiterClient.setIfAbsent(Subs.DD, i, 20);
                Util.log.info("configure rate (" + String.valueOf(Subs.DD) + "), group id: " + i);
            }
        }
        if (Util.isNotEmpty(limitFsRateGroupIdList = this.msgHubPluginsSharedConfig.getLimitFsRateGroupIdList())) {
            for (Integer i : limitFsRateGroupIdList) {
                this.subsRateLimiterClient.setIfAbsent(Subs.FS, i, 20);
                Util.log.info("configure rate (" + String.valueOf(Subs.DD) + "), group id: " + i);
            }
        }
    }
}

