/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.plugins.kernel.service.serviceImpl;

import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import com.ovopark.messagehub.plugins.bridge.KafkaReply;
import com.ovopark.messagehub.plugins.bridge.MsgContext;
import com.ovopark.messagehub.plugins.bridge.reply.MessageReply;
import jakarta.annotation.Resource;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.support.SendResult;
import org.springframework.stereotype.Component;

@Component
public class KafkaReplyImpl
implements KafkaReply {
    private static final Logger log = LoggerFactory.getLogger(KafkaReplyImpl.class);
    @Resource(name="kafkaMainTemplate")
    protected KafkaTemplate kafkaMainTemplate;

    public void reply(String topic, MessageReply messageReply, final MsgContext<?> msgContext) {
        String msgTraceId = messageReply.getMsgTraceId();
        String taskId = messageReply.getTaskId();
        CompletableFuture future = this.kafkaMainTemplate.send(topic, (Object)(Util.isNotEmpty((CharSequence)msgTraceId) ? msgTraceId : (Util.isNotEmpty((CharSequence)taskId) ? taskId : null)), (Object)JSONAccessor.impl().format((Object)messageReply));
        future.handleAsync(new BiFunction<SendResult, Throwable, Object>(){

            @Override
            public Object apply(SendResult result, Throwable ex) {
                if (ex != null) {
                    msgContext.logger().error(log, ex, ex.getMessage());
                    return null;
                }
                RecordMetadata metadata = result.getRecordMetadata();
                int partition = metadata.partition();
                long offset = metadata.offset();
                msgContext.logger().info(log, "record,partition: " + partition + ", offset:" + offset);
                return null;
            }
        });
    }
}

