/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.plugins.kernel.util;

import com.ovopark.kernel.shared.Util;
import com.ovopark.messagehub.plugins.kernel.ConditionOnSubs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class SubsCondition
implements Condition {
    private static final Logger log = LoggerFactory.getLogger(SubsCondition.class);

    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        String activeSubs = context.getEnvironment().getProperty("MESSAGEHUB_SUBS_ACTIVE");
        if (Util.isEmpty((CharSequence)activeSubs)) {
            log.warn("[off] inactive bean class: " + metadata.toString());
            return false;
        }
        if (activeSubs.equalsIgnoreCase("ALL")) {
            log.warn("[all] active bean class: " + metadata.toString());
            return true;
        }
        MergedAnnotation condition = metadata.getAnnotations().get(ConditionOnSubs.class);
        String subs = condition.getValue("value").orElse(null);
        if (Util.isEmpty((CharSequence)subs)) {
            log.warn("[off] inactive bean class: " + metadata.toString());
            return false;
        }
        if (activeSubs.contains(subs)) {
            log.warn("[" + subs + "] active bean class: " + metadata.toString());
            return true;
        }
        return false;
    }
}

