/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.plugins.mail;

import com.ovopark.kernel.shared.stream.CoreSubscriber;
import com.ovopark.messagehub.plugins.bridge.KafkaReply;
import com.ovopark.messagehub.plugins.bridge.MailMsg;
import com.ovopark.messagehub.plugins.bridge.MsgContext;
import com.ovopark.messagehub.plugins.bridge.mail.MailMessage;
import com.ovopark.messagehub.plugins.bridge.reply.MessageReply;
import com.ovopark.messagehub.plugins.mail.MailSender;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailSubscriber
extends CoreSubscriber<MsgContext<MailMsg>> {
    private static final Logger log = LoggerFactory.getLogger(MailSubscriber.class);
    private final KafkaReply kafkaReply;
    private final MailSender mailSender;

    public MailSubscriber(KafkaReply kafkaReply, MailSender mailSender) {
        this.kafkaReply = kafkaReply;
        this.mailSender = mailSender;
    }

    public void onNext(MsgContext<MailMsg> msgMsgContext) {
        MailMsg msg = (MailMsg)msgMsgContext.msg();
        MailMessage payload = (MailMessage)msg.getBody();
        List<MessageReply<?>> messageReplyList = this.mailSender.send(payload, msgMsgContext);
        for (MessageReply<?> messageReply : messageReplyList) {
            this.kafkaReply.reply("messagehub-plugins-reply", messageReply, msgMsgContext);
        }
    }
}

