/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.plugins.mock;

import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.stream.CoreSubscriber;
import com.ovopark.messagehub.plugins.bridge.KafkaReply;
import com.ovopark.messagehub.plugins.bridge.Msg;
import com.ovopark.messagehub.plugins.bridge.MsgContext;
import com.ovopark.messagehub.plugins.bridge.jg.JGMessage;
import com.ovopark.messagehub.plugins.bridge.mail.MailMessage;
import com.ovopark.messagehub.plugins.bridge.reply.MessageReply;
import com.ovopark.messagehub.sdk.model.Subs;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockSubscriber
extends CoreSubscriber<MsgContext<Msg<?>>> {
    private static final Logger log = LoggerFactory.getLogger(MockSubscriber.class);
    private final KafkaReply kafkaReply;

    public MockSubscriber(KafkaReply kafkaReply) {
        this.kafkaReply = kafkaReply;
    }

    public void onNext(MsgContext<Msg<?>> msgMsgContext) {
        Msg msg = msgMsgContext.msg();
        Subs subs = msg.getSubs();
        MessageReply successReply = null;
        MessageReply failReply = null;
        if (subs == Subs.JG) {
            MessageReply success;
            JGMessage jgMessage = (JGMessage)JSONAccessor.impl().read(JSONAccessor.impl().format(msg.getBody()), JGMessage.class);
            List userIds = jgMessage.getUserIds();
            Random random = new Random();
            int size = userIds.size();
            int index = random.nextInt(0, size);
            List successUserList = userIds.subList(0, index);
            List failUserList = userIds.subList(index, size);
            String[] stringArray = new String[1];
            stringArray[0] = Arrays.toString(successUserList.stream().map(arg_0 -> ((Msg)msg).msgIdByUser(arg_0)).toList().toArray(new String[0]));
            successReply = success = MessageReply.success((Subs)Subs.JG, (String)msg.getMsgTraceId(), (String)msg.getTaskId(), (String[])stringArray);
            String[] stringArray2 = new String[1];
            stringArray2[0] = Arrays.toString(failUserList.stream().map(arg_0 -> ((Msg)msg).msgIdByUser(arg_0)).toList().toArray(new String[0]));
            MessageReply fail = MessageReply.fail((Subs)Subs.JG, (String)msg.getMsgTraceId(), (String)msg.getTaskId(), (String[])stringArray2);
            fail.setDesc("mock fail");
            failReply = fail;
        } else if (subs == Subs.MAIL) {
            MessageReply success;
            MailMessage mailMessage = (MailMessage)JSONAccessor.impl().read(JSONAccessor.impl().format(msg.getBody()), MailMessage.class);
            List toMailAddressList = mailMessage.getToMailAddressList();
            Random random = new Random();
            int size = toMailAddressList.size();
            int index = random.nextInt(0, size);
            List successMailList = toMailAddressList.subList(0, index);
            List failMailAddress = toMailAddressList.subList(index, size);
            String[] stringArray = new String[1];
            stringArray[0] = Arrays.toString(successMailList.stream().map(arg_0 -> ((Msg)msg).msgIdByMail(arg_0)).toList().toArray(new String[0]));
            successReply = success = MessageReply.success((Subs)Subs.MAIL, (String)msg.getMsgTraceId(), (String)msg.getTaskId(), (String[])stringArray);
            String[] stringArray3 = new String[1];
            stringArray3[0] = Arrays.toString(failMailAddress.stream().map(arg_0 -> ((Msg)msg).msgIdByMail(arg_0)).toList().toArray(new String[0]));
            MessageReply fail = MessageReply.fail((Subs)Subs.MAIL, (String)msg.getMsgTraceId(), (String)msg.getTaskId(), (String[])stringArray3);
            fail.setDesc("mock fail");
            failReply = fail;
        }
        if (successReply != null) {
            this.kafkaReply.reply("messagehub-plugins-reply", successReply, msgMsgContext);
        }
        if (failReply != null) {
            this.kafkaReply.reply("messagehub-plugins-reply", failReply, msgMsgContext);
        }
    }
}

