/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.messagehub.plugins.qw;

import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.stream.Stream;
import com.ovopark.kernel.shared.stream.Subscriber;
import com.ovopark.messagehub.plugins.bridge.KafkaReply;
import com.ovopark.messagehub.plugins.bridge.Msg;
import com.ovopark.messagehub.plugins.bridge.MsgContext;
import com.ovopark.messagehub.plugins.bridge.QWMsg;
import com.ovopark.messagehub.plugins.kernel.ConditionOnSubs;
import com.ovopark.messagehub.plugins.kernel.service.SubsRateLimiterClient;
import com.ovopark.messagehub.plugins.qw.QWSender;
import com.ovopark.messagehub.plugins.qw.QWSubscriber;
import com.ovopark.messagehub.sdk.model.Subs;
import com.ovopark.messagehub.sdk.model.internal.PluginsManager;
import com.ovopark.module.shared.redis.RateLimiter;
import java.util.HashMap;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Component;

@ConditionOnSubs(value="QW")
@Component
public class QWInStream {
    private static final Logger log = LoggerFactory.getLogger(QWInStream.class);
    @Autowired
    private KafkaReply kafkaReply;
    @Autowired
    private QWSender qwSender;
    @Autowired
    private SubsRateLimiterClient subsRateLimiterClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KafkaListener(concurrency="${messagehub.plugins.qw.kafka.concurrency:10}", properties={"partition.assignment.strategy:org.apache.kafka.clients.consumer.CooperativeStickyAssignor"}, topicPattern="messagehub-plugins-qw", groupId="${messagehub.plugins.qw.kafka.group:messagehub-group-qw}", containerFactory="qwKafkaContainerFactory")
    public void message(ConsumerRecord<String, Object> record) {
        String topic = record.topic();
        int partition = record.partition();
        long offset = record.offset();
        log.info(Thread.currentThread().hashCode() + ",topic: " + topic + ", partition: " + partition + ", offset: " + offset);
        Object value = record.value();
        QWMsg msg = (QWMsg)JSONAccessor.impl().read((String)value, QWMsg.class);
        log.info(msg.getMsgTraceId() + " from KAFKA: " + String.valueOf(value));
        RateLimiter rateLimiter = this.subsRateLimiterClient.get(Subs.QW);
        rateLimiter.acquire();
        String msgTraceId = msg.getMsgTraceId();
        MDC.put((String)"requestId", (String)msgTraceId);
        MDC.put((String)"traceId", (String)msgTraceId);
        try {
            Stream.from((Object)new MsgContext(msgTraceId, (Msg)msg)).doFinally(s -> {
                HashMap<String, String> meta = new HashMap<String, String>();
                meta.put("msgTraceId", msgTraceId);
                PluginsManager.getOrCreate().heartbeat(Subs.QW, meta);
            }).subscribe((Subscriber)new QWSubscriber(this.kafkaReply, this.qwSender));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            MDC.remove((String)"requestId");
            MDC.remove((String)"traceId");
        }
    }
}

